// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.model



/**
 * The request parameters represent the input of a request to run one or more SQL statements.
 */
class ExecuteSqlRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster. Enter the database user name and password for the credentials in the secret.
     *
     * For information about creating the secret, see [Create a database secret](https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html).
     */
    val awsSecretStoreArn: kotlin.String? = builder.awsSecretStoreArn
    /**
     * The name of the database.
     */
    val database: kotlin.String? = builder.database
    /**
     * The ARN of the Aurora Serverless DB cluster.
     */
    val dbClusterOrInstanceArn: kotlin.String? = builder.dbClusterOrInstanceArn
    /**
     * The name of the database schema.
     */
    val schema: kotlin.String? = builder.schema
    /**
     * One or more SQL statements to run on the DB cluster.
     *
     * You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted, including data definition, data manipulation, and commit statements.
     */
    val sqlStatements: kotlin.String? = builder.sqlStatements

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rdsdata.model.ExecuteSqlRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteSqlRequest(")
        append("awsSecretStoreArn=$awsSecretStoreArn,")
        append("database=$database,")
        append("dbClusterOrInstanceArn=$dbClusterOrInstanceArn,")
        append("schema=$schema,")
        append("sqlStatements=$sqlStatements)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsSecretStoreArn?.hashCode() ?: 0
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbClusterOrInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (sqlStatements?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecuteSqlRequest

        if (awsSecretStoreArn != other.awsSecretStoreArn) return false
        if (database != other.database) return false
        if (dbClusterOrInstanceArn != other.dbClusterOrInstanceArn) return false
        if (schema != other.schema) return false
        if (sqlStatements != other.sqlStatements) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rdsdata.model.ExecuteSqlRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster. Enter the database user name and password for the credentials in the secret.
         *
         * For information about creating the secret, see [Create a database secret](https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html).
         */
        var awsSecretStoreArn: kotlin.String? = null
        /**
         * The name of the database.
         */
        var database: kotlin.String? = null
        /**
         * The ARN of the Aurora Serverless DB cluster.
         */
        var dbClusterOrInstanceArn: kotlin.String? = null
        /**
         * The name of the database schema.
         */
        var schema: kotlin.String? = null
        /**
         * One or more SQL statements to run on the DB cluster.
         *
         * You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted, including data definition, data manipulation, and commit statements.
         */
        var sqlStatements: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rdsdata.model.ExecuteSqlRequest) : this() {
            this.awsSecretStoreArn = x.awsSecretStoreArn
            this.database = x.database
            this.dbClusterOrInstanceArn = x.dbClusterOrInstanceArn
            this.schema = x.schema
            this.sqlStatements = x.sqlStatements
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rdsdata.model.ExecuteSqlRequest = ExecuteSqlRequest(this)
    }
}
