// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.model



/**
 * The response elements represent the output of a request to run a SQL statement against a database.
 */
class ExecuteStatementResponse private constructor(builder: Builder) {
    /**
     * Metadata for the columns included in the results. This field is blank if the `formatRecordsAs` parameter is set to `JSON`.
     */
    val columnMetadata: List<ColumnMetadata>? = builder.columnMetadata
    /**
     * A string value that represents the result set of a `SELECT` statement in JSON format. This value is only present when the `formatRecordsAs` parameter is set to `JSON`.
     *
     * The size limit for this field is currently 10 MB. If the JSON-formatted string representing the result set requires more than 10 MB, the call returns an error.
     */
    val formattedRecords: kotlin.String? = builder.formattedRecords
    /**
     * Values for fields generated during a DML request.
     *
     * The `generatedFields` data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the `RETURNING` clause. For more information, see [Returning Data From Modified Rows](https://www.postgresql.org/docs/10/dml-returning.html) in the PostgreSQL documentation.
     */
    val generatedFields: List<Field>? = builder.generatedFields
    /**
     * The number of records updated by the request.
     */
    val numberOfRecordsUpdated: kotlin.Long = builder.numberOfRecordsUpdated
    /**
     * The records returned by the SQL statement. This field is blank if the `formatRecordsAs` parameter is set to `JSON`.
     */
    val records: List<List<Field>>? = builder.records

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteStatementResponse(")
        append("columnMetadata=$columnMetadata,")
        append("formattedRecords=$formattedRecords,")
        append("generatedFields=$generatedFields,")
        append("numberOfRecordsUpdated=$numberOfRecordsUpdated,")
        append("records=$records)")
    }

    override fun hashCode(): kotlin.Int {
        var result = columnMetadata?.hashCode() ?: 0
        result = 31 * result + (formattedRecords?.hashCode() ?: 0)
        result = 31 * result + (generatedFields?.hashCode() ?: 0)
        result = 31 * result + (numberOfRecordsUpdated.hashCode())
        result = 31 * result + (records?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecuteStatementResponse

        if (columnMetadata != other.columnMetadata) return false
        if (formattedRecords != other.formattedRecords) return false
        if (generatedFields != other.generatedFields) return false
        if (numberOfRecordsUpdated != other.numberOfRecordsUpdated) return false
        if (records != other.records) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Metadata for the columns included in the results. This field is blank if the `formatRecordsAs` parameter is set to `JSON`.
         */
        var columnMetadata: List<ColumnMetadata>? = null
        /**
         * A string value that represents the result set of a `SELECT` statement in JSON format. This value is only present when the `formatRecordsAs` parameter is set to `JSON`.
         *
         * The size limit for this field is currently 10 MB. If the JSON-formatted string representing the result set requires more than 10 MB, the call returns an error.
         */
        var formattedRecords: kotlin.String? = null
        /**
         * Values for fields generated during a DML request.
         *
         * The `generatedFields` data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the `RETURNING` clause. For more information, see [Returning Data From Modified Rows](https://www.postgresql.org/docs/10/dml-returning.html) in the PostgreSQL documentation.
         */
        var generatedFields: List<Field>? = null
        /**
         * The number of records updated by the request.
         */
        var numberOfRecordsUpdated: kotlin.Long = 0L
        /**
         * The records returned by the SQL statement. This field is blank if the `formatRecordsAs` parameter is set to `JSON`.
         */
        var records: List<List<Field>>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementResponse) : this() {
            this.columnMetadata = x.columnMetadata
            this.formattedRecords = x.formattedRecords
            this.generatedFields = x.generatedFields
            this.numberOfRecordsUpdated = x.numberOfRecordsUpdated
            this.records = x.records
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementResponse = ExecuteStatementResponse(this)
    }
}
