// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.model



/**
 * Contains the value of a column.
 *
 * This data structure is only used with the deprecated `ExecuteSql` operation. Use the `BatchExecuteStatement` or `ExecuteStatement` operation instead.
 */
sealed class Value {
    /**
     * An array of column values.
     */
    data class ArrayValues(val value: List<Value>) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of big integer data type.
     */
    data class BigIntValue(val value: kotlin.Long) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of BIT data type.
     */
    data class BitValue(val value: kotlin.Boolean) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of BLOB data type.
     */
    data class BlobValue(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.rdsdata.model.Value() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as BlobValue

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }
    /**
     * A value for a column of double data type.
     */
    data class DoubleValue(val value: kotlin.Double) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of integer data type.
     */
    data class IntValue(val value: kotlin.Int) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A NULL value.
     */
    data class IsNull(val value: kotlin.Boolean) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of real data type.
     */
    data class RealValue(val value: kotlin.Float) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of string data type.
     */
    data class StringValue(val value: kotlin.String) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of STRUCT data type.
     */
    data class StructValue(val value: aws.sdk.kotlin.services.rdsdata.model.StructValue) : aws.sdk.kotlin.services.rdsdata.model.Value()
    object SdkUnknown : aws.sdk.kotlin.services.rdsdata.model.Value()

    /**
     * Casts this [Value] as a [ArrayValues] and retrieves its [List<Value>] value. Throws an exception if the [Value] is not a
     * [ArrayValues].
     */
    fun asArrayValues(): List<Value> = (this as Value.ArrayValues).value

    /**
     * Casts this [Value] as a [ArrayValues] and retrieves its [List<Value>] value. Returns null if the [Value] is not a [ArrayValues].
     */
    fun asArrayValuesOrNull(): List<Value>? = (this as? Value.ArrayValues)?.value

    /**
     * Casts this [Value] as a [BigIntValue] and retrieves its [kotlin.Long] value. Throws an exception if the [Value] is not a
     * [BigIntValue].
     */
    fun asBigIntValue(): kotlin.Long = (this as Value.BigIntValue).value

    /**
     * Casts this [Value] as a [BigIntValue] and retrieves its [kotlin.Long] value. Returns null if the [Value] is not a [BigIntValue].
     */
    fun asBigIntValueOrNull(): kotlin.Long? = (this as? Value.BigIntValue)?.value

    /**
     * Casts this [Value] as a [BitValue] and retrieves its [kotlin.Boolean] value. Throws an exception if the [Value] is not a
     * [BitValue].
     */
    fun asBitValue(): kotlin.Boolean = (this as Value.BitValue).value

    /**
     * Casts this [Value] as a [BitValue] and retrieves its [kotlin.Boolean] value. Returns null if the [Value] is not a [BitValue].
     */
    fun asBitValueOrNull(): kotlin.Boolean? = (this as? Value.BitValue)?.value

    /**
     * Casts this [Value] as a [BlobValue] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [Value] is not a
     * [BlobValue].
     */
    fun asBlobValue(): kotlin.ByteArray = (this as Value.BlobValue).value

    /**
     * Casts this [Value] as a [BlobValue] and retrieves its [kotlin.ByteArray] value. Returns null if the [Value] is not a [BlobValue].
     */
    fun asBlobValueOrNull(): kotlin.ByteArray? = (this as? Value.BlobValue)?.value

    /**
     * Casts this [Value] as a [DoubleValue] and retrieves its [kotlin.Double] value. Throws an exception if the [Value] is not a
     * [DoubleValue].
     */
    fun asDoubleValue(): kotlin.Double = (this as Value.DoubleValue).value

    /**
     * Casts this [Value] as a [DoubleValue] and retrieves its [kotlin.Double] value. Returns null if the [Value] is not a [DoubleValue].
     */
    fun asDoubleValueOrNull(): kotlin.Double? = (this as? Value.DoubleValue)?.value

    /**
     * Casts this [Value] as a [IntValue] and retrieves its [kotlin.Int] value. Throws an exception if the [Value] is not a
     * [IntValue].
     */
    fun asIntValue(): kotlin.Int = (this as Value.IntValue).value

    /**
     * Casts this [Value] as a [IntValue] and retrieves its [kotlin.Int] value. Returns null if the [Value] is not a [IntValue].
     */
    fun asIntValueOrNull(): kotlin.Int? = (this as? Value.IntValue)?.value

    /**
     * Casts this [Value] as a [IsNull] and retrieves its [kotlin.Boolean] value. Throws an exception if the [Value] is not a
     * [IsNull].
     */
    fun asIsNull(): kotlin.Boolean = (this as Value.IsNull).value

    /**
     * Casts this [Value] as a [IsNull] and retrieves its [kotlin.Boolean] value. Returns null if the [Value] is not a [IsNull].
     */
    fun asIsNullOrNull(): kotlin.Boolean? = (this as? Value.IsNull)?.value

    /**
     * Casts this [Value] as a [RealValue] and retrieves its [kotlin.Float] value. Throws an exception if the [Value] is not a
     * [RealValue].
     */
    fun asRealValue(): kotlin.Float = (this as Value.RealValue).value

    /**
     * Casts this [Value] as a [RealValue] and retrieves its [kotlin.Float] value. Returns null if the [Value] is not a [RealValue].
     */
    fun asRealValueOrNull(): kotlin.Float? = (this as? Value.RealValue)?.value

    /**
     * Casts this [Value] as a [StringValue] and retrieves its [kotlin.String] value. Throws an exception if the [Value] is not a
     * [StringValue].
     */
    fun asStringValue(): kotlin.String = (this as Value.StringValue).value

    /**
     * Casts this [Value] as a [StringValue] and retrieves its [kotlin.String] value. Returns null if the [Value] is not a [StringValue].
     */
    fun asStringValueOrNull(): kotlin.String? = (this as? Value.StringValue)?.value

    /**
     * Casts this [Value] as a [StructValue] and retrieves its [aws.sdk.kotlin.services.rdsdata.model.StructValue] value. Throws an exception if the [Value] is not a
     * [StructValue].
     */
    fun asStructValue(): aws.sdk.kotlin.services.rdsdata.model.StructValue = (this as Value.StructValue).value

    /**
     * Casts this [Value] as a [StructValue] and retrieves its [aws.sdk.kotlin.services.rdsdata.model.StructValue] value. Returns null if the [Value] is not a [StructValue].
     */
    fun asStructValueOrNull(): aws.sdk.kotlin.services.rdsdata.model.StructValue? = (this as? Value.StructValue)?.value
}

/**
 * Casts this [Value] as a [ArrayValues] and retrieves its [List<Value>] value.
 */
val Value.ArrayValues get() = (this as Value.ArrayValues).value

/**
 * Casts this [Value] as a [BigIntValue] and retrieves its [kotlin.Long] value.
 */
val Value.BigIntValue get() = (this as Value.BigIntValue).value

/**
 * Casts this [Value] as a [BitValue] and retrieves its [kotlin.Boolean] value.
 */
val Value.BitValue get() = (this as Value.BitValue).value

/**
 * Casts this [Value] as a [BlobValue] and retrieves its [kotlin.ByteArray] value.
 */
val Value.BlobValue get() = (this as Value.BlobValue).value

/**
 * Casts this [Value] as a [DoubleValue] and retrieves its [kotlin.Double] value.
 */
val Value.DoubleValue get() = (this as Value.DoubleValue).value

/**
 * Casts this [Value] as a [IntValue] and retrieves its [kotlin.Int] value.
 */
val Value.IntValue get() = (this as Value.IntValue).value

/**
 * Casts this [Value] as a [IsNull] and retrieves its [kotlin.Boolean] value.
 */
val Value.IsNull get() = (this as Value.IsNull).value

/**
 * Casts this [Value] as a [RealValue] and retrieves its [kotlin.Float] value.
 */
val Value.RealValue get() = (this as Value.RealValue).value

/**
 * Casts this [Value] as a [StringValue] and retrieves its [kotlin.String] value.
 */
val Value.StringValue get() = (this as Value.StringValue).value

/**
 * Casts this [Value] as a [StructValue] and retrieves its [aws.sdk.kotlin.services.rdsdata.model.StructValue] value.
 */
val Value.StructValue get() = (this as Value.StructValue).value
