// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.model



/**
 * Contains the value of a column.
 *
 * This data structure is only used with the deprecated `ExecuteSql` operation. Use the `BatchExecuteStatement` or `ExecuteStatement` operation instead.
 */
public sealed class Value {
    /**
     * An array of column values.
     */
    public data class ArrayValues(val value: List<Value>) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of big integer data type.
     */
    public data class BigIntValue(val value: kotlin.Long) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of BIT data type.
     */
    public data class BitValue(val value: kotlin.Boolean) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of BLOB data type.
     */
    public data class BlobValue(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.rdsdata.model.Value() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as BlobValue

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }
    /**
     * A value for a column of double data type.
     */
    public data class DoubleValue(val value: kotlin.Double) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of integer data type.
     */
    public data class IntValue(val value: kotlin.Int) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A NULL value.
     */
    public data class IsNull(val value: kotlin.Boolean) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of real data type.
     */
    public data class RealValue(val value: kotlin.Float) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of string data type.
     */
    public data class StringValue(val value: kotlin.String) : aws.sdk.kotlin.services.rdsdata.model.Value()
    /**
     * A value for a column of STRUCT data type.
     */
    public data class StructValue(val value: aws.sdk.kotlin.services.rdsdata.model.StructValue) : aws.sdk.kotlin.services.rdsdata.model.Value()
    public object SdkUnknown : aws.sdk.kotlin.services.rdsdata.model.Value()

    /**
     * Casts this [Value] as a [ArrayValues] and retrieves its [List<Value>] value. Throws an exception if the [Value] is not a
     * [ArrayValues].
     */
    public fun asArrayValues(): List<Value> = (this as Value.ArrayValues).value

    /**
     * Casts this [Value] as a [ArrayValues] and retrieves its [List<Value>] value. Returns null if the [Value] is not a [ArrayValues].
     */
    public fun asArrayValuesOrNull(): List<Value>? = (this as? Value.ArrayValues)?.value

    /**
     * Casts this [Value] as a [BigIntValue] and retrieves its [kotlin.Long] value. Throws an exception if the [Value] is not a
     * [BigIntValue].
     */
    public fun asBigIntValue(): kotlin.Long = (this as Value.BigIntValue).value

    /**
     * Casts this [Value] as a [BigIntValue] and retrieves its [kotlin.Long] value. Returns null if the [Value] is not a [BigIntValue].
     */
    public fun asBigIntValueOrNull(): kotlin.Long? = (this as? Value.BigIntValue)?.value

    /**
     * Casts this [Value] as a [BitValue] and retrieves its [kotlin.Boolean] value. Throws an exception if the [Value] is not a
     * [BitValue].
     */
    public fun asBitValue(): kotlin.Boolean = (this as Value.BitValue).value

    /**
     * Casts this [Value] as a [BitValue] and retrieves its [kotlin.Boolean] value. Returns null if the [Value] is not a [BitValue].
     */
    public fun asBitValueOrNull(): kotlin.Boolean? = (this as? Value.BitValue)?.value

    /**
     * Casts this [Value] as a [BlobValue] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [Value] is not a
     * [BlobValue].
     */
    public fun asBlobValue(): kotlin.ByteArray = (this as Value.BlobValue).value

    /**
     * Casts this [Value] as a [BlobValue] and retrieves its [kotlin.ByteArray] value. Returns null if the [Value] is not a [BlobValue].
     */
    public fun asBlobValueOrNull(): kotlin.ByteArray? = (this as? Value.BlobValue)?.value

    /**
     * Casts this [Value] as a [DoubleValue] and retrieves its [kotlin.Double] value. Throws an exception if the [Value] is not a
     * [DoubleValue].
     */
    public fun asDoubleValue(): kotlin.Double = (this as Value.DoubleValue).value

    /**
     * Casts this [Value] as a [DoubleValue] and retrieves its [kotlin.Double] value. Returns null if the [Value] is not a [DoubleValue].
     */
    public fun asDoubleValueOrNull(): kotlin.Double? = (this as? Value.DoubleValue)?.value

    /**
     * Casts this [Value] as a [IntValue] and retrieves its [kotlin.Int] value. Throws an exception if the [Value] is not a
     * [IntValue].
     */
    public fun asIntValue(): kotlin.Int = (this as Value.IntValue).value

    /**
     * Casts this [Value] as a [IntValue] and retrieves its [kotlin.Int] value. Returns null if the [Value] is not a [IntValue].
     */
    public fun asIntValueOrNull(): kotlin.Int? = (this as? Value.IntValue)?.value

    /**
     * Casts this [Value] as a [IsNull] and retrieves its [kotlin.Boolean] value. Throws an exception if the [Value] is not a
     * [IsNull].
     */
    public fun asIsNull(): kotlin.Boolean = (this as Value.IsNull).value

    /**
     * Casts this [Value] as a [IsNull] and retrieves its [kotlin.Boolean] value. Returns null if the [Value] is not a [IsNull].
     */
    public fun asIsNullOrNull(): kotlin.Boolean? = (this as? Value.IsNull)?.value

    /**
     * Casts this [Value] as a [RealValue] and retrieves its [kotlin.Float] value. Throws an exception if the [Value] is not a
     * [RealValue].
     */
    public fun asRealValue(): kotlin.Float = (this as Value.RealValue).value

    /**
     * Casts this [Value] as a [RealValue] and retrieves its [kotlin.Float] value. Returns null if the [Value] is not a [RealValue].
     */
    public fun asRealValueOrNull(): kotlin.Float? = (this as? Value.RealValue)?.value

    /**
     * Casts this [Value] as a [StringValue] and retrieves its [kotlin.String] value. Throws an exception if the [Value] is not a
     * [StringValue].
     */
    public fun asStringValue(): kotlin.String = (this as Value.StringValue).value

    /**
     * Casts this [Value] as a [StringValue] and retrieves its [kotlin.String] value. Returns null if the [Value] is not a [StringValue].
     */
    public fun asStringValueOrNull(): kotlin.String? = (this as? Value.StringValue)?.value

    /**
     * Casts this [Value] as a [StructValue] and retrieves its [aws.sdk.kotlin.services.rdsdata.model.StructValue] value. Throws an exception if the [Value] is not a
     * [StructValue].
     */
    public fun asStructValue(): aws.sdk.kotlin.services.rdsdata.model.StructValue = (this as Value.StructValue).value

    /**
     * Casts this [Value] as a [StructValue] and retrieves its [aws.sdk.kotlin.services.rdsdata.model.StructValue] value. Returns null if the [Value] is not a [StructValue].
     */
    public fun asStructValueOrNull(): aws.sdk.kotlin.services.rdsdata.model.StructValue? = (this as? Value.StructValue)?.value
}
