// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.rdsdata.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.rdsdata.model.*
import aws.sdk.kotlin.services.rdsdata.model.BatchExecuteStatementRequest
import aws.sdk.kotlin.services.rdsdata.model.BatchExecuteStatementResponse
import aws.sdk.kotlin.services.rdsdata.model.BeginTransactionRequest
import aws.sdk.kotlin.services.rdsdata.model.BeginTransactionResponse
import aws.sdk.kotlin.services.rdsdata.model.CommitTransactionRequest
import aws.sdk.kotlin.services.rdsdata.model.CommitTransactionResponse
import aws.sdk.kotlin.services.rdsdata.model.ExecuteSqlRequest
import aws.sdk.kotlin.services.rdsdata.model.ExecuteSqlResponse
import aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementRequest
import aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementResponse
import aws.sdk.kotlin.services.rdsdata.model.RollbackTransactionRequest
import aws.sdk.kotlin.services.rdsdata.model.RollbackTransactionResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon RDS Data Service
 * Amazon RDS provides an HTTP endpoint to run SQL statements on an Amazon Aurora Serverless v1 DB cluster. To run these statements, you work with the Data Service API.
 *
 * The Data Service API isn't supported on Amazon Aurora Serverless v2 DB clusters.
 *
 * For more information about the Data Service API, see [Using the Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
 */
public interface RdsDataClient : SdkClient {

    override val serviceName: String
        get() = "RDS Data"
    /**
     * RdsDataClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): RdsDataClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRdsDataClient(config)
        }

        public operator fun invoke(config: Config): RdsDataClient = DefaultRdsDataClient(config)

        /**
         * Construct a [RdsDataClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RdsDataClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRdsDataClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Runs a batch SQL statement over an array of data.
     *
     * You can run bulk update and insert operations for multiple records using a DML statement with different parameter sets. Bulk operations can provide a significant performance improvement over individual insert and update operations.
     *
     * If a call isn't part of a transaction because it doesn't include the `transactionID` parameter, changes that result from the call are committed automatically.
     *
     * There isn't a fixed upper limit on the number of parameter sets. However, the maximum size of the HTTP request submitted through the Data API is 4 MiB. If the request exceeds this limit, the Data API returns an error and doesn't process the request. This 4-MiB limit includes the size of the HTTP headers and the JSON notation in the request. Thus, the number of parameter sets that you can include depends on a combination of factors, such as the size of the SQL statement and the size of each parameter set.
     *
     * The response size limit is 1 MiB. If the call returns more than 1 MiB of response data, the call is terminated.
     */
    public suspend fun batchExecuteStatement(input: BatchExecuteStatementRequest): BatchExecuteStatementResponse

    /**
     * Starts a SQL transaction.
     *
     * A transaction can run for a maximum of 24 hours. A transaction is terminated and rolled back automatically after 24 hours.
     *
     * A transaction times out if no calls use its transaction ID in three minutes. If a transaction times out before it's committed, it's rolled back automatically.
     *
     * DDL statements inside a transaction cause an implicit commit. We recommend that you run each DDL statement in a separate `ExecuteStatement` call with `continueAfterTimeout` enabled.
     */
    public suspend fun beginTransaction(input: BeginTransactionRequest): BeginTransactionResponse

    /**
     * Ends a SQL transaction started with the `BeginTransaction` operation and commits the changes.
     */
    public suspend fun commitTransaction(input: CommitTransactionRequest): CommitTransactionResponse

    /**
     * Runs one or more SQL statements.
     *
     * This operation is deprecated. Use the `BatchExecuteStatement` or `ExecuteStatement` operation.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun executeSql(input: ExecuteSqlRequest): ExecuteSqlResponse

    /**
     * Runs a SQL statement against a database.
     *
     * If a call isn't part of a transaction because it doesn't include the `transactionID` parameter, changes that result from the call are committed automatically.
     *
     * If the binary response data from the database is more than 1 MB, the call is terminated.
     */
    public suspend fun executeStatement(input: ExecuteStatementRequest): ExecuteStatementResponse

    /**
     * Performs a rollback of a transaction. Rolling back a transaction cancels its changes.
     */
    public suspend fun rollbackTransaction(input: RollbackTransactionRequest): RollbackTransactionResponse
}

/**
 * Runs a batch SQL statement over an array of data.
 *
 * You can run bulk update and insert operations for multiple records using a DML statement with different parameter sets. Bulk operations can provide a significant performance improvement over individual insert and update operations.
 *
 * If a call isn't part of a transaction because it doesn't include the `transactionID` parameter, changes that result from the call are committed automatically.
 *
 * There isn't a fixed upper limit on the number of parameter sets. However, the maximum size of the HTTP request submitted through the Data API is 4 MiB. If the request exceeds this limit, the Data API returns an error and doesn't process the request. This 4-MiB limit includes the size of the HTTP headers and the JSON notation in the request. Thus, the number of parameter sets that you can include depends on a combination of factors, such as the size of the SQL statement and the size of each parameter set.
 *
 * The response size limit is 1 MiB. If the call returns more than 1 MiB of response data, the call is terminated.
 */
public suspend inline fun RdsDataClient.batchExecuteStatement(crossinline block: BatchExecuteStatementRequest.Builder.() -> Unit): BatchExecuteStatementResponse = batchExecuteStatement(BatchExecuteStatementRequest.Builder().apply(block).build())

/**
 * Starts a SQL transaction.
 *
 * A transaction can run for a maximum of 24 hours. A transaction is terminated and rolled back automatically after 24 hours.
 *
 * A transaction times out if no calls use its transaction ID in three minutes. If a transaction times out before it's committed, it's rolled back automatically.
 *
 * DDL statements inside a transaction cause an implicit commit. We recommend that you run each DDL statement in a separate `ExecuteStatement` call with `continueAfterTimeout` enabled.
 */
public suspend inline fun RdsDataClient.beginTransaction(crossinline block: BeginTransactionRequest.Builder.() -> Unit): BeginTransactionResponse = beginTransaction(BeginTransactionRequest.Builder().apply(block).build())

/**
 * Ends a SQL transaction started with the `BeginTransaction` operation and commits the changes.
 */
public suspend inline fun RdsDataClient.commitTransaction(crossinline block: CommitTransactionRequest.Builder.() -> Unit): CommitTransactionResponse = commitTransaction(CommitTransactionRequest.Builder().apply(block).build())

/**
 * Runs one or more SQL statements.
 *
 * This operation is deprecated. Use the `BatchExecuteStatement` or `ExecuteStatement` operation.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RdsDataClient.executeSql(crossinline block: ExecuteSqlRequest.Builder.() -> Unit): ExecuteSqlResponse = executeSql(ExecuteSqlRequest.Builder().apply(block).build())

/**
 * Runs a SQL statement against a database.
 *
 * If a call isn't part of a transaction because it doesn't include the `transactionID` parameter, changes that result from the call are committed automatically.
 *
 * If the binary response data from the database is more than 1 MB, the call is terminated.
 */
public suspend inline fun RdsDataClient.executeStatement(crossinline block: ExecuteStatementRequest.Builder.() -> Unit): ExecuteStatementResponse = executeStatement(ExecuteStatementRequest.Builder().apply(block).build())

/**
 * Performs a rollback of a transaction. Rolling back a transaction cancels its changes.
 */
public suspend inline fun RdsDataClient.rollbackTransaction(crossinline block: RollbackTransactionRequest.Builder.() -> Unit): RollbackTransactionResponse = rollbackTransaction(RollbackTransactionRequest.Builder().apply(block).build())
