// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.rdsdata.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.rdsdata.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.rdsdata.model.*
import aws.sdk.kotlin.services.rdsdata.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "RDS Data"
public const val ServiceApiVersion: String = "2018-08-01"
public const val SdkVersion: String = "0.19.0-beta"

internal class DefaultRdsDataClient(override val config: RdsDataClient.Config) : RdsDataClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Runs a batch SQL statement over an array of data.
     *
     * You can run bulk update and insert operations for multiple records using a DML statement with different parameter sets. Bulk operations can provide a significant performance improvement over individual insert and update operations.
     *
     * If a call isn't part of a transaction because it doesn't include the `transactionID` parameter, changes that result from the call are committed automatically.
     *
     * There isn't a fixed upper limit on the number of parameter sets. However, the maximum size of the HTTP request submitted through the Data API is 4 MiB. If the request exceeds this limit, the Data API returns an error and doesn't process the request. This 4-MiB limit includes the size of the HTTP headers and the JSON notation in the request. Thus, the number of parameter sets that you can include depends on a combination of factors, such as the size of the SQL statement and the size of each parameter set.
     *
     * The response size limit is 1 MiB. If the call returns more than 1 MiB of response data, the call is terminated.
     */
    override suspend fun batchExecuteStatement(input: BatchExecuteStatementRequest): BatchExecuteStatementResponse {
        val op = SdkHttpOperation.build<BatchExecuteStatementRequest, BatchExecuteStatementResponse> {
            serializer = BatchExecuteStatementOperationSerializer()
            deserializer = BatchExecuteStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchExecuteStatement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rds-data"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchExecuteStatement-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts a SQL transaction.
     *
     * A transaction can run for a maximum of 24 hours. A transaction is terminated and rolled back automatically after 24 hours.
     *
     * A transaction times out if no calls use its transaction ID in three minutes. If a transaction times out before it's committed, it's rolled back automatically.
     *
     * DDL statements inside a transaction cause an implicit commit. We recommend that you run each DDL statement in a separate `ExecuteStatement` call with `continueAfterTimeout` enabled.
     */
    override suspend fun beginTransaction(input: BeginTransactionRequest): BeginTransactionResponse {
        val op = SdkHttpOperation.build<BeginTransactionRequest, BeginTransactionResponse> {
            serializer = BeginTransactionOperationSerializer()
            deserializer = BeginTransactionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BeginTransaction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rds-data"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BeginTransaction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Ends a SQL transaction started with the `BeginTransaction` operation and commits the changes.
     */
    override suspend fun commitTransaction(input: CommitTransactionRequest): CommitTransactionResponse {
        val op = SdkHttpOperation.build<CommitTransactionRequest, CommitTransactionResponse> {
            serializer = CommitTransactionOperationSerializer()
            deserializer = CommitTransactionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CommitTransaction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rds-data"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CommitTransaction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Runs one or more SQL statements.
     *
     * This operation is deprecated. Use the `BatchExecuteStatement` or `ExecuteStatement` operation.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun executeSql(input: ExecuteSqlRequest): ExecuteSqlResponse {
        val op = SdkHttpOperation.build<ExecuteSqlRequest, ExecuteSqlResponse> {
            serializer = ExecuteSqlOperationSerializer()
            deserializer = ExecuteSqlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExecuteSql"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rds-data"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ExecuteSql-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Runs a SQL statement against a database.
     *
     * If a call isn't part of a transaction because it doesn't include the `transactionID` parameter, changes that result from the call are committed automatically.
     *
     * If the binary response data from the database is more than 1 MB, the call is terminated.
     */
    override suspend fun executeStatement(input: ExecuteStatementRequest): ExecuteStatementResponse {
        val op = SdkHttpOperation.build<ExecuteStatementRequest, ExecuteStatementResponse> {
            serializer = ExecuteStatementOperationSerializer()
            deserializer = ExecuteStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExecuteStatement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rds-data"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ExecuteStatement-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Performs a rollback of a transaction. Rolling back a transaction cancels its changes.
     */
    override suspend fun rollbackTransaction(input: RollbackTransactionRequest): RollbackTransactionResponse {
        val op = SdkHttpOperation.build<RollbackTransactionRequest, RollbackTransactionResponse> {
            serializer = RollbackTransactionOperationSerializer()
            deserializer = RollbackTransactionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RollbackTransaction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rds-data"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RollbackTransaction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "rds-data")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
