// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.redshift.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.redshift.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon Redshift
 * **Overview**
 *
 * This is an interface reference for Amazon Redshift. It contains documentation for one of the programming or command line interfaces you can use to manage Amazon Redshift clusters. Note that Amazon Redshift is asynchronous, which means that some interfaces may require techniques, such as polling or asynchronous callback handlers, to determine when a command has been applied. In this reference, the parameter descriptions indicate whether a change is applied immediately, on the next instance reboot, or during the next maintenance window. For a summary of the Amazon Redshift cluster management interfaces, go to [Using the Amazon Redshift Management Interfaces](https://docs.aws.amazon.com/redshift/latest/mgmt/using-aws-sdk.html).
 *
 * Amazon Redshift manages all the work of setting up, operating, and scaling a data warehouse: provisioning capacity, monitoring and backing up the cluster, and applying patches and upgrades to the Amazon Redshift engine. You can focus on using your data to acquire new insights for your business and customers.
 *
 * If you are a first-time user of Amazon Redshift, we recommend that you begin by reading the [Amazon Redshift Getting Started Guide](https://docs.aws.amazon.com/redshift/latest/gsg/getting-started.html).
 *
 * If you are a database developer, the [Amazon Redshift Database Developer Guide](https://docs.aws.amazon.com/redshift/latest/dg/welcome.html) explains how to design, build, query, and maintain the databases that make up your data warehouse.
 */
interface RedshiftClient : SdkClient {

    override val serviceName: String
        get() = "Redshift"
    /**
     * RedshiftClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): RedshiftClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRedshiftClient(config)
        }

        operator fun invoke(config: Config): RedshiftClient = DefaultRedshiftClient(config)

        /**
         * Construct a [RedshiftClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RedshiftClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRedshiftClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type, or number of nodes) and no additional costs.
     */
    suspend fun acceptReservedNodeExchange(input: AcceptReservedNodeExchangeRequest): AcceptReservedNodeExchangeResponse

    /**
     * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type, or number of nodes) and no additional costs.
     */
    suspend fun acceptReservedNodeExchange(block: AcceptReservedNodeExchangeRequest.Builder.() -> Unit) = acceptReservedNodeExchange(AcceptReservedNodeExchangeRequest.Builder().apply(block).build())

    /**
     * Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the specified database. To complete the integration, you also set up the integration on the partner website.
     */
    suspend fun addPartner(input: AddPartnerRequest): AddPartnerResponse

    /**
     * Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the specified database. To complete the integration, you also set up the integration on the partner website.
     */
    suspend fun addPartner(block: AddPartnerRequest.Builder.() -> Unit) = addPartner(AddPartnerRequest.Builder().apply(block).build())

    /**
     * From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.
     */
    suspend fun associateDataShareConsumer(input: AssociateDataShareConsumerRequest): AssociateDataShareConsumerResponse

    /**
     * From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.
     */
    suspend fun associateDataShareConsumer(block: AssociateDataShareConsumerRequest.Builder.() -> Unit) = associateDataShareConsumer(AssociateDataShareConsumerRequest.Builder().apply(block).build())

    /**
     * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group.
     *
     * If you authorize access to an Amazon EC2 security group, specify *EC2SecurityGroupName* and *EC2SecurityGroupOwnerId*. The Amazon EC2 security group and Amazon Redshift cluster must be in the same Amazon Web Services Region.
     *
     * If you authorize access to a CIDR/IP address range, specify *CIDRIP*. For an overview of CIDR blocks, see the Wikipedia article on [Classless Inter-Domain Routing](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     *
     * You must also associate the security group with a cluster so that clients running on these IP addresses or the EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to [Working with Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun authorizeClusterSecurityGroupIngress(input: AuthorizeClusterSecurityGroupIngressRequest): AuthorizeClusterSecurityGroupIngressResponse

    /**
     * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group.
     *
     * If you authorize access to an Amazon EC2 security group, specify *EC2SecurityGroupName* and *EC2SecurityGroupOwnerId*. The Amazon EC2 security group and Amazon Redshift cluster must be in the same Amazon Web Services Region.
     *
     * If you authorize access to a CIDR/IP address range, specify *CIDRIP*. For an overview of CIDR blocks, see the Wikipedia article on [Classless Inter-Domain Routing](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     *
     * You must also associate the security group with a cluster so that clients running on these IP addresses or the EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to [Working with Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun authorizeClusterSecurityGroupIngress(block: AuthorizeClusterSecurityGroupIngressRequest.Builder.() -> Unit) = authorizeClusterSecurityGroupIngress(AuthorizeClusterSecurityGroupIngressRequest.Builder().apply(block).build())

    /**
     * From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or managing entities. To authorize a datashare for a data consumer, the producer account must have the correct access permissions.
     */
    suspend fun authorizeDataShare(input: AuthorizeDataShareRequest): AuthorizeDataShareResponse

    /**
     * From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or managing entities. To authorize a datashare for a data consumer, the producer account must have the correct access permissions.
     */
    suspend fun authorizeDataShare(block: AuthorizeDataShareRequest.Builder.() -> Unit) = authorizeDataShare(AuthorizeDataShareRequest.Builder().apply(block).build())

    /**
     * Grants access to a cluster.
     */
    suspend fun authorizeEndpointAccess(input: AuthorizeEndpointAccessRequest): AuthorizeEndpointAccessResponse

    /**
     * Grants access to a cluster.
     */
    suspend fun authorizeEndpointAccess(block: AuthorizeEndpointAccessRequest.Builder.() -> Unit) = authorizeEndpointAccess(AuthorizeEndpointAccessRequest.Builder().apply(block).build())

    /**
     * Authorizes the specified Amazon Web Services account to restore the specified snapshot.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun authorizeSnapshotAccess(input: AuthorizeSnapshotAccessRequest): AuthorizeSnapshotAccessResponse

    /**
     * Authorizes the specified Amazon Web Services account to restore the specified snapshot.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun authorizeSnapshotAccess(block: AuthorizeSnapshotAccessRequest.Builder.() -> Unit) = authorizeSnapshotAccess(AuthorizeSnapshotAccessRequest.Builder().apply(block).build())

    /**
     * Deletes a set of cluster snapshots.
     */
    suspend fun batchDeleteClusterSnapshots(input: BatchDeleteClusterSnapshotsRequest): BatchDeleteClusterSnapshotsResponse

    /**
     * Deletes a set of cluster snapshots.
     */
    suspend fun batchDeleteClusterSnapshots(block: BatchDeleteClusterSnapshotsRequest.Builder.() -> Unit) = batchDeleteClusterSnapshots(BatchDeleteClusterSnapshotsRequest.Builder().apply(block).build())

    /**
     * Modifies the settings for a set of cluster snapshots.
     */
    suspend fun batchModifyClusterSnapshots(input: BatchModifyClusterSnapshotsRequest): BatchModifyClusterSnapshotsResponse

    /**
     * Modifies the settings for a set of cluster snapshots.
     */
    suspend fun batchModifyClusterSnapshots(block: BatchModifyClusterSnapshotsRequest.Builder.() -> Unit) = batchModifyClusterSnapshots(BatchModifyClusterSnapshotsRequest.Builder().apply(block).build())

    /**
     * Cancels a resize operation for a cluster.
     */
    suspend fun cancelResize(input: CancelResizeRequest): CancelResizeResponse

    /**
     * Cancels a resize operation for a cluster.
     */
    suspend fun cancelResize(block: CancelResizeRequest.Builder.() -> Unit) = cancelResize(CancelResizeRequest.Builder().apply(block).build())

    /**
     * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state.
     *
     * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained until you delete them.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun copyClusterSnapshot(input: CopyClusterSnapshotRequest): CopyClusterSnapshotResponse

    /**
     * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state.
     *
     * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained until you delete them.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun copyClusterSnapshot(block: CopyClusterSnapshotRequest.Builder.() -> Unit) = copyClusterSnapshot(CopyClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Creates an authentication profile with the specified parameters.
     */
    suspend fun createAuthenticationProfile(input: CreateAuthenticationProfileRequest): CreateAuthenticationProfileResponse

    /**
     * Creates an authentication profile with the specified parameters.
     */
    suspend fun createAuthenticationProfile(block: CreateAuthenticationProfileRequest.Builder.() -> Unit) = createAuthenticationProfile(CreateAuthenticationProfileRequest.Builder().apply(block).build())

    /**
     * Creates a new cluster with the specified parameters.
     *
     * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new cluster with the specified parameters.
     *
     * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createCluster(block: CreateClusterRequest.Builder.() -> Unit) = createCluster(CreateClusterRequest.Builder().apply(block).build())

    /**
     * Creates an Amazon Redshift parameter group.
     *
     * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster is created by using ModifyCluster.
     *
     * Parameters in the parameter group define specific behavior that applies to the databases you create on the cluster. For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createClusterParameterGroup(input: CreateClusterParameterGroupRequest): CreateClusterParameterGroupResponse

    /**
     * Creates an Amazon Redshift parameter group.
     *
     * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster is created by using ModifyCluster.
     *
     * Parameters in the parameter group define specific behavior that applies to the databases you create on the cluster. For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createClusterParameterGroup(block: CreateClusterParameterGroupRequest.Builder.() -> Unit) = createClusterParameterGroup(CreateClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createClusterSecurityGroup(input: CreateClusterSecurityGroupRequest): CreateClusterSecurityGroupResponse

    /**
     * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createClusterSecurityGroup(block: CreateClusterSecurityGroupRequest.Builder.() -> Unit) = createClusterSecurityGroup(CreateClusterSecurityGroupRequest.Builder().apply(block).build())

    /**
     * Creates a manual snapshot of the specified cluster. The cluster must be in the `available` state.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createClusterSnapshot(input: CreateClusterSnapshotRequest): CreateClusterSnapshotResponse

    /**
     * Creates a manual snapshot of the specified cluster. The cluster must be in the `available` state.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createClusterSnapshot(block: CreateClusterSnapshotRequest.Builder.() -> Unit) = createClusterSnapshot(CreateClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
     *
     *  For information about subnet groups, go to [Amazon Redshift Cluster Subnet Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createClusterSubnetGroup(input: CreateClusterSubnetGroupRequest): CreateClusterSubnetGroupResponse

    /**
     * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
     *
     *  For information about subnet groups, go to [Amazon Redshift Cluster Subnet Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createClusterSubnetGroup(block: CreateClusterSubnetGroupRequest.Builder.() -> Unit) = createClusterSubnetGroup(CreateClusterSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Creates a Redshift-managed VPC endpoint.
     */
    suspend fun createEndpointAccess(input: CreateEndpointAccessRequest): CreateEndpointAccessResponse

    /**
     * Creates a Redshift-managed VPC endpoint.
     */
    suspend fun createEndpointAccess(block: CreateEndpointAccessRequest.Builder.() -> Unit) = createEndpointAccess(CreateEndpointAccessRequest.Builder().apply(block).build())

    /**
     * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     *
     * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities. Notifications will be sent for all events you want that match those criteria. For example, you can specify source type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup categories for the specified clusters.
     *
     * If you specify both the source type and source IDs, such as source type = cluster and source identifier = my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source type but do not specify a source identifier, you will receive notice of the events for the objects of that type in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services account. You must specify a source type if you specify a source ID.
     */
    suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse

    /**
     * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     *
     * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities. Notifications will be sent for all events you want that match those criteria. For example, you can specify source type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup categories for the specified clusters.
     *
     * If you specify both the source type and source IDs, such as source type = cluster and source identifier = my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source type but do not specify a source identifier, you will receive notice of the events for the objects of that type in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services account. You must specify a source type if you specify a source ID.
     */
    suspend fun createEventSubscription(block: CreateEventSubscriptionRequest.Builder.() -> Unit) = createEventSubscription(CreateEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in order to store and retrieve the keys used to encrypt the cluster databases.
     *
     * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate, you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and use encryption keys in the HSM. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createHsmClientCertificate(input: CreateHsmClientCertificateRequest): CreateHsmClientCertificateResponse

    /**
     * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in order to store and retrieve the keys used to encrypt the cluster databases.
     *
     * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate, you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and use encryption keys in the HSM. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createHsmClientCertificate(block: CreateHsmClientCertificateRequest.Builder.() -> Unit) = createHsmClientCertificate(CreateHsmClientCertificateRequest.Builder().apply(block).build())

    /**
     * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
     *
     * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html) in the Amazon Redshift Cluster Management Guide.
     */
    suspend fun createHsmConfiguration(input: CreateHsmConfigurationRequest): CreateHsmConfigurationResponse

    /**
     * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
     *
     * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html) in the Amazon Redshift Cluster Management Guide.
     */
    suspend fun createHsmConfiguration(block: CreateHsmConfigurationRequest.Builder.() -> Unit) = createHsmConfiguration(CreateHsmConfigurationRequest.Builder().apply(block).build())

    /**
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the `ResizeCluster` API operation.
     */
    suspend fun createScheduledAction(input: CreateScheduledActionRequest): CreateScheduledActionResponse

    /**
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the `ResizeCluster` API operation.
     */
    suspend fun createScheduledAction(block: CreateScheduledActionRequest.Builder.() -> Unit) = createScheduledAction(CreateScheduledActionRequest.Builder().apply(block).build())

    /**
     * Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management Service (KMS) to encrypt copied snapshots in a destination region.
     *
     *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createSnapshotCopyGrant(input: CreateSnapshotCopyGrantRequest): CreateSnapshotCopyGrantResponse

    /**
     * Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management Service (KMS) to encrypt copied snapshots in a destination region.
     *
     *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun createSnapshotCopyGrant(block: CreateSnapshotCopyGrantRequest.Builder.() -> Unit) = createSnapshotCopyGrant(CreateSnapshotCopyGrantRequest.Builder().apply(block).build())

    /**
     * Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule.
     */
    suspend fun createSnapshotSchedule(input: CreateSnapshotScheduleRequest = CreateSnapshotScheduleRequest {}): CreateSnapshotScheduleResponse

    /**
     * Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule.
     */
    suspend fun createSnapshotSchedule(block: CreateSnapshotScheduleRequest.Builder.() -> Unit) = createSnapshotSchedule(CreateSnapshotScheduleRequest.Builder().apply(block).build())

    /**
     * Adds tags to a cluster.
     *
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an error and the attempt will fail.
     *
     * If you specify a key that already exists for the resource, the value for that key will be updated with the new value.
     */
    suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Adds tags to a cluster.
     *
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an error and the attempt will fail.
     *
     * If you specify a key that already exists for the resource, the value for that key will be updated with the new value.
     */
    suspend fun createTags(block: CreateTagsRequest.Builder.() -> Unit) = createTags(CreateTagsRequest.Builder().apply(block).build())

    /**
     * Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.
     */
    suspend fun createUsageLimit(input: CreateUsageLimitRequest): CreateUsageLimitResponse

    /**
     * Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.
     */
    suspend fun createUsageLimit(block: CreateUsageLimitRequest.Builder.() -> Unit) = createUsageLimit(CreateUsageLimitRequest.Builder().apply(block).build())

    /**
     * From a datashare producer account, removes authorization from the specified datashare.
     */
    suspend fun deauthorizeDataShare(input: DeauthorizeDataShareRequest): DeauthorizeDataShareResponse

    /**
     * From a datashare producer account, removes authorization from the specified datashare.
     */
    suspend fun deauthorizeDataShare(block: DeauthorizeDataShareRequest.Builder.() -> Unit) = deauthorizeDataShare(DeauthorizeDataShareRequest.Builder().apply(block).build())

    /**
     * Deletes an authentication profile.
     */
    suspend fun deleteAuthenticationProfile(input: DeleteAuthenticationProfileRequest): DeleteAuthenticationProfileResponse

    /**
     * Deletes an authentication profile.
     */
    suspend fun deleteAuthenticationProfile(block: DeleteAuthenticationProfileRequest.Builder.() -> Unit) = deleteAuthenticationProfile(DeleteAuthenticationProfileRequest.Builder().apply(block).build())

    /**
     * Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the web service indicates that the request was received correctly. Use DescribeClusters to monitor the status of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you want to shut down the cluster and retain it for future use, set *SkipFinalClusterSnapshot* to `false` and specify a name for *FinalClusterSnapshotIdentifier*. You can later restore this snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the cluster.
     *
     *  For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the web service indicates that the request was received correctly. Use DescribeClusters to monitor the status of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you want to shut down the cluster and retain it for future use, set *SkipFinalClusterSnapshot* to `false` and specify a name for *FinalClusterSnapshotIdentifier*. You can later restore this snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the cluster.
     *
     *  For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun deleteCluster(block: DeleteClusterRequest.Builder.() -> Unit) = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

    /**
     * Deletes a specified Amazon Redshift parameter group.
     *
     * You cannot delete a parameter group if it is associated with a cluster.
     */
    suspend fun deleteClusterParameterGroup(input: DeleteClusterParameterGroupRequest): DeleteClusterParameterGroupResponse

    /**
     * Deletes a specified Amazon Redshift parameter group.
     *
     * You cannot delete a parameter group if it is associated with a cluster.
     */
    suspend fun deleteClusterParameterGroup(block: DeleteClusterParameterGroupRequest.Builder.() -> Unit) = deleteClusterParameterGroup(DeleteClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Deletes an Amazon Redshift security group.
     *
     * You cannot delete a security group that is associated with any clusters. You cannot delete the default security group.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun deleteClusterSecurityGroup(input: DeleteClusterSecurityGroupRequest): DeleteClusterSecurityGroupResponse

    /**
     * Deletes an Amazon Redshift security group.
     *
     * You cannot delete a security group that is associated with any clusters. You cannot delete the default security group.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun deleteClusterSecurityGroup(block: DeleteClusterSecurityGroupRequest.Builder.() -> Unit) = deleteClusterSecurityGroup(DeleteClusterSecurityGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the specified manual snapshot. The snapshot must be in the `available` state, with no other users authorized to access the snapshot.
     *
     * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can delete the snapshot.
     */
    suspend fun deleteClusterSnapshot(input: DeleteClusterSnapshotRequest): DeleteClusterSnapshotResponse

    /**
     * Deletes the specified manual snapshot. The snapshot must be in the `available` state, with no other users authorized to access the snapshot.
     *
     * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can delete the snapshot.
     */
    suspend fun deleteClusterSnapshot(block: DeleteClusterSnapshotRequest.Builder.() -> Unit) = deleteClusterSnapshot(DeleteClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Deletes the specified cluster subnet group.
     */
    suspend fun deleteClusterSubnetGroup(input: DeleteClusterSubnetGroupRequest): DeleteClusterSubnetGroupResponse

    /**
     * Deletes the specified cluster subnet group.
     */
    suspend fun deleteClusterSubnetGroup(block: DeleteClusterSubnetGroupRequest.Builder.() -> Unit) = deleteClusterSubnetGroup(DeleteClusterSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a Redshift-managed VPC endpoint.
     */
    suspend fun deleteEndpointAccess(input: DeleteEndpointAccessRequest): DeleteEndpointAccessResponse

    /**
     * Deletes a Redshift-managed VPC endpoint.
     */
    suspend fun deleteEndpointAccess(block: DeleteEndpointAccessRequest.Builder.() -> Unit) = deleteEndpointAccess(DeleteEndpointAccessRequest.Builder().apply(block).build())

    /**
     * Deletes an Amazon Redshift event notification subscription.
     */
    suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse

    /**
     * Deletes an Amazon Redshift event notification subscription.
     */
    suspend fun deleteEventSubscription(block: DeleteEventSubscriptionRequest.Builder.() -> Unit) = deleteEventSubscription(DeleteEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified HSM client certificate.
     */
    suspend fun deleteHsmClientCertificate(input: DeleteHsmClientCertificateRequest): DeleteHsmClientCertificateResponse

    /**
     * Deletes the specified HSM client certificate.
     */
    suspend fun deleteHsmClientCertificate(block: DeleteHsmClientCertificateRequest.Builder.() -> Unit) = deleteHsmClientCertificate(DeleteHsmClientCertificateRequest.Builder().apply(block).build())

    /**
     * Deletes the specified Amazon Redshift HSM configuration.
     */
    suspend fun deleteHsmConfiguration(input: DeleteHsmConfigurationRequest): DeleteHsmConfigurationResponse

    /**
     * Deletes the specified Amazon Redshift HSM configuration.
     */
    suspend fun deleteHsmConfiguration(block: DeleteHsmConfigurationRequest.Builder.() -> Unit) = deleteHsmConfiguration(DeleteHsmConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner's website.
     */
    suspend fun deletePartner(input: DeletePartnerRequest): DeletePartnerResponse

    /**
     * Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner's website.
     */
    suspend fun deletePartner(block: DeletePartnerRequest.Builder.() -> Unit) = deletePartner(DeletePartnerRequest.Builder().apply(block).build())

    /**
     * Deletes a scheduled action.
     */
    suspend fun deleteScheduledAction(input: DeleteScheduledActionRequest): DeleteScheduledActionResponse

    /**
     * Deletes a scheduled action.
     */
    suspend fun deleteScheduledAction(block: DeleteScheduledActionRequest.Builder.() -> Unit) = deleteScheduledAction(DeleteScheduledActionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified snapshot copy grant.
     */
    suspend fun deleteSnapshotCopyGrant(input: DeleteSnapshotCopyGrantRequest): DeleteSnapshotCopyGrantResponse

    /**
     * Deletes the specified snapshot copy grant.
     */
    suspend fun deleteSnapshotCopyGrant(block: DeleteSnapshotCopyGrantRequest.Builder.() -> Unit) = deleteSnapshotCopyGrant(DeleteSnapshotCopyGrantRequest.Builder().apply(block).build())

    /**
     * Deletes a snapshot schedule.
     */
    suspend fun deleteSnapshotSchedule(input: DeleteSnapshotScheduleRequest): DeleteSnapshotScheduleResponse

    /**
     * Deletes a snapshot schedule.
     */
    suspend fun deleteSnapshotSchedule(block: DeleteSnapshotScheduleRequest.Builder.() -> Unit) = deleteSnapshotSchedule(DeleteSnapshotScheduleRequest.Builder().apply(block).build())

    /**
     * Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or tags.
     */
    suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or tags.
     */
    suspend fun deleteTags(block: DeleteTagsRequest.Builder.() -> Unit) = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

    /**
     * Deletes a usage limit from a cluster.
     */
    suspend fun deleteUsageLimit(input: DeleteUsageLimitRequest): DeleteUsageLimitResponse

    /**
     * Deletes a usage limit from a cluster.
     */
    suspend fun deleteUsageLimit(block: DeleteUsageLimitRequest.Builder.() -> Unit) = deleteUsageLimit(DeleteUsageLimitRequest.Builder().apply(block).build())

    /**
     * Returns a list of attributes attached to an account
     */
    suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest = DescribeAccountAttributesRequest {}): DescribeAccountAttributesResponse

    /**
     * Returns a list of attributes attached to an account
     */
    suspend fun describeAccountAttributes(block: DescribeAccountAttributesRequest.Builder.() -> Unit) = describeAccountAttributes(DescribeAccountAttributesRequest.Builder().apply(block).build())

    /**
     * Describes an authentication profile.
     */
    suspend fun describeAuthenticationProfiles(input: DescribeAuthenticationProfilesRequest = DescribeAuthenticationProfilesRequest {}): DescribeAuthenticationProfilesResponse

    /**
     * Describes an authentication profile.
     */
    suspend fun describeAuthenticationProfiles(block: DescribeAuthenticationProfilesRequest.Builder.() -> Unit) = describeAuthenticationProfiles(DescribeAuthenticationProfilesRequest.Builder().apply(block).build())

    /**
     * Returns an array of `ClusterDbRevision` objects.
     */
    suspend fun describeClusterDbRevisions(input: DescribeClusterDbRevisionsRequest = DescribeClusterDbRevisionsRequest {}): DescribeClusterDbRevisionsResponse

    /**
     * Returns an array of `ClusterDbRevision` objects.
     */
    suspend fun describeClusterDbRevisions(block: DescribeClusterDbRevisionsRequest.Builder.() -> Unit) = describeClusterDbRevisions(DescribeClusterDbRevisionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default parameter group. For each parameter group, the response includes the parameter group name, description, and parameter group family name. You can optionally specify a name to retrieve the description of a specific parameter group.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all parameter groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusterParameterGroups(input: DescribeClusterParameterGroupsRequest = DescribeClusterParameterGroupsRequest {}): DescribeClusterParameterGroupsResponse

    /**
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default parameter group. For each parameter group, the response includes the parameter group name, description, and parameter group family name. You can optionally specify a name to retrieve the description of a specific parameter group.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all parameter groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusterParameterGroups(block: DescribeClusterParameterGroupsRequest.Builder.() -> Unit) = describeClusterParameterGroups(DescribeClusterParameterGroupsRequest.Builder().apply(block).build())

    /**
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each parameter the response includes information such as parameter name, description, data type, value, whether the parameter value is modifiable, and so on.
     *
     * You can specify *source* filter to retrieve parameters of only specific type. For example, to retrieve parameters that were modified by a user action such as from ModifyClusterParameterGroup, you can specify *source* equal to *user*.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeClusterParameters(input: DescribeClusterParametersRequest): DescribeClusterParametersResponse

    /**
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each parameter the response includes information such as parameter name, description, data type, value, whether the parameter value is modifiable, and so on.
     *
     * You can specify *source* filter to retrieve parameters of only specific type. For example, to retrieve parameters that were modified by a user action such as from ModifyClusterParameterGroup, you can specify *source* equal to *user*.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeClusterParameters(block: DescribeClusterParametersRequest.Builder.() -> Unit) = describeClusterParameters(DescribeClusterParametersRequest.Builder().apply(block).build())

    /**
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the response will contain only information about only that security group.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all security groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusterSecurityGroups(input: DescribeClusterSecurityGroupsRequest = DescribeClusterSecurityGroupsRequest {}): DescribeClusterSecurityGroupsResponse

    /**
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the response will contain only information about only that security group.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all security groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusterSecurityGroups(block: DescribeClusterSecurityGroupsRequest.Builder.() -> Unit) = describeClusterSecurityGroups(DescribeClusterSecurityGroupsRequest.Builder().apply(block).build())

    /**
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all snapshots that have any combination of those values are returned. Only snapshots that you own are returned in the response; shared snapshots are not returned with the tag key and tag value request parameters.
     *
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusterSnapshots(input: DescribeClusterSnapshotsRequest = DescribeClusterSnapshotsRequest {}): DescribeClusterSnapshotsResponse

    /**
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all snapshots that have any combination of those values are returned. Only snapshots that you own are returned in the response; shared snapshots are not returned with the tag key and tag value request parameters.
     *
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusterSnapshots(block: DescribeClusterSnapshotsRequest.Builder.() -> Unit) = describeClusterSnapshots(DescribeClusterSnapshotsRequest.Builder().apply(block).build())

    /**
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subnet groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusterSubnetGroups(input: DescribeClusterSubnetGroupsRequest = DescribeClusterSubnetGroupsRequest {}): DescribeClusterSubnetGroupsResponse

    /**
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subnet groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusterSubnetGroups(block: DescribeClusterSubnetGroupsRequest.Builder.() -> Unit) = describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all the available maintenance tracks.
     */
    suspend fun describeClusterTracks(input: DescribeClusterTracksRequest = DescribeClusterTracksRequest {}): DescribeClusterTracksResponse

    /**
     * Returns a list of all the available maintenance tracks.
     */
    suspend fun describeClusterTracks(block: DescribeClusterTracksRequest.Builder.() -> Unit) = describeClusterTracks(DescribeClusterTracksRequest.Builder().apply(block).build())

    /**
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before creating any clusters to learn more about the Amazon Redshift versions. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeClusterVersions(input: DescribeClusterVersionsRequest = DescribeClusterVersionsRequest {}): DescribeClusterVersionsResponse

    /**
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before creating any clusters to learn more about the Amazon Redshift versions. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeClusterVersions(block: DescribeClusterVersionsRequest.Builder.() -> Unit) = describeClusterVersions(DescribeClusterVersionsRequest.Builder().apply(block).build())

    /**
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties, maintenance and backup properties, and security and access properties. This operation supports pagination. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all clusters that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusters(input: DescribeClustersRequest = DescribeClustersRequest {}): DescribeClustersResponse

    /**
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties, maintenance and backup properties, and security and access properties. This operation supports pagination. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all clusters that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeClusters(block: DescribeClustersRequest.Builder.() -> Unit) = describeClusters(DescribeClustersRequest.Builder().apply(block).build())

    /**
     * Shows the status of any inbound or outbound datashares available in the specified account.
     */
    suspend fun describeDataShares(input: DescribeDataSharesRequest = DescribeDataSharesRequest {}): DescribeDataSharesResponse

    /**
     * Shows the status of any inbound or outbound datashares available in the specified account.
     */
    suspend fun describeDataShares(block: DescribeDataSharesRequest.Builder.() -> Unit) = describeDataShares(DescribeDataSharesRequest.Builder().apply(block).build())

    /**
     * Returns a list of datashares where the account identifier being called is a consumer account identifier.
     */
    suspend fun describeDataSharesForConsumer(input: DescribeDataSharesForConsumerRequest = DescribeDataSharesForConsumerRequest {}): DescribeDataSharesForConsumerResponse

    /**
     * Returns a list of datashares where the account identifier being called is a consumer account identifier.
     */
    suspend fun describeDataSharesForConsumer(block: DescribeDataSharesForConsumerRequest.Builder.() -> Unit) = describeDataSharesForConsumer(DescribeDataSharesForConsumerRequest.Builder().apply(block).build())

    /**
     * Returns a list of datashares when the account identifier being called is a producer account identifier.
     */
    suspend fun describeDataSharesForProducer(input: DescribeDataSharesForProducerRequest = DescribeDataSharesForProducerRequest {}): DescribeDataSharesForProducerResponse

    /**
     * Returns a list of datashares when the account identifier being called is a producer account identifier.
     */
    suspend fun describeDataSharesForProducer(block: DescribeDataSharesForProducerRequest.Builder.() -> Unit) = describeDataSharesForProducer(DescribeDataSharesForProducerRequest.Builder().apply(block).build())

    /**
     * Returns a list of parameter settings for the specified parameter group family.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeDefaultClusterParameters(input: DescribeDefaultClusterParametersRequest): DescribeDefaultClusterParametersResponse

    /**
     * Returns a list of parameter settings for the specified parameter group family.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeDefaultClusterParameters(block: DescribeDefaultClusterParametersRequest.Builder.() -> Unit) = describeDefaultClusterParameters(DescribeDefaultClusterParametersRequest.Builder().apply(block).build())

    /**
     * Describes a Redshift-managed VPC endpoint.
     */
    suspend fun describeEndpointAccess(input: DescribeEndpointAccessRequest = DescribeEndpointAccessRequest {}): DescribeEndpointAccessResponse

    /**
     * Describes a Redshift-managed VPC endpoint.
     */
    suspend fun describeEndpointAccess(block: DescribeEndpointAccessRequest.Builder.() -> Unit) = describeEndpointAccess(DescribeEndpointAccessRequest.Builder().apply(block).build())

    /**
     * Describes an endpoint authorization.
     */
    suspend fun describeEndpointAuthorization(input: DescribeEndpointAuthorizationRequest = DescribeEndpointAuthorizationRequest {}): DescribeEndpointAuthorizationResponse

    /**
     * Describes an endpoint authorization.
     */
    suspend fun describeEndpointAuthorization(block: DescribeEndpointAuthorizationRequest.Builder.() -> Unit) = describeEndpointAuthorization(DescribeEndpointAuthorizationRequest.Builder().apply(block).build())

    /**
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the event categories and source types, go to [Amazon Redshift Event Notifications](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html).
     */
    suspend fun describeEventCategories(input: DescribeEventCategoriesRequest = DescribeEventCategoriesRequest {}): DescribeEventCategoriesResponse

    /**
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the event categories and source types, go to [Amazon Redshift Event Notifications](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html).
     */
    suspend fun describeEventCategories(block: DescribeEventCategoriesRequest.Builder.() -> Unit) = describeEventCategories(DescribeEventCategoriesRequest.Builder().apply(block).build())

    /**
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification subscriptions that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subscriptions that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest = DescribeEventSubscriptionsRequest {}): DescribeEventSubscriptionsResponse

    /**
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification subscriptions that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subscriptions that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeEventSubscriptions(block: DescribeEventSubscriptionsRequest.Builder.() -> Unit) = describeEventSubscriptions(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

    /**
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     */
    suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest {}): DescribeEventsResponse

    /**
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     */
    suspend fun describeEvents(block: DescribeEventsRequest.Builder.() -> Unit) = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

    /**
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns information about all the HSM certificates owned by your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client certificates that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM client certificates that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeHsmClientCertificates(input: DescribeHsmClientCertificatesRequest = DescribeHsmClientCertificatesRequest {}): DescribeHsmClientCertificatesResponse

    /**
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns information about all the HSM certificates owned by your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client certificates that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM client certificates that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeHsmClientCertificates(block: DescribeHsmClientCertificatesRequest.Builder.() -> Unit) = describeHsmClientCertificates(DescribeHsmClientCertificatesRequest.Builder().apply(block).build())

    /**
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified, returns information about all the HSM configurations owned by your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM connections that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeHsmConfigurations(input: DescribeHsmConfigurationsRequest = DescribeHsmConfigurationsRequest {}): DescribeHsmConfigurationsResponse

    /**
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified, returns information about all the HSM configurations owned by your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM connections that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeHsmConfigurations(block: DescribeHsmConfigurationsRequest.Builder.() -> Unit) = describeHsmConfigurations(DescribeHsmConfigurationsRequest.Builder().apply(block).build())

    /**
     * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon Redshift cluster.
     */
    suspend fun describeLoggingStatus(input: DescribeLoggingStatusRequest): DescribeLoggingStatusResponse

    /**
     * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon Redshift cluster.
     */
    suspend fun describeLoggingStatus(block: DescribeLoggingStatusRequest.Builder.() -> Unit) = describeLoggingStatus(DescribeLoggingStatusRequest.Builder().apply(block).build())

    /**
     * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.
     */
    suspend fun describeNodeConfigurationOptions(input: DescribeNodeConfigurationOptionsRequest): DescribeNodeConfigurationOptionsResponse

    /**
     * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.
     */
    suspend fun describeNodeConfigurationOptions(block: DescribeNodeConfigurationOptionsRequest.Builder.() -> Unit) = describeNodeConfigurationOptions(DescribeNodeConfigurationOptionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU and price. With the cost involved you might want to obtain a list of cluster options in the specific region and specify values when creating a cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeOrderableClusterOptions(input: DescribeOrderableClusterOptionsRequest = DescribeOrderableClusterOptionsRequest {}): DescribeOrderableClusterOptionsResponse

    /**
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU and price. With the cost involved you might want to obtain a list of cluster options in the specific region and specify values when creating a cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeOrderableClusterOptions(block: DescribeOrderableClusterOptionsRequest.Builder.() -> Unit) = describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest.Builder().apply(block).build())

    /**
     * Returns information about the partner integrations defined for a cluster.
     */
    suspend fun describePartners(input: DescribePartnersRequest): DescribePartnersResponse

    /**
     * Returns information about the partner integrations defined for a cluster.
     */
    suspend fun describePartners(block: DescribePartnersRequest.Builder.() -> Unit) = describePartners(DescribePartnersRequest.Builder().apply(block).build())

    /**
     * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such values as in progress and requested.
     */
    suspend fun describeReservedNodeExchangeStatus(input: DescribeReservedNodeExchangeStatusRequest = DescribeReservedNodeExchangeStatusRequest {}): DescribeReservedNodeExchangeStatusResponse

    /**
     * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such values as in progress and requested.
     */
    suspend fun describeReservedNodeExchangeStatus(block: DescribeReservedNodeExchangeStatusRequest.Builder.() -> Unit) = describeReservedNodeExchangeStatus(DescribeReservedNodeExchangeStatusRequest.Builder().apply(block).build())

    /**
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to PurchaseReservedNodeOffering to reserve one or more nodes for your Amazon Redshift cluster.
     *
     *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeReservedNodeOfferings(input: DescribeReservedNodeOfferingsRequest = DescribeReservedNodeOfferingsRequest {}): DescribeReservedNodeOfferingsResponse

    /**
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to PurchaseReservedNodeOffering to reserve one or more nodes for your Amazon Redshift cluster.
     *
     *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeReservedNodeOfferings(block: DescribeReservedNodeOfferingsRequest.Builder.() -> Unit) = describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest.Builder().apply(block).build())

    /**
     * Returns the descriptions of the reserved nodes.
     */
    suspend fun describeReservedNodes(input: DescribeReservedNodesRequest = DescribeReservedNodesRequest {}): DescribeReservedNodesResponse

    /**
     * Returns the descriptions of the reserved nodes.
     */
    suspend fun describeReservedNodes(block: DescribeReservedNodesRequest.Builder.() -> Unit) = describeReservedNodes(DescribeReservedNodesRequest.Builder().apply(block).build())

    /**
     * Returns information about the last resize operation for the specified cluster. If no resize operation has ever been initiated for the specified cluster, a `HTTP 404` error is returned. If a resize operation was initiated and completed, the status of the resize remains as `SUCCEEDED` until the next resize.
     *
     * A resize operation can be requested using ModifyCluster and specifying a different number or type of nodes for the cluster.
     */
    suspend fun describeResize(input: DescribeResizeRequest): DescribeResizeResponse

    /**
     * Returns information about the last resize operation for the specified cluster. If no resize operation has ever been initiated for the specified cluster, a `HTTP 404` error is returned. If a resize operation was initiated and completed, the status of the resize remains as `SUCCEEDED` until the next resize.
     *
     * A resize operation can be requested using ModifyCluster and specifying a different number or type of nodes for the cluster.
     */
    suspend fun describeResize(block: DescribeResizeRequest.Builder.() -> Unit) = describeResize(DescribeResizeRequest.Builder().apply(block).build())

    /**
     * Describes properties of scheduled actions.
     */
    suspend fun describeScheduledActions(input: DescribeScheduledActionsRequest = DescribeScheduledActionsRequest {}): DescribeScheduledActionsResponse

    /**
     * Describes properties of scheduled actions.
     */
    suspend fun describeScheduledActions(block: DescribeScheduledActionsRequest.Builder.() -> Unit) = describeScheduledActions(DescribeScheduledActionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     *
     *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeSnapshotCopyGrants(input: DescribeSnapshotCopyGrantsRequest = DescribeSnapshotCopyGrantsRequest {}): DescribeSnapshotCopyGrantsResponse

    /**
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     *
     *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun describeSnapshotCopyGrants(block: DescribeSnapshotCopyGrantsRequest.Builder.() -> Unit) = describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest.Builder().apply(block).build())

    /**
     * Returns a list of snapshot schedules.
     */
    suspend fun describeSnapshotSchedules(input: DescribeSnapshotSchedulesRequest = DescribeSnapshotSchedulesRequest {}): DescribeSnapshotSchedulesResponse

    /**
     * Returns a list of snapshot schedules.
     */
    suspend fun describeSnapshotSchedules(block: DescribeSnapshotSchedulesRequest.Builder.() -> Unit) = describeSnapshotSchedules(DescribeSnapshotSchedulesRequest.Builder().apply(block).build())

    /**
     * Returns account level backups storage size and provisional storage.
     */
    suspend fun describeStorage(input: DescribeStorageRequest = DescribeStorageRequest {}): DescribeStorageResponse

    /**
     * Returns account level backups storage size and provisional storage.
     */
    suspend fun describeStorage(block: DescribeStorageRequest.Builder.() -> Unit) = describeStorage(DescribeStorageRequest.Builder().apply(block).build())

    /**
     * Lists the status of one or more table restore requests made using the RestoreTableFromClusterSnapshot API action. If you don't specify a value for the `TableRestoreRequestId` parameter, then `DescribeTableRestoreStatus` returns the status of all table restore requests ordered by the date and time of the request in ascending order. Otherwise `DescribeTableRestoreStatus` returns the status of the table specified by `TableRestoreRequestId`.
     */
    suspend fun describeTableRestoreStatus(input: DescribeTableRestoreStatusRequest = DescribeTableRestoreStatusRequest {}): DescribeTableRestoreStatusResponse

    /**
     * Lists the status of one or more table restore requests made using the RestoreTableFromClusterSnapshot API action. If you don't specify a value for the `TableRestoreRequestId` parameter, then `DescribeTableRestoreStatus` returns the status of all table restore requests ordered by the date and time of the request in ascending order. Otherwise `DescribeTableRestoreStatus` returns the status of the table specified by `TableRestoreRequestId`.
     */
    suspend fun describeTableRestoreStatus(block: DescribeTableRestoreStatusRequest.Builder.() -> Unit) = describeTableRestoreStatus(DescribeTableRestoreStatusRequest.Builder().apply(block).build())

    /**
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all tags for a given type of resource, such as clusters, snapshots, and so on.
     *
     * The following are limitations for `DescribeTags`:
     * + You cannot specify an ARN and a resource-type value together in the same request.
     * + You cannot use the `MaxRecords` and `Marker` parameters together with the ARN parameter.
     * + The `MaxRecords` parameter can be a range from 10 to 50 results to return in a request.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all resources that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeTags(input: DescribeTagsRequest = DescribeTagsRequest {}): DescribeTagsResponse

    /**
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all tags for a given type of resource, such as clusters, snapshots, and so on.
     *
     * The following are limitations for `DescribeTags`:
     * + You cannot specify an ARN and a resource-type value together in the same request.
     * + You cannot use the `MaxRecords` and `Marker` parameters together with the ARN parameter.
     * + The `MaxRecords` parameter can be a range from 10 to 50 results to return in a request.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all resources that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have tag keys or values associated with them.
     */
    suspend fun describeTags(block: DescribeTagsRequest.Builder.() -> Unit) = describeTags(DescribeTagsRequest.Builder().apply(block).build())

    /**
     * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:
     * + If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects for the current account in the current region are returned.
     * + If usage limit identifier is provided, then the corresponding usage limit object is returned.
     * + If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
     * + If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster and feature are returned.
     */
    suspend fun describeUsageLimits(input: DescribeUsageLimitsRequest = DescribeUsageLimitsRequest {}): DescribeUsageLimitsResponse

    /**
     * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:
     * + If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects for the current account in the current region are returned.
     * + If usage limit identifier is provided, then the corresponding usage limit object is returned.
     * + If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
     * + If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster and feature are returned.
     */
    suspend fun describeUsageLimits(block: DescribeUsageLimitsRequest.Builder.() -> Unit) = describeUsageLimits(DescribeUsageLimitsRequest.Builder().apply(block).build())

    /**
     * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    suspend fun disableLogging(input: DisableLoggingRequest): DisableLoggingResponse

    /**
     * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    suspend fun disableLogging(block: DisableLoggingRequest.Builder.() -> Unit) = disableLogging(DisableLoggingRequest.Builder().apply(block).build())

    /**
     * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
     *
     * If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use DeleteSnapshotCopyGrant to delete the grant that grants Amazon Redshift permission to the key in the destination region.
     */
    suspend fun disableSnapshotCopy(input: DisableSnapshotCopyRequest): DisableSnapshotCopyResponse

    /**
     * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
     *
     * If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use DeleteSnapshotCopyGrant to delete the grant that grants Amazon Redshift permission to the key in the destination region.
     */
    suspend fun disableSnapshotCopy(block: DisableSnapshotCopyRequest.Builder.() -> Unit) = disableSnapshotCopy(DisableSnapshotCopyRequest.Builder().apply(block).build())

    /**
     * From a datashare consumer account, remove association for the specified datashare.
     */
    suspend fun disassociateDataShareConsumer(input: DisassociateDataShareConsumerRequest): DisassociateDataShareConsumerResponse

    /**
     * From a datashare consumer account, remove association for the specified datashare.
     */
    suspend fun disassociateDataShareConsumer(block: DisassociateDataShareConsumerRequest.Builder.() -> Unit) = disassociateDataShareConsumer(DisassociateDataShareConsumerRequest.Builder().apply(block).build())

    /**
     * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    suspend fun enableLogging(input: EnableLoggingRequest): EnableLoggingResponse

    /**
     * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    suspend fun enableLogging(block: EnableLoggingRequest.Builder.() -> Unit) = enableLogging(EnableLoggingRequest.Builder().apply(block).build())

    /**
     * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
     */
    suspend fun enableSnapshotCopy(input: EnableSnapshotCopyRequest): EnableSnapshotCopyResponse

    /**
     * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
     */
    suspend fun enableSnapshotCopy(block: EnableSnapshotCopyRequest.Builder.() -> Unit) = enableSnapshotCopy(EnableSnapshotCopyRequest.Builder().apply(block).build())

    /**
     * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift database. The action returns the database user name prefixed with `IAM:` if `AutoCreate` is `False` or `IAMA:` if `AutoCreate` is `True`. You can optionally specify one or more database user groups that the user will join at log on. By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes). For more information, see [Using IAM Authentication to Generate Database User Credentials](https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html) in the Amazon Redshift Cluster Management Guide.
     *
     * The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Resource Policies for GetClusterCredentials](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources) in the Amazon Redshift Cluster Management Guide.
     *
     * If the `DbGroups` parameter is specified, the IAM policy must allow the `redshift:JoinGroup` action with access to the listed `dbgroups`.
     *
     * In addition, if the `AutoCreate` parameter is set to `True`, then the policy must include the `redshift:CreateClusterUser` permission.
     *
     * If the `DbName` parameter is specified, the IAM policy must allow access to the resource `dbname` for the specified database name.
     */
    suspend fun getClusterCredentials(input: GetClusterCredentialsRequest): GetClusterCredentialsResponse

    /**
     * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift database. The action returns the database user name prefixed with `IAM:` if `AutoCreate` is `False` or `IAMA:` if `AutoCreate` is `True`. You can optionally specify one or more database user groups that the user will join at log on. By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes). For more information, see [Using IAM Authentication to Generate Database User Credentials](https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html) in the Amazon Redshift Cluster Management Guide.
     *
     * The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Resource Policies for GetClusterCredentials](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources) in the Amazon Redshift Cluster Management Guide.
     *
     * If the `DbGroups` parameter is specified, the IAM policy must allow the `redshift:JoinGroup` action with access to the listed `dbgroups`.
     *
     * In addition, if the `AutoCreate` parameter is set to `True`, then the policy must include the `redshift:CreateClusterUser` permission.
     *
     * If the `DbName` parameter is specified, the IAM policy must allow access to the resource `dbname` for the specified database name.
     */
    suspend fun getClusterCredentials(block: GetClusterCredentialsRequest.Builder.() -> Unit) = getClusterCredentials(GetClusterCredentialsRequest.Builder().apply(block).build())

    /**
     * Returns a database user name and temporary password with temporary authorization to log in to an Amazon Redshift database. The database user is mapped 1:1 to the source Identity and Access Management (IAM) identity. For more information about IAM identities, see [IAM Identities (users, user groups, and roles)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html) in the Amazon Web Services Identity and Access Management User Guide.
     *
     * The Identity and Access Management (IAM) identity that runs this operation must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Using identity-based policies (IAM policies)](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the Amazon Redshift Cluster Management Guide.
     */
    suspend fun getClusterCredentialsWithIam(input: GetClusterCredentialsWithIamRequest): GetClusterCredentialsWithIamResponse

    /**
     * Returns a database user name and temporary password with temporary authorization to log in to an Amazon Redshift database. The database user is mapped 1:1 to the source Identity and Access Management (IAM) identity. For more information about IAM identities, see [IAM Identities (users, user groups, and roles)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html) in the Amazon Web Services Identity and Access Management User Guide.
     *
     * The Identity and Access Management (IAM) identity that runs this operation must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Using identity-based policies (IAM policies)](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the Amazon Redshift Cluster Management Guide.
     */
    suspend fun getClusterCredentialsWithIam(block: GetClusterCredentialsWithIamRequest.Builder.() -> Unit) = getClusterCredentialsWithIam(GetClusterCredentialsWithIamRequest.Builder().apply(block).build())

    /**
     * Gets the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node offering. Details include the node type, the price, the node count, and the offering type.
     */
    suspend fun getReservedNodeExchangeConfigurationOptions(input: GetReservedNodeExchangeConfigurationOptionsRequest): GetReservedNodeExchangeConfigurationOptionsResponse

    /**
     * Gets the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node offering. Details include the node type, the price, the node count, and the offering type.
     */
    suspend fun getReservedNodeExchangeConfigurationOptions(block: GetReservedNodeExchangeConfigurationOptionsRequest.Builder.() -> Unit) = getReservedNodeExchangeConfigurationOptions(GetReservedNodeExchangeConfigurationOptionsRequest.Builder().apply(block).build())

    /**
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.
     */
    suspend fun getReservedNodeExchangeOfferings(input: GetReservedNodeExchangeOfferingsRequest): GetReservedNodeExchangeOfferingsResponse

    /**
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.
     */
    suspend fun getReservedNodeExchangeOfferings(block: GetReservedNodeExchangeOfferingsRequest.Builder.() -> Unit) = getReservedNodeExchangeOfferings(GetReservedNodeExchangeOfferingsRequest.Builder().apply(block).build())

    /**
     * Modifies whether a cluster can use AQUA (Advanced Query Accelerator).
     */
    suspend fun modifyAquaConfiguration(input: ModifyAquaConfigurationRequest): ModifyAquaConfigurationResponse

    /**
     * Modifies whether a cluster can use AQUA (Advanced Query Accelerator).
     */
    suspend fun modifyAquaConfiguration(block: ModifyAquaConfigurationRequest.Builder.() -> Unit) = modifyAquaConfiguration(ModifyAquaConfigurationRequest.Builder().apply(block).build())

    /**
     * Modifies an authentication profile.
     */
    suspend fun modifyAuthenticationProfile(input: ModifyAuthenticationProfileRequest): ModifyAuthenticationProfileResponse

    /**
     * Modifies an authentication profile.
     */
    suspend fun modifyAuthenticationProfile(block: ModifyAuthenticationProfileRequest.Builder.() -> Unit) = modifyAuthenticationProfile(ModifyAuthenticationProfileRequest.Builder().apply(block).build())

    /**
     * Modifies the settings for a cluster.
     *
     * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster, you must specify both the number of nodes and the node type even if one of the parameters does not change.
     *
     * You can add another security or parameter group, or change the admin user password. Resetting a cluster password or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a reboot for parameters to take effect. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun modifyCluster(input: ModifyClusterRequest): ModifyClusterResponse

    /**
     * Modifies the settings for a cluster.
     *
     * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster, you must specify both the number of nodes and the node type even if one of the parameters does not change.
     *
     * You can add another security or parameter group, or change the admin user password. Resetting a cluster password or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a reboot for parameters to take effect. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun modifyCluster(block: ModifyClusterRequest.Builder.() -> Unit) = modifyCluster(ModifyClusterRequest.Builder().apply(block).build())

    /**
     * Modifies the database revision of a cluster. The database revision is a unique revision of the database running in a cluster.
     */
    suspend fun modifyClusterDbRevision(input: ModifyClusterDbRevisionRequest): ModifyClusterDbRevisionResponse

    /**
     * Modifies the database revision of a cluster. The database revision is a unique revision of the database running in a cluster.
     */
    suspend fun modifyClusterDbRevision(block: ModifyClusterDbRevisionRequest.Builder.() -> Unit) = modifyClusterDbRevision(ModifyClusterDbRevisionRequest.Builder().apply(block).build())

    /**
     * Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.
     *
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to [Quotas and limits](https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun modifyClusterIamRoles(input: ModifyClusterIamRolesRequest): ModifyClusterIamRolesResponse

    /**
     * Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.
     *
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to [Quotas and limits](https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun modifyClusterIamRoles(block: ModifyClusterIamRolesRequest.Builder.() -> Unit) = modifyClusterIamRoles(ModifyClusterIamRolesRequest.Builder().apply(block).build())

    /**
     * Modifies the maintenance settings of a cluster.
     */
    suspend fun modifyClusterMaintenance(input: ModifyClusterMaintenanceRequest): ModifyClusterMaintenanceResponse

    /**
     * Modifies the maintenance settings of a cluster.
     */
    suspend fun modifyClusterMaintenance(block: ModifyClusterMaintenanceRequest.Builder.() -> Unit) = modifyClusterMaintenance(ModifyClusterMaintenanceRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun modifyClusterParameterGroup(input: ModifyClusterParameterGroupRequest): ModifyClusterParameterGroupResponse

    /**
     * Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun modifyClusterParameterGroup(block: ModifyClusterParameterGroupRequest.Builder.() -> Unit) = modifyClusterParameterGroup(ModifyClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Modifies the settings for a snapshot.
     *
     * This exanmple modifies the manual retention period setting for a cluster snapshot.
     */
    suspend fun modifyClusterSnapshot(input: ModifyClusterSnapshotRequest): ModifyClusterSnapshotResponse

    /**
     * Modifies the settings for a snapshot.
     *
     * This exanmple modifies the manual retention period setting for a cluster snapshot.
     */
    suspend fun modifyClusterSnapshot(block: ModifyClusterSnapshotRequest.Builder.() -> Unit) = modifyClusterSnapshot(ModifyClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Modifies a snapshot schedule for a cluster.
     */
    suspend fun modifyClusterSnapshotSchedule(input: ModifyClusterSnapshotScheduleRequest): ModifyClusterSnapshotScheduleResponse

    /**
     * Modifies a snapshot schedule for a cluster.
     */
    suspend fun modifyClusterSnapshotSchedule(block: ModifyClusterSnapshotScheduleRequest.Builder.() -> Unit) = modifyClusterSnapshotSchedule(ModifyClusterSnapshotScheduleRequest.Builder().apply(block).build())

    /**
     * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing list of subnets with the new list of subnets.
     */
    suspend fun modifyClusterSubnetGroup(input: ModifyClusterSubnetGroupRequest): ModifyClusterSubnetGroupResponse

    /**
     * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing list of subnets with the new list of subnets.
     */
    suspend fun modifyClusterSubnetGroup(block: ModifyClusterSubnetGroupRequest.Builder.() -> Unit) = modifyClusterSubnetGroup(ModifyClusterSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Modifies a Redshift-managed VPC endpoint.
     */
    suspend fun modifyEndpointAccess(input: ModifyEndpointAccessRequest): ModifyEndpointAccessResponse

    /**
     * Modifies a Redshift-managed VPC endpoint.
     */
    suspend fun modifyEndpointAccess(block: ModifyEndpointAccessRequest.Builder.() -> Unit) = modifyEndpointAccess(ModifyEndpointAccessRequest.Builder().apply(block).build())

    /**
     * Modifies an existing Amazon Redshift event notification subscription.
     */
    suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse

    /**
     * Modifies an existing Amazon Redshift event notification subscription.
     */
    suspend fun modifyEventSubscription(block: ModifyEventSubscriptionRequest.Builder.() -> Unit) = modifyEventSubscription(ModifyEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Modifies a scheduled action.
     */
    suspend fun modifyScheduledAction(input: ModifyScheduledActionRequest): ModifyScheduledActionResponse

    /**
     * Modifies a scheduled action.
     */
    suspend fun modifyScheduledAction(block: ModifyScheduledActionRequest.Builder.() -> Unit) = modifyScheduledAction(ModifyScheduledActionRequest.Builder().apply(block).build())

    /**
     * Modifies the number of days to retain snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. By default, this operation only changes the retention period of copied automated snapshots. The retention periods for both new and existing copied automated snapshots are updated with the new retention period. You can set the manual option to change only the retention periods of copied manual snapshots. If you set this option, only newly copied manual snapshots have the new retention period.
     */
    suspend fun modifySnapshotCopyRetentionPeriod(input: ModifySnapshotCopyRetentionPeriodRequest): ModifySnapshotCopyRetentionPeriodResponse

    /**
     * Modifies the number of days to retain snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. By default, this operation only changes the retention period of copied automated snapshots. The retention periods for both new and existing copied automated snapshots are updated with the new retention period. You can set the manual option to change only the retention periods of copied manual snapshots. If you set this option, only newly copied manual snapshots have the new retention period.
     */
    suspend fun modifySnapshotCopyRetentionPeriod(block: ModifySnapshotCopyRetentionPeriodRequest.Builder.() -> Unit) = modifySnapshotCopyRetentionPeriod(ModifySnapshotCopyRetentionPeriodRequest.Builder().apply(block).build())

    /**
     * Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.
     */
    suspend fun modifySnapshotSchedule(input: ModifySnapshotScheduleRequest): ModifySnapshotScheduleResponse

    /**
     * Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.
     */
    suspend fun modifySnapshotSchedule(block: ModifySnapshotScheduleRequest.Builder.() -> Unit) = modifySnapshotSchedule(ModifySnapshotScheduleRequest.Builder().apply(block).build())

    /**
     * Modifies a usage limit in a cluster. You can't modify the feature type or period of a usage limit.
     */
    suspend fun modifyUsageLimit(input: ModifyUsageLimitRequest): ModifyUsageLimitResponse

    /**
     * Modifies a usage limit in a cluster. You can't modify the feature type or period of a usage limit.
     */
    suspend fun modifyUsageLimit(block: ModifyUsageLimitRequest.Builder.() -> Unit) = modifyUsageLimit(ModifyUsageLimitRequest.Builder().apply(block).build())

    /**
     * Pauses a cluster.
     */
    suspend fun pauseCluster(input: PauseClusterRequest): PauseClusterResponse

    /**
     * Pauses a cluster.
     */
    suspend fun pauseCluster(block: PauseClusterRequest.Builder.() -> Unit) = pauseCluster(PauseClusterRequest.Builder().apply(block).build())

    /**
     * Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You can purchase one or more of the offerings. You can call the DescribeReservedNodeOfferings API to obtain the available reserved node offerings. You can call this API by providing a specific reserved node offering and the number of nodes you want to reserve.
     *
     *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun purchaseReservedNodeOffering(input: PurchaseReservedNodeOfferingRequest): PurchaseReservedNodeOfferingResponse

    /**
     * Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You can purchase one or more of the offerings. You can call the DescribeReservedNodeOfferings API to obtain the available reserved node offerings. You can call this API by providing a specific reserved node offering and the number of nodes you want to reserve.
     *
     *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun purchaseReservedNodeOffering(block: PurchaseReservedNodeOfferingRequest.Builder.() -> Unit) = purchaseReservedNodeOffering(PurchaseReservedNodeOfferingRequest.Builder().apply(block).build())

    /**
     * Reboots a cluster. This action is taken as soon as possible. It results in a momentary outage to the cluster, during which the cluster status is set to `rebooting`. A cluster event is created when the reboot is completed. Any pending cluster modifications (see ModifyCluster) are applied at this reboot. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun rebootCluster(input: RebootClusterRequest): RebootClusterResponse

    /**
     * Reboots a cluster. This action is taken as soon as possible. It results in a momentary outage to the cluster, during which the cluster status is set to `rebooting`. A cluster event is created when the reboot is completed. Any pending cluster modifications (see ModifyCluster) are applied at this reboot. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun rebootCluster(block: RebootClusterRequest.Builder.() -> Unit) = rebootCluster(RebootClusterRequest.Builder().apply(block).build())

    /**
     * From a datashare consumer account, rejects the specified datashare.
     */
    suspend fun rejectDataShare(input: RejectDataShareRequest): RejectDataShareResponse

    /**
     * From a datashare consumer account, rejects the specified datashare.
     */
    suspend fun rejectDataShare(block: RejectDataShareRequest.Builder.() -> Unit) = rejectDataShare(RejectDataShareRequest.Builder().apply(block).build())

    /**
     * Sets one or more parameters of the specified parameter group to their default values and sets the source values of the parameters to "engine-default". To reset the entire parameter group specify the *ResetAllParameters* parameter. For parameter changes to take effect you must reboot any associated clusters.
     */
    suspend fun resetClusterParameterGroup(input: ResetClusterParameterGroupRequest): ResetClusterParameterGroupResponse

    /**
     * Sets one or more parameters of the specified parameter group to their default values and sets the source values of the parameters to "engine-default". To reset the entire parameter group specify the *ResetAllParameters* parameter. For parameter changes to take effect you must reboot any associated clusters.
     */
    suspend fun resetClusterParameterGroup(block: ResetClusterParameterGroupRequest.Builder.() -> Unit) = resetClusterParameterGroup(ResetClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Changes the size of the cluster. You can change the cluster's type, or change the number or type of nodes. The default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read and write operations more quickly than with the classic resize method.
     *
     * Elastic resize operations have the following restrictions:
     * + You can only resize clusters of the following types:
     *    + dc1.large (if your cluster is in a VPC)
     *    + dc1.8xlarge (if your cluster is in a VPC)
     *    + dc2.large
     *    + dc2.8xlarge
     *    + ds2.xlarge
     *    + ds2.8xlarge
     *    + ra3.xlplus
     *    + ra3.4xlarge
     *    + ra3.16xlarge
     * + The type of nodes that you add must match the node type for the cluster.
     */
    suspend fun resizeCluster(input: ResizeClusterRequest): ResizeClusterResponse

    /**
     * Changes the size of the cluster. You can change the cluster's type, or change the number or type of nodes. The default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read and write operations more quickly than with the classic resize method.
     *
     * Elastic resize operations have the following restrictions:
     * + You can only resize clusters of the following types:
     *    + dc1.large (if your cluster is in a VPC)
     *    + dc1.8xlarge (if your cluster is in a VPC)
     *    + dc2.large
     *    + dc2.8xlarge
     *    + ds2.xlarge
     *    + ds2.8xlarge
     *    + ra3.xlplus
     *    + ra3.4xlarge
     *    + ra3.16xlarge
     * + The type of nodes that you add must match the node type for the cluster.
     */
    suspend fun resizeCluster(block: ResizeClusterRequest.Builder.() -> Unit) = resizeCluster(ResizeClusterRequest.Builder().apply(block).build())

    /**
     * Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same configuration as the original cluster from which the snapshot was created, except that the new cluster is created with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use the ModifyCluster API to associate a different security group and different parameter group with the restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the same size during restore.
     *
     * If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun restoreFromClusterSnapshot(input: RestoreFromClusterSnapshotRequest): RestoreFromClusterSnapshotResponse

    /**
     * Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same configuration as the original cluster from which the snapshot was created, except that the new cluster is created with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use the ModifyCluster API to associate a different security group and different parameter group with the restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the same size during restore.
     *
     * If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun restoreFromClusterSnapshot(block: RestoreFromClusterSnapshotRequest.Builder.() -> Unit) = restoreFromClusterSnapshot(RestoreFromClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the Amazon Redshift cluster that the snapshot was taken from.
     *
     * You cannot use `RestoreTableFromClusterSnapshot` to restore a table with the same name as an existing table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored table. If you want to replace your original table with a new, restored table, then rename or drop your original table before you call `RestoreTableFromClusterSnapshot`. When you have renamed your original table, then you can pass the original name of the table as the `NewTableName` parameter value in the call to `RestoreTableFromClusterSnapshot`. This way, you can replace the original table with the table created from the snapshot.
     */
    suspend fun restoreTableFromClusterSnapshot(input: RestoreTableFromClusterSnapshotRequest): RestoreTableFromClusterSnapshotResponse

    /**
     * Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the Amazon Redshift cluster that the snapshot was taken from.
     *
     * You cannot use `RestoreTableFromClusterSnapshot` to restore a table with the same name as an existing table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored table. If you want to replace your original table with a new, restored table, then rename or drop your original table before you call `RestoreTableFromClusterSnapshot`. When you have renamed your original table, then you can pass the original name of the table as the `NewTableName` parameter value in the call to `RestoreTableFromClusterSnapshot`. This way, you can replace the original table with the table created from the snapshot.
     */
    suspend fun restoreTableFromClusterSnapshot(block: RestoreTableFromClusterSnapshotRequest.Builder.() -> Unit) = restoreTableFromClusterSnapshot(RestoreTableFromClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Resumes a paused cluster.
     */
    suspend fun resumeCluster(input: ResumeClusterRequest): ResumeClusterResponse

    /**
     * Resumes a paused cluster.
     */
    suspend fun resumeCluster(block: ResumeClusterRequest.Builder.() -> Unit) = resumeCluster(ResumeClusterRequest.Builder().apply(block).build())

    /**
     * Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2 security group. To add an ingress rule, see AuthorizeClusterSecurityGroupIngress. For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun revokeClusterSecurityGroupIngress(input: RevokeClusterSecurityGroupIngressRequest): RevokeClusterSecurityGroupIngressResponse

    /**
     * Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2 security group. To add an ingress rule, see AuthorizeClusterSecurityGroupIngress. For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun revokeClusterSecurityGroupIngress(block: RevokeClusterSecurityGroupIngressRequest.Builder.() -> Unit) = revokeClusterSecurityGroupIngress(RevokeClusterSecurityGroupIngressRequest.Builder().apply(block).build())

    /**
     * Revokes access to a cluster.
     */
    suspend fun revokeEndpointAccess(input: RevokeEndpointAccessRequest = RevokeEndpointAccessRequest {}): RevokeEndpointAccessResponse

    /**
     * Revokes access to a cluster.
     */
    suspend fun revokeEndpointAccess(block: RevokeEndpointAccessRequest.Builder.() -> Unit) = revokeEndpointAccess(RevokeEndpointAccessRequest.Builder().apply(block).build())

    /**
     * Removes the ability of the specified Amazon Web Services account to restore the specified snapshot. If the account is currently restoring the snapshot, the restore will run to completion.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun revokeSnapshotAccess(input: RevokeSnapshotAccessRequest): RevokeSnapshotAccessResponse

    /**
     * Removes the ability of the specified Amazon Web Services account to restore the specified snapshot. If the account is currently restoring the snapshot, the restore will run to completion.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    suspend fun revokeSnapshotAccess(block: RevokeSnapshotAccessRequest.Builder.() -> Unit) = revokeSnapshotAccess(RevokeSnapshotAccessRequest.Builder().apply(block).build())

    /**
     * Rotates the encryption keys for a cluster.
     */
    suspend fun rotateEncryptionKey(input: RotateEncryptionKeyRequest): RotateEncryptionKeyResponse

    /**
     * Rotates the encryption keys for a cluster.
     */
    suspend fun rotateEncryptionKey(block: RotateEncryptionKeyRequest.Builder.() -> Unit) = rotateEncryptionKey(RotateEncryptionKeyRequest.Builder().apply(block).build())

    /**
     * Updates the status of a partner integration.
     */
    suspend fun updatePartnerStatus(input: UpdatePartnerStatusRequest): UpdatePartnerStatusResponse

    /**
     * Updates the status of a partner integration.
     */
    suspend fun updatePartnerStatus(block: UpdatePartnerStatusRequest.Builder.() -> Unit) = updatePartnerStatus(UpdatePartnerStatusRequest.Builder().apply(block).build())
}
