// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The association of a datashare from a producer account with a data consumer.
 */
class DataShareAssociation private constructor(builder: Builder) {
    /**
     * The name of the consumer accounts that have an association with a producer datashare.
     */
    val consumerIdentifier: kotlin.String? = builder.consumerIdentifier
    /**
     * The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.
     */
    val consumerRegion: kotlin.String? = builder.consumerRegion
    /**
     * The creation date of the datashare that is associated.
     */
    val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The status of the datashare that is associated.
     */
    val status: aws.sdk.kotlin.services.redshift.model.DataShareStatus? = builder.status
    /**
     * The status change data of the datashare that is associated.
     */
    val statusChangeDate: aws.smithy.kotlin.runtime.time.Instant? = builder.statusChangeDate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DataShareAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataShareAssociation(")
        append("consumerIdentifier=$consumerIdentifier,")
        append("consumerRegion=$consumerRegion,")
        append("createdDate=$createdDate,")
        append("status=$status,")
        append("statusChangeDate=$statusChangeDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumerIdentifier?.hashCode() ?: 0
        result = 31 * result + (consumerRegion?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusChangeDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataShareAssociation

        if (consumerIdentifier != other.consumerIdentifier) return false
        if (consumerRegion != other.consumerRegion) return false
        if (createdDate != other.createdDate) return false
        if (status != other.status) return false
        if (statusChangeDate != other.statusChangeDate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DataShareAssociation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the consumer accounts that have an association with a producer datashare.
         */
        var consumerIdentifier: kotlin.String? = null
        /**
         * The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.
         */
        var consumerRegion: kotlin.String? = null
        /**
         * The creation date of the datashare that is associated.
         */
        var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the datashare that is associated.
         */
        var status: aws.sdk.kotlin.services.redshift.model.DataShareStatus? = null
        /**
         * The status change data of the datashare that is associated.
         */
        var statusChangeDate: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DataShareAssociation) : this() {
            this.consumerIdentifier = x.consumerIdentifier
            this.consumerRegion = x.consumerRegion
            this.createdDate = x.createdDate
            this.status = x.status
            this.statusChangeDate = x.statusChangeDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DataShareAssociation = DataShareAssociation(this)
    }
}
