// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
class DescribeEventsRequest private constructor(builder: Builder) {
    /**
     * The number of minutes prior to the time of the request for which to retrieve events. For example, if the request is sent at 18:00 and you specify a duration of 60, then only events which have occurred after 17:00 will be returned.
     *
     * Default: `60`
     */
    val duration: kotlin.Int? = builder.duration
    /**
     * The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
     *
     * Example: `2009-07-08T18:00Z`
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeEvents request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
     *
     * Default: `100`
     *
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The identifier of the event source for which events will be returned. If this parameter is not specified, then all sources are included in the response.
     *
     * Constraints:
     *
     * If *SourceIdentifier* is supplied, *SourceType* must also be provided.
     * + Specify a cluster identifier when *SourceType* is `cluster`.
     * + Specify a cluster security group name when *SourceType* is `cluster-security-group`.
     * + Specify a cluster parameter group name when *SourceType* is `cluster-parameter-group`.
     * + Specify a cluster snapshot identifier when *SourceType* is `cluster-snapshot`.
     */
    val sourceIdentifier: kotlin.String? = builder.sourceIdentifier
    /**
     * The event source to retrieve events for. If no value is specified, all events are returned.
     *
     * Constraints:
     *
     * If *SourceType* is supplied, *SourceIdentifier* must also be provided.
     * + Specify `cluster` when *SourceIdentifier* is a cluster identifier.
     * + Specify `cluster-security-group` when *SourceIdentifier* is a cluster security group name.
     * + Specify `cluster-parameter-group` when *SourceIdentifier* is a cluster parameter group name.
     * + Specify `cluster-snapshot` when *SourceIdentifier* is a cluster snapshot identifier.
     */
    val sourceType: aws.sdk.kotlin.services.redshift.model.SourceType? = builder.sourceType
    /**
     * The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
     *
     * Example: `2009-07-08T18:00Z`
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DescribeEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEventsRequest(")
        append("duration=$duration,")
        append("endTime=$endTime,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("sourceIdentifier=$sourceIdentifier,")
        append("sourceType=$sourceType,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (sourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEventsRequest

        if (duration != other.duration) return false
        if (endTime != other.endTime) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (sourceIdentifier != other.sourceIdentifier) return false
        if (sourceType != other.sourceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DescribeEventsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of minutes prior to the time of the request for which to retrieve events. For example, if the request is sent at 18:00 and you specify a duration of 60, then only events which have occurred after 17:00 will be returned.
         *
         * Default: `60`
         */
        var duration: kotlin.Int? = null
        /**
         * The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
         *
         * Example: `2009-07-08T18:00Z`
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeEvents request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
         *
         * Default: `100`
         *
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * The identifier of the event source for which events will be returned. If this parameter is not specified, then all sources are included in the response.
         *
         * Constraints:
         *
         * If *SourceIdentifier* is supplied, *SourceType* must also be provided.
         * + Specify a cluster identifier when *SourceType* is `cluster`.
         * + Specify a cluster security group name when *SourceType* is `cluster-security-group`.
         * + Specify a cluster parameter group name when *SourceType* is `cluster-parameter-group`.
         * + Specify a cluster snapshot identifier when *SourceType* is `cluster-snapshot`.
         */
        var sourceIdentifier: kotlin.String? = null
        /**
         * The event source to retrieve events for. If no value is specified, all events are returned.
         *
         * Constraints:
         *
         * If *SourceType* is supplied, *SourceIdentifier* must also be provided.
         * + Specify `cluster` when *SourceIdentifier* is a cluster identifier.
         * + Specify `cluster-security-group` when *SourceIdentifier* is a cluster security group name.
         * + Specify `cluster-parameter-group` when *SourceIdentifier* is a cluster parameter group name.
         * + Specify `cluster-snapshot` when *SourceIdentifier* is a cluster snapshot identifier.
         */
        var sourceType: aws.sdk.kotlin.services.redshift.model.SourceType? = null
        /**
         * The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
         *
         * Example: `2009-07-08T18:00Z`
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DescribeEventsRequest) : this() {
            this.duration = x.duration
            this.endTime = x.endTime
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.sourceIdentifier = x.sourceIdentifier
            this.sourceType = x.sourceType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DescribeEventsRequest = DescribeEventsRequest(this)
    }
}
