// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes event subscriptions.
 */
class EventSubscription private constructor(builder: Builder) {
    /**
     * The name of the Amazon Redshift event notification subscription.
     */
    val custSubscriptionId: kotlin.String? = builder.custSubscriptionId
    /**
     * The Amazon Web Services account associated with the Amazon Redshift event notification subscription.
     */
    val customerAwsId: kotlin.String? = builder.customerAwsId
    /**
     * A boolean value indicating whether the subscription is enabled; `true` indicates that the subscription is enabled.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * The list of Amazon Redshift event categories specified in the event notification subscription.
     *
     * Values: Configuration, Management, Monitoring, Security, Pending
     */
    val eventCategoriesList: List<String>? = builder.eventCategoriesList
    /**
     * The event severity specified in the Amazon Redshift event notification subscription.
     *
     * Values: ERROR, INFO
     */
    val severity: kotlin.String? = builder.severity
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.
     */
    val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * A list of the sources that publish events to the Amazon Redshift event notification subscription.
     */
    val sourceIdsList: List<String>? = builder.sourceIdsList
    /**
     * The source type of the events returned by the Amazon Redshift event notification, such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action.
     */
    val sourceType: kotlin.String? = builder.sourceType
    /**
     * The status of the Amazon Redshift event notification subscription.
     *
     * Constraints:
     * + Can be one of the following: active | no-permission | topic-not-exist
     * + The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.
     */
    val status: kotlin.String? = builder.status
    /**
     * The date and time the Amazon Redshift event notification subscription was created.
     */
    val subscriptionCreationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.subscriptionCreationTime
    /**
     * The list of tags for the event subscription.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.EventSubscription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventSubscription(")
        append("custSubscriptionId=$custSubscriptionId,")
        append("customerAwsId=$customerAwsId,")
        append("enabled=$enabled,")
        append("eventCategoriesList=$eventCategoriesList,")
        append("severity=$severity,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIdsList=$sourceIdsList,")
        append("sourceType=$sourceType,")
        append("status=$status,")
        append("subscriptionCreationTime=$subscriptionCreationTime,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = custSubscriptionId?.hashCode() ?: 0
        result = 31 * result + (customerAwsId?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (eventCategoriesList?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIdsList?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subscriptionCreationTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventSubscription

        if (custSubscriptionId != other.custSubscriptionId) return false
        if (customerAwsId != other.customerAwsId) return false
        if (enabled != other.enabled) return false
        if (eventCategoriesList != other.eventCategoriesList) return false
        if (severity != other.severity) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIdsList != other.sourceIdsList) return false
        if (sourceType != other.sourceType) return false
        if (status != other.status) return false
        if (subscriptionCreationTime != other.subscriptionCreationTime) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.EventSubscription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Amazon Redshift event notification subscription.
         */
        var custSubscriptionId: kotlin.String? = null
        /**
         * The Amazon Web Services account associated with the Amazon Redshift event notification subscription.
         */
        var customerAwsId: kotlin.String? = null
        /**
         * A boolean value indicating whether the subscription is enabled; `true` indicates that the subscription is enabled.
         */
        var enabled: kotlin.Boolean = false
        /**
         * The list of Amazon Redshift event categories specified in the event notification subscription.
         *
         * Values: Configuration, Management, Monitoring, Security, Pending
         */
        var eventCategoriesList: List<String>? = null
        /**
         * The event severity specified in the Amazon Redshift event notification subscription.
         *
         * Values: ERROR, INFO
         */
        var severity: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.
         */
        var snsTopicArn: kotlin.String? = null
        /**
         * A list of the sources that publish events to the Amazon Redshift event notification subscription.
         */
        var sourceIdsList: List<String>? = null
        /**
         * The source type of the events returned by the Amazon Redshift event notification, such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action.
         */
        var sourceType: kotlin.String? = null
        /**
         * The status of the Amazon Redshift event notification subscription.
         *
         * Constraints:
         * + Can be one of the following: active | no-permission | topic-not-exist
         * + The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.
         */
        var status: kotlin.String? = null
        /**
         * The date and time the Amazon Redshift event notification subscription was created.
         */
        var subscriptionCreationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of tags for the event subscription.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.EventSubscription) : this() {
            this.custSubscriptionId = x.custSubscriptionId
            this.customerAwsId = x.customerAwsId
            this.enabled = x.enabled
            this.eventCategoriesList = x.eventCategoriesList
            this.severity = x.severity
            this.snsTopicArn = x.snsTopicArn
            this.sourceIdsList = x.sourceIdsList
            this.sourceType = x.sourceType
            this.status = x.status
            this.subscriptionCreationTime = x.subscriptionCreationTime
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.EventSubscription = EventSubscription(this)
    }
}
