// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class CreateClusterRequest private constructor(builder: Builder) {
    /**
     * Reserved.
     */
    val additionalInfo: kotlin.String? = builder.additionalInfo
    /**
     * If `true`, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
     *
     * When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
     *
     * Default: `true`
     */
    val allowVersionUpgrade: kotlin.Boolean? = builder.allowVersionUpgrade
    /**
     * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.
     * + enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.
     * + disabled - Don't use AQUA.
     * + auto - Amazon Redshift determines whether to use AQUA.
     */
    val aquaConfigurationStatus: aws.sdk.kotlin.services.redshift.model.AquaConfigurationStatus? = builder.aquaConfigurationStatus
    /**
     * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with CreateClusterSnapshot.
     *
     * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
     *
     * Default: `1`
     *
     * Constraints: Must be a value from 0 to 35.
     */
    val automatedSnapshotRetentionPeriod: kotlin.Int? = builder.automatedSnapshotRetentionPeriod
    /**
     * The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.
     *
     * Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.
     *
     * Example: `us-east-2d`
     *
     * Constraint: The specified Availability Zone must be in the same region as the current endpoint.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
     */
    val availabilityZoneRelocation: kotlin.Boolean? = builder.availabilityZoneRelocation
    /**
     * A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.
     *
     * Constraints:
     * + Must contain from 1 to 63 alphanumeric characters or hyphens.
     * + Alphabetic characters must be lowercase.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     * + Must be unique for all clusters within an Amazon Web Services account.
     *
     * Example: `myexamplecluster`
     */
    val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The name of the parameter group to be associated with this cluster.
     *
     * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to [Working with Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
     *
     * Constraints:
     * + Must be 1 to 255 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     */
    val clusterParameterGroupName: kotlin.String? = builder.clusterParameterGroupName
    /**
     * A list of security groups to be associated with this cluster.
     *
     * Default: The default cluster security group for Amazon Redshift.
     */
    val clusterSecurityGroups: List<String>? = builder.clusterSecurityGroups
    /**
     * The name of a cluster subnet group to be associated with this cluster.
     *
     * If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
     */
    val clusterSubnetGroupName: kotlin.String? = builder.clusterSubnetGroupName
    /**
     * The type of the cluster. When cluster type is specified as
     * + `single-node`, the **NumberOfNodes** parameter is not required.
     * + `multi-node`, the **NumberOfNodes** parameter is required.
     *
     * Valid Values: `multi-node` | `single-node`
     *
     * Default: `multi-node`
     */
    val clusterType: kotlin.String? = builder.clusterType
    /**
     * The version of the Amazon Redshift engine software that you want to deploy on the cluster.
     *
     * The version selected runs on all the nodes in the cluster.
     *
     * Constraints: Only version 1.0 is currently available.
     *
     * Example: `1.0`
     */
    val clusterVersion: kotlin.String? = builder.clusterVersion
    /**
     * The name of the first database to be created when the cluster is created.
     *
     * To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to [Create a Database](https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html) in the Amazon Redshift Database Developer Guide.
     *
     * Default: `dev`
     *
     * Constraints:
     * + Must contain 1 to 64 alphanumeric characters.
     * + Must contain only lowercase letters.
     * + Cannot be a word that is reserved by the service. A list of reserved words can be found in [Reserved Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
     */
    val dbName: kotlin.String? = builder.dbName
    /**
     * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
     */
    val defaultIamRoleArn: kotlin.String? = builder.defaultIamRoleArn
    /**
     * The Elastic IP (EIP) address for the cluster.
     *
     * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to [Supported Platforms to Launch Your Cluster](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms) in the Amazon Redshift Cluster Management Guide.
     */
    val elasticIp: kotlin.String? = builder.elasticIp
    /**
     * If `true`, the data in the cluster is encrypted at rest.
     *
     * Default: false
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
     *
     * If this option is `true`, enhanced VPC routing is enabled.
     *
     * Default: false
     */
    val enhancedVpcRouting: kotlin.Boolean? = builder.enhancedVpcRouting
    /**
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
     */
    val hsmClientCertificateIdentifier: kotlin.String? = builder.hsmClientCertificateIdentifier
    /**
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
     */
    val hsmConfigurationIdentifier: kotlin.String? = builder.hsmConfigurationIdentifier
    /**
     * A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format.
     *
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to [Quotas and limits](https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    val iamRoles: List<String>? = builder.iamRoles
    /**
     * The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * A flag that specifies whether to load sample data once the cluster is created.
     */
    val loadSampleData: kotlin.String? = builder.loadSampleData
    /**
     * An optional parameter for the name of the maintenance track for the cluster. If you don't provide a maintenance track name, the cluster is assigned to the `current` track.
     */
    val maintenanceTrackName: kotlin.String? = builder.maintenanceTrackName
    /**
     * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    val manualSnapshotRetentionPeriod: kotlin.Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The password associated with the admin user account for the cluster that is being created.
     *
     * Constraints:
     * + Must be between 8 and 64 characters in length.
     * + Must contain at least one uppercase letter.
     * + Must contain at least one lowercase letter.
     * + Must contain one number.
     * + Can be any printable ASCII character (ASCII code 33-126) except `'` (single quote), `"` (double quote), `\`, `/`, or `@`.
     */
    val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The user name associated with the admin user account for the cluster that is being created.
     *
     * Constraints:
     * + Must be 1 - 128 alphanumeric characters. The user name can't be `PUBLIC`.
     * + First character must be a letter.
     * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
     */
    val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The node type to be provisioned for the cluster. For information about node types, go to [ Working with Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes) in the *Amazon Redshift Cluster Management Guide*.
     *
     * Valid Values: `ds2.xlarge` | `ds2.8xlarge` | `dc1.large` | `dc1.8xlarge` | `dc2.large` | `dc2.8xlarge` | `ra3.xlplus` | `ra3.4xlarge` | `ra3.16xlarge`
     */
    val nodeType: kotlin.String? = builder.nodeType
    /**
     * The number of compute nodes in the cluster. This parameter is required when the **ClusterType** parameter is specified as `multi-node`.
     *
     * For information about determining how many nodes you need, go to [ Working with Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.
     *
     * Default: `1`
     *
     * Constraints: Value must be at least 1 and no more than 100.
     */
    val numberOfNodes: kotlin.Int? = builder.numberOfNodes
    /**
     * The port number on which the cluster accepts incoming connections.
     *
     * The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.
     *
     * Default: `5439`
     *
     * Valid Values: `1150-65535`
     */
    val port: kotlin.Int? = builder.port
    /**
     * The weekly time range (in UTC) during which automated cluster maintenance can occur.
     *
     *  Format: `ddd:hh24:mi-ddd:hh24:mi`
     *
     *  Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see [Maintenance Windows](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows) in Amazon Redshift Cluster Management Guide.
     *
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *
     * Constraints: Minimum 30-minute window.
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * If `true`, the cluster can be accessed from a public network.
     */
    val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * A unique identifier for the snapshot schedule.
     */
    val snapshotScheduleIdentifier: kotlin.String? = builder.snapshotScheduleIdentifier
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     *
     * Default: The default VPC security group is associated with the cluster.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CreateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("additionalInfo=$additionalInfo,")
        append("allowVersionUpgrade=$allowVersionUpgrade,")
        append("aquaConfigurationStatus=$aquaConfigurationStatus,")
        append("automatedSnapshotRetentionPeriod=$automatedSnapshotRetentionPeriod,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneRelocation=$availabilityZoneRelocation,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterParameterGroupName=$clusterParameterGroupName,")
        append("clusterSecurityGroups=$clusterSecurityGroups,")
        append("clusterSubnetGroupName=$clusterSubnetGroupName,")
        append("clusterType=$clusterType,")
        append("clusterVersion=$clusterVersion,")
        append("dbName=$dbName,")
        append("defaultIamRoleArn=$defaultIamRoleArn,")
        append("elasticIp=$elasticIp,")
        append("encrypted=$encrypted,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("hsmClientCertificateIdentifier=$hsmClientCertificateIdentifier,")
        append("hsmConfigurationIdentifier=$hsmConfigurationIdentifier,")
        append("iamRoles=$iamRoles,")
        append("kmsKeyId=$kmsKeyId,")
        append("loadSampleData=$loadSampleData,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUsername=$masterUsername,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("port=$port,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("snapshotScheduleIdentifier=$snapshotScheduleIdentifier,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (allowVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (aquaConfigurationStatus?.hashCode() ?: 0)
        result = 31 * result + (automatedSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneRelocation?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (clusterSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (clusterType?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (defaultIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (elasticIp?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (hsmClientCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (hsmConfigurationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (iamRoles?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (loadSampleData?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (snapshotScheduleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterRequest

        if (additionalInfo != other.additionalInfo) return false
        if (allowVersionUpgrade != other.allowVersionUpgrade) return false
        if (aquaConfigurationStatus != other.aquaConfigurationStatus) return false
        if (automatedSnapshotRetentionPeriod != other.automatedSnapshotRetentionPeriod) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneRelocation != other.availabilityZoneRelocation) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterParameterGroupName != other.clusterParameterGroupName) return false
        if (clusterSecurityGroups != other.clusterSecurityGroups) return false
        if (clusterSubnetGroupName != other.clusterSubnetGroupName) return false
        if (clusterType != other.clusterType) return false
        if (clusterVersion != other.clusterVersion) return false
        if (dbName != other.dbName) return false
        if (defaultIamRoleArn != other.defaultIamRoleArn) return false
        if (elasticIp != other.elasticIp) return false
        if (encrypted != other.encrypted) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (hsmClientCertificateIdentifier != other.hsmClientCertificateIdentifier) return false
        if (hsmConfigurationIdentifier != other.hsmConfigurationIdentifier) return false
        if (iamRoles != other.iamRoles) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (loadSampleData != other.loadSampleData) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUsername != other.masterUsername) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (port != other.port) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (snapshotScheduleIdentifier != other.snapshotScheduleIdentifier) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CreateClusterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Reserved.
         */
        var additionalInfo: kotlin.String? = null
        /**
         * If `true`, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
         *
         * When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
         *
         * Default: `true`
         */
        var allowVersionUpgrade: kotlin.Boolean? = null
        /**
         * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.
         * + enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.
         * + disabled - Don't use AQUA.
         * + auto - Amazon Redshift determines whether to use AQUA.
         */
        var aquaConfigurationStatus: aws.sdk.kotlin.services.redshift.model.AquaConfigurationStatus? = null
        /**
         * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with CreateClusterSnapshot.
         *
         * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
         *
         * Default: `1`
         *
         * Constraints: Must be a value from 0 to 35.
         */
        var automatedSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.
         *
         * Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.
         *
         * Example: `us-east-2d`
         *
         * Constraint: The specified Availability Zone must be in the same region as the current endpoint.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
         */
        var availabilityZoneRelocation: kotlin.Boolean? = null
        /**
         * A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.
         *
         * Constraints:
         * + Must contain from 1 to 63 alphanumeric characters or hyphens.
         * + Alphabetic characters must be lowercase.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         * + Must be unique for all clusters within an Amazon Web Services account.
         *
         * Example: `myexamplecluster`
         */
        var clusterIdentifier: kotlin.String? = null
        /**
         * The name of the parameter group to be associated with this cluster.
         *
         * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to [Working with Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
         *
         * Constraints:
         * + Must be 1 to 255 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         */
        var clusterParameterGroupName: kotlin.String? = null
        /**
         * A list of security groups to be associated with this cluster.
         *
         * Default: The default cluster security group for Amazon Redshift.
         */
        var clusterSecurityGroups: List<String>? = null
        /**
         * The name of a cluster subnet group to be associated with this cluster.
         *
         * If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
         */
        var clusterSubnetGroupName: kotlin.String? = null
        /**
         * The type of the cluster. When cluster type is specified as
         * + `single-node`, the **NumberOfNodes** parameter is not required.
         * + `multi-node`, the **NumberOfNodes** parameter is required.
         *
         * Valid Values: `multi-node` | `single-node`
         *
         * Default: `multi-node`
         */
        var clusterType: kotlin.String? = null
        /**
         * The version of the Amazon Redshift engine software that you want to deploy on the cluster.
         *
         * The version selected runs on all the nodes in the cluster.
         *
         * Constraints: Only version 1.0 is currently available.
         *
         * Example: `1.0`
         */
        var clusterVersion: kotlin.String? = null
        /**
         * The name of the first database to be created when the cluster is created.
         *
         * To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to [Create a Database](https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html) in the Amazon Redshift Database Developer Guide.
         *
         * Default: `dev`
         *
         * Constraints:
         * + Must contain 1 to 64 alphanumeric characters.
         * + Must contain only lowercase letters.
         * + Cannot be a word that is reserved by the service. A list of reserved words can be found in [Reserved Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
         */
        var dbName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
         */
        var defaultIamRoleArn: kotlin.String? = null
        /**
         * The Elastic IP (EIP) address for the cluster.
         *
         * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to [Supported Platforms to Launch Your Cluster](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms) in the Amazon Redshift Cluster Management Guide.
         */
        var elasticIp: kotlin.String? = null
        /**
         * If `true`, the data in the cluster is encrypted at rest.
         *
         * Default: false
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
         *
         * If this option is `true`, enhanced VPC routing is enabled.
         *
         * Default: false
         */
        var enhancedVpcRouting: kotlin.Boolean? = null
        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
         */
        var hsmClientCertificateIdentifier: kotlin.String? = null
        /**
         * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         */
        var hsmConfigurationIdentifier: kotlin.String? = null
        /**
         * A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format.
         *
         * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to [Quotas and limits](https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html) in the *Amazon Redshift Cluster Management Guide*.
         */
        var iamRoles: List<String>? = null
        /**
         * The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * A flag that specifies whether to load sample data once the cluster is created.
         */
        var loadSampleData: kotlin.String? = null
        /**
         * An optional parameter for the name of the maintenance track for the cluster. If you don't provide a maintenance track name, the cluster is assigned to the `current` track.
         */
        var maintenanceTrackName: kotlin.String? = null
        /**
         * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        var manualSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The password associated with the admin user account for the cluster that is being created.
         *
         * Constraints:
         * + Must be between 8 and 64 characters in length.
         * + Must contain at least one uppercase letter.
         * + Must contain at least one lowercase letter.
         * + Must contain one number.
         * + Can be any printable ASCII character (ASCII code 33-126) except `'` (single quote), `"` (double quote), `\`, `/`, or `@`.
         */
        var masterUserPassword: kotlin.String? = null
        /**
         * The user name associated with the admin user account for the cluster that is being created.
         *
         * Constraints:
         * + Must be 1 - 128 alphanumeric characters. The user name can't be `PUBLIC`.
         * + First character must be a letter.
         * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
         */
        var masterUsername: kotlin.String? = null
        /**
         * The node type to be provisioned for the cluster. For information about node types, go to [ Working with Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes) in the *Amazon Redshift Cluster Management Guide*.
         *
         * Valid Values: `ds2.xlarge` | `ds2.8xlarge` | `dc1.large` | `dc1.8xlarge` | `dc2.large` | `dc2.8xlarge` | `ra3.xlplus` | `ra3.4xlarge` | `ra3.16xlarge`
         */
        var nodeType: kotlin.String? = null
        /**
         * The number of compute nodes in the cluster. This parameter is required when the **ClusterType** parameter is specified as `multi-node`.
         *
         * For information about determining how many nodes you need, go to [ Working with Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes) in the *Amazon Redshift Cluster Management Guide*.
         *
         * If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.
         *
         * Default: `1`
         *
         * Constraints: Value must be at least 1 and no more than 100.
         */
        var numberOfNodes: kotlin.Int? = null
        /**
         * The port number on which the cluster accepts incoming connections.
         *
         * The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.
         *
         * Default: `5439`
         *
         * Valid Values: `1150-65535`
         */
        var port: kotlin.Int? = null
        /**
         * The weekly time range (in UTC) during which automated cluster maintenance can occur.
         *
         *  Format: `ddd:hh24:mi-ddd:hh24:mi`
         *
         *  Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see [Maintenance Windows](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows) in Amazon Redshift Cluster Management Guide.
         *
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *
         * Constraints: Minimum 30-minute window.
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * If `true`, the cluster can be accessed from a public network.
         */
        var publiclyAccessible: kotlin.Boolean? = null
        /**
         * A unique identifier for the snapshot schedule.
         */
        var snapshotScheduleIdentifier: kotlin.String? = null
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>? = null
        /**
         * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         *
         * Default: The default VPC security group is associated with the cluster.
         */
        var vpcSecurityGroupIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CreateClusterRequest) : this() {
            this.additionalInfo = x.additionalInfo
            this.allowVersionUpgrade = x.allowVersionUpgrade
            this.aquaConfigurationStatus = x.aquaConfigurationStatus
            this.automatedSnapshotRetentionPeriod = x.automatedSnapshotRetentionPeriod
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneRelocation = x.availabilityZoneRelocation
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterParameterGroupName = x.clusterParameterGroupName
            this.clusterSecurityGroups = x.clusterSecurityGroups
            this.clusterSubnetGroupName = x.clusterSubnetGroupName
            this.clusterType = x.clusterType
            this.clusterVersion = x.clusterVersion
            this.dbName = x.dbName
            this.defaultIamRoleArn = x.defaultIamRoleArn
            this.elasticIp = x.elasticIp
            this.encrypted = x.encrypted
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.hsmClientCertificateIdentifier = x.hsmClientCertificateIdentifier
            this.hsmConfigurationIdentifier = x.hsmConfigurationIdentifier
            this.iamRoles = x.iamRoles
            this.kmsKeyId = x.kmsKeyId
            this.loadSampleData = x.loadSampleData
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.masterUserPassword = x.masterUserPassword
            this.masterUsername = x.masterUsername
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.port = x.port
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.snapshotScheduleIdentifier = x.snapshotScheduleIdentifier
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CreateClusterRequest = CreateClusterRequest(this)
    }
}
