// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class CreateUsageLimitRequest private constructor(builder: Builder) {
    /**
     * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
     */
    val amount: kotlin.Long = builder.amount
    /**
     * The action that Amazon Redshift takes when the limit is reached. The default is log. For more information about this parameter, see UsageLimit.
     */
    val breachAction: aws.sdk.kotlin.services.redshift.model.UsageLimitBreachAction? = builder.breachAction
    /**
     * The identifier of the cluster that you want to limit usage.
     */
    val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The Amazon Redshift feature that you want to limit.
     */
    val featureType: aws.sdk.kotlin.services.redshift.model.UsageLimitFeatureType? = builder.featureType
    /**
     * The type of limit. Depending on the feature type, this can be based on a time duration or data size. If `FeatureType` is `spectrum`, then `LimitType` must be `data-scanned`. If `FeatureType` is `concurrency-scaling`, then `LimitType` must be `time`. If `FeatureType` is `cross-region-datasharing`, then `LimitType` must be `data-scanned`.
     */
    val limitType: aws.sdk.kotlin.services.redshift.model.UsageLimitLimitType? = builder.limitType
    /**
     * The time period that the amount applies to. A `weekly` period begins on Sunday. The default is `monthly`.
     */
    val period: aws.sdk.kotlin.services.redshift.model.UsageLimitPeriod? = builder.period
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CreateUsageLimitRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUsageLimitRequest(")
        append("amount=$amount,")
        append("breachAction=$breachAction,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("featureType=$featureType,")
        append("limitType=$limitType,")
        append("period=$period,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amount.hashCode()
        result = 31 * result + (breachAction?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (featureType?.hashCode() ?: 0)
        result = 31 * result + (limitType?.hashCode() ?: 0)
        result = 31 * result + (period?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUsageLimitRequest

        if (amount != other.amount) return false
        if (breachAction != other.breachAction) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (featureType != other.featureType) return false
        if (limitType != other.limitType) return false
        if (period != other.period) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CreateUsageLimitRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
         */
        var amount: kotlin.Long = 0L
        /**
         * The action that Amazon Redshift takes when the limit is reached. The default is log. For more information about this parameter, see UsageLimit.
         */
        var breachAction: aws.sdk.kotlin.services.redshift.model.UsageLimitBreachAction? = null
        /**
         * The identifier of the cluster that you want to limit usage.
         */
        var clusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Redshift feature that you want to limit.
         */
        var featureType: aws.sdk.kotlin.services.redshift.model.UsageLimitFeatureType? = null
        /**
         * The type of limit. Depending on the feature type, this can be based on a time duration or data size. If `FeatureType` is `spectrum`, then `LimitType` must be `data-scanned`. If `FeatureType` is `concurrency-scaling`, then `LimitType` must be `time`. If `FeatureType` is `cross-region-datasharing`, then `LimitType` must be `data-scanned`.
         */
        var limitType: aws.sdk.kotlin.services.redshift.model.UsageLimitLimitType? = null
        /**
         * The time period that the amount applies to. A `weekly` period begins on Sunday. The default is `monthly`.
         */
        var period: aws.sdk.kotlin.services.redshift.model.UsageLimitPeriod? = null
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CreateUsageLimitRequest) : this() {
            this.amount = x.amount
            this.breachAction = x.breachAction
            this.clusterIdentifier = x.clusterIdentifier
            this.featureType = x.featureType
            this.limitType = x.limitType
            this.period = x.period
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CreateUsageLimitRequest = CreateUsageLimitRequest(this)
    }
}
