// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the status of a cluster while it is in the process of resizing with an incremental resize.
 */
class DataTransferProgress private constructor(builder: Builder) {
    /**
     * Describes the data transfer rate in MB's per second.
     */
    val currentRateInMegaBytesPerSecond: kotlin.Double? = builder.currentRateInMegaBytesPerSecond
    /**
     * Describes the total amount of data that has been transfered in MB's.
     */
    val dataTransferredInMegaBytes: kotlin.Long = builder.dataTransferredInMegaBytes
    /**
     * Describes the number of seconds that have elapsed during the data transfer.
     */
    val elapsedTimeInSeconds: kotlin.Long? = builder.elapsedTimeInSeconds
    /**
     * Describes the estimated number of seconds remaining to complete the transfer.
     */
    val estimatedTimeToCompletionInSeconds: kotlin.Long? = builder.estimatedTimeToCompletionInSeconds
    /**
     * Describes the status of the cluster. While the transfer is in progress the status is `transferringdata`.
     */
    val status: kotlin.String? = builder.status
    /**
     * Describes the total amount of data to be transfered in megabytes.
     */
    val totalDataInMegaBytes: kotlin.Long = builder.totalDataInMegaBytes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DataTransferProgress = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataTransferProgress(")
        append("currentRateInMegaBytesPerSecond=$currentRateInMegaBytesPerSecond,")
        append("dataTransferredInMegaBytes=$dataTransferredInMegaBytes,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("estimatedTimeToCompletionInSeconds=$estimatedTimeToCompletionInSeconds,")
        append("status=$status,")
        append("totalDataInMegaBytes=$totalDataInMegaBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentRateInMegaBytesPerSecond?.hashCode() ?: 0
        result = 31 * result + (dataTransferredInMegaBytes.hashCode())
        result = 31 * result + (elapsedTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (estimatedTimeToCompletionInSeconds?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalDataInMegaBytes.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataTransferProgress

        if (currentRateInMegaBytesPerSecond != other.currentRateInMegaBytesPerSecond) return false
        if (dataTransferredInMegaBytes != other.dataTransferredInMegaBytes) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (estimatedTimeToCompletionInSeconds != other.estimatedTimeToCompletionInSeconds) return false
        if (status != other.status) return false
        if (totalDataInMegaBytes != other.totalDataInMegaBytes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DataTransferProgress = Builder(this).apply(block).build()

    class Builder {
        /**
         * Describes the data transfer rate in MB's per second.
         */
        var currentRateInMegaBytesPerSecond: kotlin.Double? = null
        /**
         * Describes the total amount of data that has been transfered in MB's.
         */
        var dataTransferredInMegaBytes: kotlin.Long = 0L
        /**
         * Describes the number of seconds that have elapsed during the data transfer.
         */
        var elapsedTimeInSeconds: kotlin.Long? = null
        /**
         * Describes the estimated number of seconds remaining to complete the transfer.
         */
        var estimatedTimeToCompletionInSeconds: kotlin.Long? = null
        /**
         * Describes the status of the cluster. While the transfer is in progress the status is `transferringdata`.
         */
        var status: kotlin.String? = null
        /**
         * Describes the total amount of data to be transfered in megabytes.
         */
        var totalDataInMegaBytes: kotlin.Long = 0L

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DataTransferProgress) : this() {
            this.currentRateInMegaBytesPerSecond = x.currentRateInMegaBytesPerSecond
            this.dataTransferredInMegaBytes = x.dataTransferredInMegaBytes
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.estimatedTimeToCompletionInSeconds = x.estimatedTimeToCompletionInSeconds
            this.status = x.status
            this.totalDataInMegaBytes = x.totalDataInMegaBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DataTransferProgress = DataTransferProgress(this)
    }
}
