// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class DescribeTagsRequest private constructor(builder: Builder) {
    /**
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the `marker` parameter and retrying the command. If the `marker` field is empty, all response records have been retrieved for the request.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned `marker` value.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For example, `arn:aws:redshift:us-east-2:123456789:cluster:t1`.
     */
    val resourceName: kotlin.String? = builder.resourceName
    /**
     * The type of resource with which you want to view tags. Valid resource types are:
     * + Cluster
     * + CIDR/IP
     * + EC2 security group
     * + Snapshot
     * + Cluster security group
     * + Subnet group
     * + HSM connection
     * + HSM certificate
     * + Parameter group
     * + Snapshot copy grant
     *
     * For more information about Amazon Redshift resource types and constructing ARNs, go to [Specifying Policy Elements: Actions, Effects, Resources, and Principals](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions) in the Amazon Redshift Cluster Management Guide.
     */
    val resourceType: kotlin.String? = builder.resourceType
    /**
     * A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.
     */
    val tagKeys: List<String>? = builder.tagKeys
    /**
     * A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.
     */
    val tagValues: List<String>? = builder.tagValues

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DescribeTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTagsRequest(")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTagsRequest

        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DescribeTagsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the `marker` parameter and retrying the command. If the `marker` field is empty, all response records have been retrieved for the request.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned `marker` value.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For example, `arn:aws:redshift:us-east-2:123456789:cluster:t1`.
         */
        var resourceName: kotlin.String? = null
        /**
         * The type of resource with which you want to view tags. Valid resource types are:
         * + Cluster
         * + CIDR/IP
         * + EC2 security group
         * + Snapshot
         * + Cluster security group
         * + Subnet group
         * + HSM connection
         * + HSM certificate
         * + Parameter group
         * + Snapshot copy grant
         *
         * For more information about Amazon Redshift resource types and constructing ARNs, go to [Specifying Policy Elements: Actions, Effects, Resources, and Principals](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions) in the Amazon Redshift Cluster Management Guide.
         */
        var resourceType: kotlin.String? = null
        /**
         * A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.
         */
        var tagKeys: List<String>? = null
        /**
         * A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.
         */
        var tagValues: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DescribeTagsRequest) : this() {
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DescribeTagsRequest = DescribeTagsRequest(this)
    }
}
