// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across Amazon Web Services accounts.
 */
class EndpointAuthorization private constructor(builder: Builder) {
    /**
     * Indicates whether all VPCs in the grantee account are allowed access to the cluster.
     */
    val allowedAllVpCs: kotlin.Boolean = builder.allowedAllVpCs
    /**
     * The VPCs allowed access to the cluster.
     */
    val allowedVpCs: List<String>? = builder.allowedVpCs
    /**
     * The time (UTC) when the authorization was created.
     */
    val authorizeTime: aws.smithy.kotlin.runtime.time.Instant? = builder.authorizeTime
    /**
     * The cluster identifier.
     */
    val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The status of the cluster.
     */
    val clusterStatus: kotlin.String? = builder.clusterStatus
    /**
     * The number of Redshift-managed VPC endpoints created for the authorization.
     */
    val endpointCount: kotlin.Int = builder.endpointCount
    /**
     * The Amazon Web Services account ID of the grantee of the cluster.
     */
    val grantee: kotlin.String? = builder.grantee
    /**
     * The Amazon Web Services account ID of the cluster owner.
     */
    val grantor: kotlin.String? = builder.grantor
    /**
     * The status of the authorization action.
     */
    val status: aws.sdk.kotlin.services.redshift.model.AuthorizationStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.EndpointAuthorization = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointAuthorization(")
        append("allowedAllVpCs=$allowedAllVpCs,")
        append("allowedVpCs=$allowedVpCs,")
        append("authorizeTime=$authorizeTime,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterStatus=$clusterStatus,")
        append("endpointCount=$endpointCount,")
        append("grantee=$grantee,")
        append("grantor=$grantor,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedAllVpCs.hashCode()
        result = 31 * result + (allowedVpCs?.hashCode() ?: 0)
        result = 31 * result + (authorizeTime?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterStatus?.hashCode() ?: 0)
        result = 31 * result + (endpointCount)
        result = 31 * result + (grantee?.hashCode() ?: 0)
        result = 31 * result + (grantor?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointAuthorization

        if (allowedAllVpCs != other.allowedAllVpCs) return false
        if (allowedVpCs != other.allowedVpCs) return false
        if (authorizeTime != other.authorizeTime) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterStatus != other.clusterStatus) return false
        if (endpointCount != other.endpointCount) return false
        if (grantee != other.grantee) return false
        if (grantor != other.grantor) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.EndpointAuthorization = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether all VPCs in the grantee account are allowed access to the cluster.
         */
        var allowedAllVpCs: kotlin.Boolean = false
        /**
         * The VPCs allowed access to the cluster.
         */
        var allowedVpCs: List<String>? = null
        /**
         * The time (UTC) when the authorization was created.
         */
        var authorizeTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The cluster identifier.
         */
        var clusterIdentifier: kotlin.String? = null
        /**
         * The status of the cluster.
         */
        var clusterStatus: kotlin.String? = null
        /**
         * The number of Redshift-managed VPC endpoints created for the authorization.
         */
        var endpointCount: kotlin.Int = 0
        /**
         * The Amazon Web Services account ID of the grantee of the cluster.
         */
        var grantee: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the cluster owner.
         */
        var grantor: kotlin.String? = null
        /**
         * The status of the authorization action.
         */
        var status: aws.sdk.kotlin.services.redshift.model.AuthorizationStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.EndpointAuthorization) : this() {
            this.allowedAllVpCs = x.allowedAllVpCs
            this.allowedVpCs = x.allowedVpCs
            this.authorizeTime = x.authorizeTime
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterStatus = x.clusterStatus
            this.endpointCount = x.endpointCount
            this.grantee = x.grantee
            this.grantor = x.grantor
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.EndpointAuthorization = EndpointAuthorization(this)
    }
}
