// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Defines a maintenance track that determines which Amazon Redshift version to apply during a maintenance window. If the value for `MaintenanceTrack` is `current`, the cluster is updated to the most recently certified maintenance release. If the value is `trailing`, the cluster is updated to the previously certified maintenance release.
 */
class MaintenanceTrack private constructor(builder: Builder) {
    /**
     * The version number for the cluster release.
     */
    val databaseVersion: kotlin.String? = builder.databaseVersion
    /**
     * The name of the maintenance track. Possible values are `current` and `trailing`.
     */
    val maintenanceTrackName: kotlin.String? = builder.maintenanceTrackName
    /**
     * An array of UpdateTarget objects to update with the maintenance track.
     */
    val updateTargets: List<UpdateTarget>? = builder.updateTargets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.MaintenanceTrack = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceTrack(")
        append("databaseVersion=$databaseVersion,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("updateTargets=$updateTargets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseVersion?.hashCode() ?: 0
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (updateTargets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaintenanceTrack

        if (databaseVersion != other.databaseVersion) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (updateTargets != other.updateTargets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.MaintenanceTrack = Builder(this).apply(block).build()

    class Builder {
        /**
         * The version number for the cluster release.
         */
        var databaseVersion: kotlin.String? = null
        /**
         * The name of the maintenance track. Possible values are `current` and `trailing`.
         */
        var maintenanceTrackName: kotlin.String? = null
        /**
         * An array of UpdateTarget objects to update with the maintenance track.
         */
        var updateTargets: List<UpdateTarget>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.MaintenanceTrack) : this() {
            this.databaseVersion = x.databaseVersion
            this.maintenanceTrackName = x.maintenanceTrackName
            this.updateTargets = x.updateTargets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.MaintenanceTrack = MaintenanceTrack(this)
    }
}
