// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a scheduled action. You can use a scheduled action to trigger some Amazon Redshift API operations on a schedule. For information about which API operations can be scheduled, see ScheduledActionType.
 */
class ModifyScheduledActionResponse private constructor(builder: Builder) {
    /**
     * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see [Using Identity-Based Policies for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    val iamRole: kotlin.String? = builder.iamRole
    /**
     * List of times when the scheduled action will run.
     */
    val nextInvocations: List<Instant>? = builder.nextInvocations
    /**
     * The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.
     *
     * Format of at expressions is "`at(yyyy-mm-ddThh:mm:ss)`". For example, "`at(2016-03-04T17:27:00)`".
     *
     * Format of cron expressions is "`cron(Minutes Hours Day-of-month Month Day-of-week Year)`". For example, "`cron(0 10 ? * MON *)`". For more information, see [Cron Expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions) in the *Amazon CloudWatch Events User Guide*.
     */
    val schedule: kotlin.String? = builder.schedule
    /**
     * The description of the scheduled action.
     */
    val scheduledActionDescription: kotlin.String? = builder.scheduledActionDescription
    /**
     * The name of the scheduled action.
     */
    val scheduledActionName: kotlin.String? = builder.scheduledActionName
    /**
     * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the scheduled action. For example, `DISABLED`.
     */
    val state: aws.sdk.kotlin.services.redshift.model.ScheduledActionState? = builder.state
    /**
     * A JSON format string of the Amazon Redshift API operation with input parameters.
     *
     * "`{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}`".
     */
    val targetAction: aws.sdk.kotlin.services.redshift.model.ScheduledActionType? = builder.targetAction

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ModifyScheduledActionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyScheduledActionResponse(")
        append("endTime=$endTime,")
        append("iamRole=$iamRole,")
        append("nextInvocations=$nextInvocations,")
        append("schedule=$schedule,")
        append("scheduledActionDescription=$scheduledActionDescription,")
        append("scheduledActionName=$scheduledActionName,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("targetAction=$targetAction)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (nextInvocations?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionDescription?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (targetAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyScheduledActionResponse

        if (endTime != other.endTime) return false
        if (iamRole != other.iamRole) return false
        if (nextInvocations != other.nextInvocations) return false
        if (schedule != other.schedule) return false
        if (scheduledActionDescription != other.scheduledActionDescription) return false
        if (scheduledActionName != other.scheduledActionName) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (targetAction != other.targetAction) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ModifyScheduledActionResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see [Using Identity-Based Policies for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the *Amazon Redshift Cluster Management Guide*.
         */
        var iamRole: kotlin.String? = null
        /**
         * List of times when the scheduled action will run.
         */
        var nextInvocations: List<Instant>? = null
        /**
         * The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.
         *
         * Format of at expressions is "`at(yyyy-mm-ddThh:mm:ss)`". For example, "`at(2016-03-04T17:27:00)`".
         *
         * Format of cron expressions is "`cron(Minutes Hours Day-of-month Month Day-of-week Year)`". For example, "`cron(0 10 ? * MON *)`". For more information, see [Cron Expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions) in the *Amazon CloudWatch Events User Guide*.
         */
        var schedule: kotlin.String? = null
        /**
         * The description of the scheduled action.
         */
        var scheduledActionDescription: kotlin.String? = null
        /**
         * The name of the scheduled action.
         */
        var scheduledActionName: kotlin.String? = null
        /**
         * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the scheduled action. For example, `DISABLED`.
         */
        var state: aws.sdk.kotlin.services.redshift.model.ScheduledActionState? = null
        /**
         * A JSON format string of the Amazon Redshift API operation with input parameters.
         *
         * "`{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}`".
         */
        var targetAction: aws.sdk.kotlin.services.redshift.model.ScheduledActionType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ModifyScheduledActionResponse) : this() {
            this.endTime = x.endTime
            this.iamRole = x.iamRole
            this.nextInvocations = x.nextInvocations
            this.schedule = x.schedule
            this.scheduledActionDescription = x.scheduledActionDescription
            this.scheduledActionName = x.scheduledActionName
            this.startTime = x.startTime
            this.state = x.state
            this.targetAction = x.targetAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ModifyScheduledActionResponse = ModifyScheduledActionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.ScheduledActionType] inside the given [block]
         */
        fun targetAction(block: aws.sdk.kotlin.services.redshift.model.ScheduledActionType.Builder.() -> kotlin.Unit) {
            this.targetAction = aws.sdk.kotlin.services.redshift.model.ScheduledActionType.invoke(block)
        }
    }
}
