// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a snapshot.
 */
class Snapshot private constructor(builder: Builder) {
    /**
     * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns `null` if no accounts are authorized. Visible only to the snapshot owner.
     */
    val accountsWithRestoreAccess: List<AccountWithRestoreAccess>? = builder.accountsWithRestoreAccess
    /**
     * The size of the incremental backup.
     */
    val actualIncrementalBackupSizeInMegaBytes: kotlin.Double = builder.actualIncrementalBackupSizeInMegaBytes
    /**
     * The Availability Zone in which the cluster was created.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The number of megabytes that have been transferred to the snapshot backup.
     */
    val backupProgressInMegaBytes: kotlin.Double = builder.backupProgressInMegaBytes
    /**
     * The time (UTC) when the cluster was originally created.
     */
    val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * The identifier of the cluster for which the snapshot was taken.
     */
    val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The version ID of the Amazon Redshift engine that is running on the cluster.
     */
    val clusterVersion: kotlin.String? = builder.clusterVersion
    /**
     * The number of megabytes per second being transferred to the snapshot backup. Returns `0` for a completed backup.
     */
    val currentBackupRateInMegaBytesPerSecond: kotlin.Double = builder.currentBackupRateInMegaBytesPerSecond
    /**
     * The name of the database that was created when the cluster was created.
     */
    val dbName: kotlin.String? = builder.dbName
    /**
     * The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.
     */
    val elapsedTimeInSeconds: kotlin.Long = builder.elapsedTimeInSeconds
    /**
     * If `true`, the data in the snapshot is encrypted at rest.
     */
    val encrypted: kotlin.Boolean = builder.encrypted
    /**
     * A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. `true` indicates that the data is encrypted using HSM keys.
     */
    val encryptedWithHsm: kotlin.Boolean = builder.encryptedWithHsm
    /**
     * The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
     */
    val engineFullVersion: kotlin.String? = builder.engineFullVersion
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
     *
     * If this option is `true`, enhanced VPC routing is enabled.
     *
     * Default: false
     */
    val enhancedVpcRouting: kotlin.Boolean = builder.enhancedVpcRouting
    /**
     * The estimate of the time remaining before the snapshot backup will complete. Returns `0` for a completed backup.
     */
    val estimatedSecondsToCompletion: kotlin.Long = builder.estimatedSecondsToCompletion
    /**
     * The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the maintenance track for the snapshot.
     */
    val maintenanceTrackName: kotlin.String? = builder.maintenanceTrackName
    /**
     * The number of days until a manual snapshot will pass its retention period.
     */
    val manualSnapshotRemainingDays: kotlin.Int? = builder.manualSnapshotRemainingDays
    /**
     * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    val manualSnapshotRetentionPeriod: kotlin.Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The admin user name for the cluster.
     */
    val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The node type of the nodes in the cluster.
     */
    val nodeType: kotlin.String? = builder.nodeType
    /**
     * The number of nodes in the cluster.
     */
    val numberOfNodes: kotlin.Int = builder.numberOfNodes
    /**
     * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.
     */
    val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The port that the cluster is listening on.
     */
    val port: kotlin.Int = builder.port
    /**
     * The list of node types that this cluster snapshot is able to restore into.
     */
    val restorableNodeTypes: List<String>? = builder.restorableNodeTypes
    /**
     * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.
     */
    val snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotCreateTime
    /**
     * The snapshot identifier that is provided in the request.
     */
    val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * A timestamp representing the start of the retention period for the snapshot.
     */
    val snapshotRetentionStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotRetentionStartTime
    /**
     * The snapshot type. Snapshots created using CreateClusterSnapshot and CopyClusterSnapshot are of type "manual".
     */
    val snapshotType: kotlin.String? = builder.snapshotType
    /**
     * The source region from which the snapshot was copied.
     */
    val sourceRegion: kotlin.String? = builder.sourceRegion
    /**
     * The snapshot status. The value of the status depends on the API operation used:
     * + CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
     * + DescribeClusterSnapshots returns status as "creating", "available", "final snapshot", or "failed".
     * + DeleteClusterSnapshot returns status as "deleted".
     */
    val status: kotlin.String? = builder.status
    /**
     * The list of tags for the cluster snapshot.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The size of the complete set of backup data that would be used to restore the cluster.
     */
    val totalBackupSizeInMegaBytes: kotlin.Double = builder.totalBackupSizeInMegaBytes
    /**
     * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.Snapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Snapshot(")
        append("accountsWithRestoreAccess=$accountsWithRestoreAccess,")
        append("actualIncrementalBackupSizeInMegaBytes=$actualIncrementalBackupSizeInMegaBytes,")
        append("availabilityZone=$availabilityZone,")
        append("backupProgressInMegaBytes=$backupProgressInMegaBytes,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterVersion=$clusterVersion,")
        append("currentBackupRateInMegaBytesPerSecond=$currentBackupRateInMegaBytesPerSecond,")
        append("dbName=$dbName,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("encrypted=$encrypted,")
        append("encryptedWithHsm=$encryptedWithHsm,")
        append("engineFullVersion=$engineFullVersion,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("estimatedSecondsToCompletion=$estimatedSecondsToCompletion,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manualSnapshotRemainingDays=$manualSnapshotRemainingDays,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("masterUsername=$masterUsername,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("ownerAccount=$ownerAccount,")
        append("port=$port,")
        append("restorableNodeTypes=$restorableNodeTypes,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("snapshotRetentionStartTime=$snapshotRetentionStartTime,")
        append("snapshotType=$snapshotType,")
        append("sourceRegion=$sourceRegion,")
        append("status=$status,")
        append("tags=$tags,")
        append("totalBackupSizeInMegaBytes=$totalBackupSizeInMegaBytes,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountsWithRestoreAccess?.hashCode() ?: 0
        result = 31 * result + (actualIncrementalBackupSizeInMegaBytes.hashCode())
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupProgressInMegaBytes.hashCode())
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (currentBackupRateInMegaBytesPerSecond.hashCode())
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (elapsedTimeInSeconds.hashCode())
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (encryptedWithHsm.hashCode())
        result = 31 * result + (engineFullVersion?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting.hashCode())
        result = 31 * result + (estimatedSecondsToCompletion.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRemainingDays ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (port)
        result = 31 * result + (restorableNodeTypes?.hashCode() ?: 0)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionStartTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalBackupSizeInMegaBytes.hashCode())
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Snapshot

        if (accountsWithRestoreAccess != other.accountsWithRestoreAccess) return false
        if (actualIncrementalBackupSizeInMegaBytes != other.actualIncrementalBackupSizeInMegaBytes) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupProgressInMegaBytes != other.backupProgressInMegaBytes) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterVersion != other.clusterVersion) return false
        if (currentBackupRateInMegaBytesPerSecond != other.currentBackupRateInMegaBytesPerSecond) return false
        if (dbName != other.dbName) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (encrypted != other.encrypted) return false
        if (encryptedWithHsm != other.encryptedWithHsm) return false
        if (engineFullVersion != other.engineFullVersion) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (estimatedSecondsToCompletion != other.estimatedSecondsToCompletion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manualSnapshotRemainingDays != other.manualSnapshotRemainingDays) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (masterUsername != other.masterUsername) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (ownerAccount != other.ownerAccount) return false
        if (port != other.port) return false
        if (restorableNodeTypes != other.restorableNodeTypes) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (snapshotRetentionStartTime != other.snapshotRetentionStartTime) return false
        if (snapshotType != other.snapshotType) return false
        if (sourceRegion != other.sourceRegion) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (totalBackupSizeInMegaBytes != other.totalBackupSizeInMegaBytes) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.Snapshot = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns `null` if no accounts are authorized. Visible only to the snapshot owner.
         */
        var accountsWithRestoreAccess: List<AccountWithRestoreAccess>? = null
        /**
         * The size of the incremental backup.
         */
        var actualIncrementalBackupSizeInMegaBytes: kotlin.Double = 0.0
        /**
         * The Availability Zone in which the cluster was created.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The number of megabytes that have been transferred to the snapshot backup.
         */
        var backupProgressInMegaBytes: kotlin.Double = 0.0
        /**
         * The time (UTC) when the cluster was originally created.
         */
        var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the cluster for which the snapshot was taken.
         */
        var clusterIdentifier: kotlin.String? = null
        /**
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         */
        var clusterVersion: kotlin.String? = null
        /**
         * The number of megabytes per second being transferred to the snapshot backup. Returns `0` for a completed backup.
         */
        var currentBackupRateInMegaBytesPerSecond: kotlin.Double = 0.0
        /**
         * The name of the database that was created when the cluster was created.
         */
        var dbName: kotlin.String? = null
        /**
         * The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.
         */
        var elapsedTimeInSeconds: kotlin.Long = 0L
        /**
         * If `true`, the data in the snapshot is encrypted at rest.
         */
        var encrypted: kotlin.Boolean = false
        /**
         * A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. `true` indicates that the data is encrypted using HSM keys.
         */
        var encryptedWithHsm: kotlin.Boolean = false
        /**
         * The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
         */
        var engineFullVersion: kotlin.String? = null
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
         *
         * If this option is `true`, enhanced VPC routing is enabled.
         *
         * Default: false
         */
        var enhancedVpcRouting: kotlin.Boolean = false
        /**
         * The estimate of the time remaining before the snapshot backup will complete. Returns `0` for a completed backup.
         */
        var estimatedSecondsToCompletion: kotlin.Long = 0L
        /**
         * The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The name of the maintenance track for the snapshot.
         */
        var maintenanceTrackName: kotlin.String? = null
        /**
         * The number of days until a manual snapshot will pass its retention period.
         */
        var manualSnapshotRemainingDays: kotlin.Int? = null
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        var manualSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The admin user name for the cluster.
         */
        var masterUsername: kotlin.String? = null
        /**
         * The node type of the nodes in the cluster.
         */
        var nodeType: kotlin.String? = null
        /**
         * The number of nodes in the cluster.
         */
        var numberOfNodes: kotlin.Int = 0
        /**
         * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.
         */
        var ownerAccount: kotlin.String? = null
        /**
         * The port that the cluster is listening on.
         */
        var port: kotlin.Int = 0
        /**
         * The list of node types that this cluster snapshot is able to restore into.
         */
        var restorableNodeTypes: List<String>? = null
        /**
         * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.
         */
        var snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The snapshot identifier that is provided in the request.
         */
        var snapshotIdentifier: kotlin.String? = null
        /**
         * A timestamp representing the start of the retention period for the snapshot.
         */
        var snapshotRetentionStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The snapshot type. Snapshots created using CreateClusterSnapshot and CopyClusterSnapshot are of type "manual".
         */
        var snapshotType: kotlin.String? = null
        /**
         * The source region from which the snapshot was copied.
         */
        var sourceRegion: kotlin.String? = null
        /**
         * The snapshot status. The value of the status depends on the API operation used:
         * + CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
         * + DescribeClusterSnapshots returns status as "creating", "available", "final snapshot", or "failed".
         * + DeleteClusterSnapshot returns status as "deleted".
         */
        var status: kotlin.String? = null
        /**
         * The list of tags for the cluster snapshot.
         */
        var tags: List<Tag>? = null
        /**
         * The size of the complete set of backup data that would be used to restore the cluster.
         */
        var totalBackupSizeInMegaBytes: kotlin.Double = 0.0
        /**
         * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.Snapshot) : this() {
            this.accountsWithRestoreAccess = x.accountsWithRestoreAccess
            this.actualIncrementalBackupSizeInMegaBytes = x.actualIncrementalBackupSizeInMegaBytes
            this.availabilityZone = x.availabilityZone
            this.backupProgressInMegaBytes = x.backupProgressInMegaBytes
            this.clusterCreateTime = x.clusterCreateTime
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterVersion = x.clusterVersion
            this.currentBackupRateInMegaBytesPerSecond = x.currentBackupRateInMegaBytesPerSecond
            this.dbName = x.dbName
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.encrypted = x.encrypted
            this.encryptedWithHsm = x.encryptedWithHsm
            this.engineFullVersion = x.engineFullVersion
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.estimatedSecondsToCompletion = x.estimatedSecondsToCompletion
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manualSnapshotRemainingDays = x.manualSnapshotRemainingDays
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.masterUsername = x.masterUsername
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.ownerAccount = x.ownerAccount
            this.port = x.port
            this.restorableNodeTypes = x.restorableNodeTypes
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotIdentifier = x.snapshotIdentifier
            this.snapshotRetentionStartTime = x.snapshotRetentionStartTime
            this.snapshotType = x.snapshotType
            this.sourceRegion = x.sourceRegion
            this.status = x.status
            this.tags = x.tags
            this.totalBackupSizeInMegaBytes = x.totalBackupSizeInMegaBytes
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.Snapshot = Snapshot(this)
    }
}
