// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * A tag and its associated resource.
 */
class TaggedResource private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) with which the tag is associated, for example: `arn:aws:redshift:us-east-2:123456789:cluster:t1`.
     */
    val resourceName: kotlin.String? = builder.resourceName
    /**
     * The type of resource with which the tag is associated. Valid resource types are:
     * + Cluster
     * + CIDR/IP
     * + EC2 security group
     * + Snapshot
     * + Cluster security group
     * + Subnet group
     * + HSM connection
     * + HSM certificate
     * + Parameter group
     *
     * For more information about Amazon Redshift resource types and constructing ARNs, go to [Constructing an Amazon Redshift Amazon Resource Name (ARN)](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions) in the Amazon Redshift Cluster Management Guide.
     */
    val resourceType: kotlin.String? = builder.resourceType
    /**
     * The tag for the resource.
     */
    val tag: aws.sdk.kotlin.services.redshift.model.Tag? = builder.tag

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.TaggedResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaggedResource(")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType,")
        append("tag=$tag)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceName?.hashCode() ?: 0
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tag?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaggedResource

        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false
        if (tag != other.tag) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.TaggedResource = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) with which the tag is associated, for example: `arn:aws:redshift:us-east-2:123456789:cluster:t1`.
         */
        var resourceName: kotlin.String? = null
        /**
         * The type of resource with which the tag is associated. Valid resource types are:
         * + Cluster
         * + CIDR/IP
         * + EC2 security group
         * + Snapshot
         * + Cluster security group
         * + Subnet group
         * + HSM connection
         * + HSM certificate
         * + Parameter group
         *
         * For more information about Amazon Redshift resource types and constructing ARNs, go to [Constructing an Amazon Redshift Amazon Resource Name (ARN)](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions) in the Amazon Redshift Cluster Management Guide.
         */
        var resourceType: kotlin.String? = null
        /**
         * The tag for the resource.
         */
        var tag: aws.sdk.kotlin.services.redshift.model.Tag? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.TaggedResource) : this() {
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
            this.tag = x.tag
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.TaggedResource = TaggedResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.Tag] inside the given [block]
         */
        fun tag(block: aws.sdk.kotlin.services.redshift.model.Tag.Builder.() -> kotlin.Unit) {
            this.tag = aws.sdk.kotlin.services.redshift.model.Tag.invoke(block)
        }
    }
}
