// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.waiters

import aws.sdk.kotlin.services.redshift.RedshiftClient
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClustersRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClustersResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


suspend fun RedshiftClient.waitUntilClusterAvailable(request: DescribeClustersRequest): Outcome<DescribeClustersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeClustersRequest, DescribeClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val clusters = it?.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible() ?: listOf()
            val projection = clustersOrEmpty.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val clusters = it?.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible() ?: listOf()
            val projection = clustersOrEmpty.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ClusterNotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeClusters(request) }
}

suspend fun RedshiftClient.waitUntilClusterAvailable(block: DescribeClustersRequest.Builder.() -> Unit): Outcome<DescribeClustersResponse> =
    waitUntilClusterAvailable(DescribeClustersRequest.Builder().apply(block).build())

suspend fun RedshiftClient.waitUntilClusterDeleted(request: DescribeClustersRequest): Outcome<DescribeClustersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeClustersRequest, DescribeClustersResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ClusterNotFound"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val clusters = it?.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible() ?: listOf()
            val projection = clustersOrEmpty.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val clusters = it?.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible() ?: listOf()
            val projection = clustersOrEmpty.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            projection?.any { it?.toString() == "modifying" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeClusters(request) }
}

suspend fun RedshiftClient.waitUntilClusterDeleted(block: DescribeClustersRequest.Builder.() -> Unit): Outcome<DescribeClustersResponse> =
    waitUntilClusterDeleted(DescribeClustersRequest.Builder().apply(block).build())

suspend fun RedshiftClient.waitUntilClusterRestored(request: DescribeClustersRequest): Outcome<DescribeClustersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeClustersRequest, DescribeClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val clusters = it?.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible() ?: listOf()
            val projection = clustersOrEmpty.flatMap {
                val restoreStatus = it?.restoreStatus
                val status = restoreStatus?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "completed" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val clusters = it?.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible() ?: listOf()
            val projection = clustersOrEmpty.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeClusters(request) }
}

suspend fun RedshiftClient.waitUntilClusterRestored(block: DescribeClustersRequest.Builder.() -> Unit): Outcome<DescribeClustersResponse> =
    waitUntilClusterRestored(DescribeClustersRequest.Builder().apply(block).build())

suspend fun RedshiftClient.waitUntilSnapshotAvailable(request: DescribeClusterSnapshotsRequest): Outcome<DescribeClusterSnapshotsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeClusterSnapshotsRequest, DescribeClusterSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val snapshots = it?.snapshots
            val snapshotsOrEmpty = snapshots?.flattenIfPossible() ?: listOf()
            val projection = snapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val snapshots = it?.snapshots
            val snapshotsOrEmpty = snapshots?.flattenIfPossible() ?: listOf()
            val projection = snapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val snapshots = it?.snapshots
            val snapshotsOrEmpty = snapshots?.flattenIfPossible() ?: listOf()
            val projection = snapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeClusterSnapshots(request) }
}

suspend fun RedshiftClient.waitUntilSnapshotAvailable(block: DescribeClusterSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeClusterSnapshotsResponse> =
    waitUntilSnapshotAvailable(DescribeClusterSnapshotsRequest.Builder().apply(block).build())
