// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a cluster.
 */
class Cluster private constructor(builder: Builder) {
    /**
     * A boolean value that, if `true`, indicates that major version upgrades will be applied automatically to the cluster during the maintenance window.
     */
    val allowVersionUpgrade: kotlin.Boolean = builder.allowVersionUpgrade
    /**
     * The AQUA (Advanced Query Accelerator) configuration of the cluster.
     */
    val aquaConfiguration: aws.sdk.kotlin.services.redshift.model.AquaConfiguration? = builder.aquaConfiguration
    /**
     * The number of days that automatic cluster snapshots are retained.
     */
    val automatedSnapshotRetentionPeriod: kotlin.Int = builder.automatedSnapshotRetentionPeriod
    /**
     * The name of the Availability Zone in which the cluster is located.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Describes the status of the Availability Zone relocation operation.
     */
    val availabilityZoneRelocationStatus: kotlin.String? = builder.availabilityZoneRelocationStatus
    /**
     * The availability status of the cluster for queries. Possible values are the following:
     * + Available - The cluster is available for queries.
     * + Unavailable - The cluster is not available for queries.
     * + Maintenance - The cluster is intermittently available for queries due to maintenance activities.
     * + Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.
     * + Failed - The cluster failed and is not available for queries.
     */
    val clusterAvailabilityStatus: kotlin.String? = builder.clusterAvailabilityStatus
    /**
     * The date and time that the cluster was created.
     */
    val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * The unique identifier of the cluster.
     */
    val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The namespace Amazon Resource Name (ARN) of the cluster.
     */
    val clusterNamespaceArn: kotlin.String? = builder.clusterNamespaceArn
    /**
     * The nodes in the cluster.
     */
    val clusterNodes: List<ClusterNode>? = builder.clusterNodes
    /**
     * The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list is returned with its status.
     */
    val clusterParameterGroups: List<ClusterParameterGroupStatus>? = builder.clusterParameterGroups
    /**
     * The public key for the cluster.
     */
    val clusterPublicKey: kotlin.String? = builder.clusterPublicKey
    /**
     * The specific revision number of the database in the cluster.
     */
    val clusterRevisionNumber: kotlin.String? = builder.clusterRevisionNumber
    /**
     * A list of cluster security group that are associated with the cluster. Each security group is represented by an element that contains `ClusterSecurityGroup.Name` and `ClusterSecurityGroup.Status` subelements.
     *
     * Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the **VpcSecurityGroups** parameter.
     */
    val clusterSecurityGroups: List<ClusterSecurityGroupMembership>? = builder.clusterSecurityGroups
    /**
     * A value that returns the destination region and retention period that are configured for cross-region snapshot copy.
     */
    val clusterSnapshotCopyStatus: aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus? = builder.clusterSnapshotCopyStatus
    /**
     * The current state of the cluster. Possible values are the following:
     * + `available`
     * + `available, prep-for-resize`
     * + `available, resize-cleanup`
     * + `cancelling-resize`
     * + `creating`
     * + `deleting`
     * + `final-snapshot`
     * + `hardware-failure`
     * + `incompatible-hsm`
     * + `incompatible-network`
     * + `incompatible-parameters`
     * + `incompatible-restore`
     * + `modifying`
     * + `paused`
     * + `rebooting`
     * + `renaming`
     * + `resizing`
     * + `rotating-keys`
     * + `storage-full`
     * + `updating-hsm`
     */
    val clusterStatus: kotlin.String? = builder.clusterStatus
    /**
     * The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.
     */
    val clusterSubnetGroupName: kotlin.String? = builder.clusterSubnetGroupName
    /**
     * The version ID of the Amazon Redshift engine that is running on the cluster.
     */
    val clusterVersion: kotlin.String? = builder.clusterVersion
    /**
     *
     */
    val dataTransferProgress: aws.sdk.kotlin.services.redshift.model.DataTransferProgress? = builder.dataTransferProgress
    /**
     * The name of the initial database that was created when the cluster was created. This same name is returned for the life of the cluster. If an initial database was not specified, a database named `dev`dev was created by default.
     */
    val dbName: kotlin.String? = builder.dbName
    /**
     * The Amazon Resource Name (ARN) for the IAM role set as default for the cluster.
     */
    val defaultIamRoleArn: kotlin.String? = builder.defaultIamRoleArn
    /**
     * Describes a group of `DeferredMaintenanceWindow` objects.
     */
    val deferredMaintenanceWindows: List<DeferredMaintenanceWindow>? = builder.deferredMaintenanceWindows
    /**
     * The status of the elastic IP (EIP) address.
     */
    val elasticIpStatus: aws.sdk.kotlin.services.redshift.model.ElasticIpStatus? = builder.elasticIpStatus
    /**
     * The number of nodes that you can resize the cluster to with the elastic resize method.
     */
    val elasticResizeNumberOfNodeOptions: kotlin.String? = builder.elasticResizeNumberOfNodeOptions
    /**
     * A boolean value that, if `true`, indicates that data in the cluster is encrypted at rest.
     */
    val encrypted: kotlin.Boolean = builder.encrypted
    /**
     * The connection endpoint.
     */
    val endpoint: aws.sdk.kotlin.services.redshift.model.Endpoint? = builder.endpoint
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
     *
     * If this option is `true`, enhanced VPC routing is enabled.
     *
     * Default: false
     */
    val enhancedVpcRouting: kotlin.Boolean = builder.enhancedVpcRouting
    /**
     * The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled.
     */
    val expectedNextSnapshotScheduleTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expectedNextSnapshotScheduleTime
    /**
     * The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled. Possible values are the following:
     * + OnTrack - The next snapshot is expected to be taken on time.
     * + Pending - The next snapshot is pending to be taken.
     */
    val expectedNextSnapshotScheduleTimeStatus: kotlin.String? = builder.expectedNextSnapshotScheduleTimeStatus
    /**
     * A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module (HSM) settings changes specified in a modify cluster command.
     *
     * Values: active, applying
     */
    val hsmStatus: aws.sdk.kotlin.services.redshift.model.HsmStatus? = builder.hsmStatus
    /**
     * A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.
     */
    val iamRoles: List<ClusterIamRole>? = builder.iamRoles
    /**
     * The Key Management Service (KMS) key ID of the encryption key used to encrypt data in the cluster.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the maintenance track for the cluster.
     */
    val maintenanceTrackName: kotlin.String? = builder.maintenanceTrackName
    /**
     * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    val manualSnapshotRetentionPeriod: kotlin.Int = builder.manualSnapshotRetentionPeriod
    /**
     * The admin user name for the cluster. This name is used to connect to the database that is specified in the **DBName** parameter.
     */
    val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The status of a modify operation, if any, initiated for the cluster.
     */
    val modifyStatus: kotlin.String? = builder.modifyStatus
    /**
     * The date and time in UTC when system maintenance can begin.
     */
    val nextMaintenanceWindowStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.nextMaintenanceWindowStartTime
    /**
     * The node type for the nodes in the cluster.
     */
    val nodeType: kotlin.String? = builder.nodeType
    /**
     * The number of compute nodes in the cluster.
     */
    val numberOfNodes: kotlin.Int = builder.numberOfNodes
    /**
     * Cluster operations that are waiting to be started.
     */
    val pendingActions: List<String>? = builder.pendingActions
    /**
     * A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are identified by subelements.
     */
    val pendingModifiedValues: aws.sdk.kotlin.services.redshift.model.PendingModifiedValues? = builder.pendingModifiedValues
    /**
     * The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A boolean value that, if `true`, indicates that the cluster can be accessed from a public network.
     */
    val publiclyAccessible: kotlin.Boolean = builder.publiclyAccessible
    /**
     * The status of the reserved-node exchange request. Statuses include in-progress and requested.
     */
    val reservedNodeExchangeStatus: aws.sdk.kotlin.services.redshift.model.ReservedNodeExchangeStatus? = builder.reservedNodeExchangeStatus
    /**
     * Returns the following:
     * + AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.
     * + ResizeType: Returns ClassicResize
     */
    val resizeInfo: aws.sdk.kotlin.services.redshift.model.ResizeInfo? = builder.resizeInfo
    /**
     * A value that describes the status of a cluster restore action. This parameter returns null if the cluster was not created by restoring a snapshot.
     */
    val restoreStatus: aws.sdk.kotlin.services.redshift.model.RestoreStatus? = builder.restoreStatus
    /**
     * A unique identifier for the cluster snapshot schedule.
     */
    val snapshotScheduleIdentifier: kotlin.String? = builder.snapshotScheduleIdentifier
    /**
     * The current state of the cluster snapshot schedule.
     */
    val snapshotScheduleState: aws.sdk.kotlin.services.redshift.model.ScheduleState? = builder.snapshotScheduleState
    /**
     * The list of tags for the cluster.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The total storage capacity of the cluster in megabytes.
     */
    val totalStorageCapacityInMegaBytes: kotlin.Long? = builder.totalStorageCapacityInMegaBytes
    /**
     * The identifier of the VPC the cluster is in, if the cluster is in a VPC.
     */
    val vpcId: kotlin.String? = builder.vpcId
    /**
     * A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster. This parameter is returned only if the cluster is in a VPC.
     */
    val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("allowVersionUpgrade=$allowVersionUpgrade,")
        append("aquaConfiguration=$aquaConfiguration,")
        append("automatedSnapshotRetentionPeriod=$automatedSnapshotRetentionPeriod,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneRelocationStatus=$availabilityZoneRelocationStatus,")
        append("clusterAvailabilityStatus=$clusterAvailabilityStatus,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterNamespaceArn=$clusterNamespaceArn,")
        append("clusterNodes=$clusterNodes,")
        append("clusterParameterGroups=$clusterParameterGroups,")
        append("clusterPublicKey=$clusterPublicKey,")
        append("clusterRevisionNumber=$clusterRevisionNumber,")
        append("clusterSecurityGroups=$clusterSecurityGroups,")
        append("clusterSnapshotCopyStatus=$clusterSnapshotCopyStatus,")
        append("clusterStatus=$clusterStatus,")
        append("clusterSubnetGroupName=$clusterSubnetGroupName,")
        append("clusterVersion=$clusterVersion,")
        append("dataTransferProgress=$dataTransferProgress,")
        append("dbName=$dbName,")
        append("defaultIamRoleArn=$defaultIamRoleArn,")
        append("deferredMaintenanceWindows=$deferredMaintenanceWindows,")
        append("elasticIpStatus=$elasticIpStatus,")
        append("elasticResizeNumberOfNodeOptions=$elasticResizeNumberOfNodeOptions,")
        append("encrypted=$encrypted,")
        append("endpoint=$endpoint,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("expectedNextSnapshotScheduleTime=$expectedNextSnapshotScheduleTime,")
        append("expectedNextSnapshotScheduleTimeStatus=$expectedNextSnapshotScheduleTimeStatus,")
        append("hsmStatus=$hsmStatus,")
        append("iamRoles=$iamRoles,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("masterUsername=$masterUsername,")
        append("modifyStatus=$modifyStatus,")
        append("nextMaintenanceWindowStartTime=$nextMaintenanceWindowStartTime,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("pendingActions=$pendingActions,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("reservedNodeExchangeStatus=$reservedNodeExchangeStatus,")
        append("resizeInfo=$resizeInfo,")
        append("restoreStatus=$restoreStatus,")
        append("snapshotScheduleIdentifier=$snapshotScheduleIdentifier,")
        append("snapshotScheduleState=$snapshotScheduleState,")
        append("tags=$tags,")
        append("totalStorageCapacityInMegaBytes=$totalStorageCapacityInMegaBytes,")
        append("vpcId=$vpcId,")
        append("vpcSecurityGroups=$vpcSecurityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowVersionUpgrade.hashCode()
        result = 31 * result + (aquaConfiguration?.hashCode() ?: 0)
        result = 31 * result + (automatedSnapshotRetentionPeriod)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneRelocationStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterAvailabilityStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterNamespaceArn?.hashCode() ?: 0)
        result = 31 * result + (clusterNodes?.hashCode() ?: 0)
        result = 31 * result + (clusterParameterGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterPublicKey?.hashCode() ?: 0)
        result = 31 * result + (clusterRevisionNumber?.hashCode() ?: 0)
        result = 31 * result + (clusterSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterSnapshotCopyStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (dataTransferProgress?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (defaultIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (deferredMaintenanceWindows?.hashCode() ?: 0)
        result = 31 * result + (elasticIpStatus?.hashCode() ?: 0)
        result = 31 * result + (elasticResizeNumberOfNodeOptions?.hashCode() ?: 0)
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting.hashCode())
        result = 31 * result + (expectedNextSnapshotScheduleTime?.hashCode() ?: 0)
        result = 31 * result + (expectedNextSnapshotScheduleTimeStatus?.hashCode() ?: 0)
        result = 31 * result + (hsmStatus?.hashCode() ?: 0)
        result = 31 * result + (iamRoles?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (modifyStatus?.hashCode() ?: 0)
        result = 31 * result + (nextMaintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes)
        result = 31 * result + (pendingActions?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible.hashCode())
        result = 31 * result + (reservedNodeExchangeStatus?.hashCode() ?: 0)
        result = 31 * result + (resizeInfo?.hashCode() ?: 0)
        result = 31 * result + (restoreStatus?.hashCode() ?: 0)
        result = 31 * result + (snapshotScheduleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotScheduleState?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalStorageCapacityInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (allowVersionUpgrade != other.allowVersionUpgrade) return false
        if (aquaConfiguration != other.aquaConfiguration) return false
        if (automatedSnapshotRetentionPeriod != other.automatedSnapshotRetentionPeriod) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneRelocationStatus != other.availabilityZoneRelocationStatus) return false
        if (clusterAvailabilityStatus != other.clusterAvailabilityStatus) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterNamespaceArn != other.clusterNamespaceArn) return false
        if (clusterNodes != other.clusterNodes) return false
        if (clusterParameterGroups != other.clusterParameterGroups) return false
        if (clusterPublicKey != other.clusterPublicKey) return false
        if (clusterRevisionNumber != other.clusterRevisionNumber) return false
        if (clusterSecurityGroups != other.clusterSecurityGroups) return false
        if (clusterSnapshotCopyStatus != other.clusterSnapshotCopyStatus) return false
        if (clusterStatus != other.clusterStatus) return false
        if (clusterSubnetGroupName != other.clusterSubnetGroupName) return false
        if (clusterVersion != other.clusterVersion) return false
        if (dataTransferProgress != other.dataTransferProgress) return false
        if (dbName != other.dbName) return false
        if (defaultIamRoleArn != other.defaultIamRoleArn) return false
        if (deferredMaintenanceWindows != other.deferredMaintenanceWindows) return false
        if (elasticIpStatus != other.elasticIpStatus) return false
        if (elasticResizeNumberOfNodeOptions != other.elasticResizeNumberOfNodeOptions) return false
        if (encrypted != other.encrypted) return false
        if (endpoint != other.endpoint) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (expectedNextSnapshotScheduleTime != other.expectedNextSnapshotScheduleTime) return false
        if (expectedNextSnapshotScheduleTimeStatus != other.expectedNextSnapshotScheduleTimeStatus) return false
        if (hsmStatus != other.hsmStatus) return false
        if (iamRoles != other.iamRoles) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (masterUsername != other.masterUsername) return false
        if (modifyStatus != other.modifyStatus) return false
        if (nextMaintenanceWindowStartTime != other.nextMaintenanceWindowStartTime) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (pendingActions != other.pendingActions) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (reservedNodeExchangeStatus != other.reservedNodeExchangeStatus) return false
        if (resizeInfo != other.resizeInfo) return false
        if (restoreStatus != other.restoreStatus) return false
        if (snapshotScheduleIdentifier != other.snapshotScheduleIdentifier) return false
        if (snapshotScheduleState != other.snapshotScheduleState) return false
        if (tags != other.tags) return false
        if (totalStorageCapacityInMegaBytes != other.totalStorageCapacityInMegaBytes) return false
        if (vpcId != other.vpcId) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.Cluster = Builder(this).apply(block).build()

    class Builder {
        /**
         * A boolean value that, if `true`, indicates that major version upgrades will be applied automatically to the cluster during the maintenance window.
         */
        var allowVersionUpgrade: kotlin.Boolean = false
        /**
         * The AQUA (Advanced Query Accelerator) configuration of the cluster.
         */
        var aquaConfiguration: aws.sdk.kotlin.services.redshift.model.AquaConfiguration? = null
        /**
         * The number of days that automatic cluster snapshots are retained.
         */
        var automatedSnapshotRetentionPeriod: kotlin.Int = 0
        /**
         * The name of the Availability Zone in which the cluster is located.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * Describes the status of the Availability Zone relocation operation.
         */
        var availabilityZoneRelocationStatus: kotlin.String? = null
        /**
         * The availability status of the cluster for queries. Possible values are the following:
         * + Available - The cluster is available for queries.
         * + Unavailable - The cluster is not available for queries.
         * + Maintenance - The cluster is intermittently available for queries due to maintenance activities.
         * + Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.
         * + Failed - The cluster failed and is not available for queries.
         */
        var clusterAvailabilityStatus: kotlin.String? = null
        /**
         * The date and time that the cluster was created.
         */
        var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the cluster.
         */
        var clusterIdentifier: kotlin.String? = null
        /**
         * The namespace Amazon Resource Name (ARN) of the cluster.
         */
        var clusterNamespaceArn: kotlin.String? = null
        /**
         * The nodes in the cluster.
         */
        var clusterNodes: List<ClusterNode>? = null
        /**
         * The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list is returned with its status.
         */
        var clusterParameterGroups: List<ClusterParameterGroupStatus>? = null
        /**
         * The public key for the cluster.
         */
        var clusterPublicKey: kotlin.String? = null
        /**
         * The specific revision number of the database in the cluster.
         */
        var clusterRevisionNumber: kotlin.String? = null
        /**
         * A list of cluster security group that are associated with the cluster. Each security group is represented by an element that contains `ClusterSecurityGroup.Name` and `ClusterSecurityGroup.Status` subelements.
         *
         * Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the **VpcSecurityGroups** parameter.
         */
        var clusterSecurityGroups: List<ClusterSecurityGroupMembership>? = null
        /**
         * A value that returns the destination region and retention period that are configured for cross-region snapshot copy.
         */
        var clusterSnapshotCopyStatus: aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus? = null
        /**
         * The current state of the cluster. Possible values are the following:
         * + `available`
         * + `available, prep-for-resize`
         * + `available, resize-cleanup`
         * + `cancelling-resize`
         * + `creating`
         * + `deleting`
         * + `final-snapshot`
         * + `hardware-failure`
         * + `incompatible-hsm`
         * + `incompatible-network`
         * + `incompatible-parameters`
         * + `incompatible-restore`
         * + `modifying`
         * + `paused`
         * + `rebooting`
         * + `renaming`
         * + `resizing`
         * + `rotating-keys`
         * + `storage-full`
         * + `updating-hsm`
         */
        var clusterStatus: kotlin.String? = null
        /**
         * The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.
         */
        var clusterSubnetGroupName: kotlin.String? = null
        /**
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         */
        var clusterVersion: kotlin.String? = null
        /**
         *
         */
        var dataTransferProgress: aws.sdk.kotlin.services.redshift.model.DataTransferProgress? = null
        /**
         * The name of the initial database that was created when the cluster was created. This same name is returned for the life of the cluster. If an initial database was not specified, a database named `dev`dev was created by default.
         */
        var dbName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the IAM role set as default for the cluster.
         */
        var defaultIamRoleArn: kotlin.String? = null
        /**
         * Describes a group of `DeferredMaintenanceWindow` objects.
         */
        var deferredMaintenanceWindows: List<DeferredMaintenanceWindow>? = null
        /**
         * The status of the elastic IP (EIP) address.
         */
        var elasticIpStatus: aws.sdk.kotlin.services.redshift.model.ElasticIpStatus? = null
        /**
         * The number of nodes that you can resize the cluster to with the elastic resize method.
         */
        var elasticResizeNumberOfNodeOptions: kotlin.String? = null
        /**
         * A boolean value that, if `true`, indicates that data in the cluster is encrypted at rest.
         */
        var encrypted: kotlin.Boolean = false
        /**
         * The connection endpoint.
         */
        var endpoint: aws.sdk.kotlin.services.redshift.model.Endpoint? = null
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
         *
         * If this option is `true`, enhanced VPC routing is enabled.
         *
         * Default: false
         */
        var enhancedVpcRouting: kotlin.Boolean = false
        /**
         * The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled.
         */
        var expectedNextSnapshotScheduleTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled. Possible values are the following:
         * + OnTrack - The next snapshot is expected to be taken on time.
         * + Pending - The next snapshot is pending to be taken.
         */
        var expectedNextSnapshotScheduleTimeStatus: kotlin.String? = null
        /**
         * A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module (HSM) settings changes specified in a modify cluster command.
         *
         * Values: active, applying
         */
        var hsmStatus: aws.sdk.kotlin.services.redshift.model.HsmStatus? = null
        /**
         * A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.
         */
        var iamRoles: List<ClusterIamRole>? = null
        /**
         * The Key Management Service (KMS) key ID of the encryption key used to encrypt data in the cluster.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The name of the maintenance track for the cluster.
         */
        var maintenanceTrackName: kotlin.String? = null
        /**
         * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        var manualSnapshotRetentionPeriod: kotlin.Int = 0
        /**
         * The admin user name for the cluster. This name is used to connect to the database that is specified in the **DBName** parameter.
         */
        var masterUsername: kotlin.String? = null
        /**
         * The status of a modify operation, if any, initiated for the cluster.
         */
        var modifyStatus: kotlin.String? = null
        /**
         * The date and time in UTC when system maintenance can begin.
         */
        var nextMaintenanceWindowStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The node type for the nodes in the cluster.
         */
        var nodeType: kotlin.String? = null
        /**
         * The number of compute nodes in the cluster.
         */
        var numberOfNodes: kotlin.Int = 0
        /**
         * Cluster operations that are waiting to be started.
         */
        var pendingActions: List<String>? = null
        /**
         * A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are identified by subelements.
         */
        var pendingModifiedValues: aws.sdk.kotlin.services.redshift.model.PendingModifiedValues? = null
        /**
         * The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A boolean value that, if `true`, indicates that the cluster can be accessed from a public network.
         */
        var publiclyAccessible: kotlin.Boolean = false
        /**
         * The status of the reserved-node exchange request. Statuses include in-progress and requested.
         */
        var reservedNodeExchangeStatus: aws.sdk.kotlin.services.redshift.model.ReservedNodeExchangeStatus? = null
        /**
         * Returns the following:
         * + AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.
         * + ResizeType: Returns ClassicResize
         */
        var resizeInfo: aws.sdk.kotlin.services.redshift.model.ResizeInfo? = null
        /**
         * A value that describes the status of a cluster restore action. This parameter returns null if the cluster was not created by restoring a snapshot.
         */
        var restoreStatus: aws.sdk.kotlin.services.redshift.model.RestoreStatus? = null
        /**
         * A unique identifier for the cluster snapshot schedule.
         */
        var snapshotScheduleIdentifier: kotlin.String? = null
        /**
         * The current state of the cluster snapshot schedule.
         */
        var snapshotScheduleState: aws.sdk.kotlin.services.redshift.model.ScheduleState? = null
        /**
         * The list of tags for the cluster.
         */
        var tags: List<Tag>? = null
        /**
         * The total storage capacity of the cluster in megabytes.
         */
        var totalStorageCapacityInMegaBytes: kotlin.Long? = null
        /**
         * The identifier of the VPC the cluster is in, if the cluster is in a VPC.
         */
        var vpcId: kotlin.String? = null
        /**
         * A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster. This parameter is returned only if the cluster is in a VPC.
         */
        var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.Cluster) : this() {
            this.allowVersionUpgrade = x.allowVersionUpgrade
            this.aquaConfiguration = x.aquaConfiguration
            this.automatedSnapshotRetentionPeriod = x.automatedSnapshotRetentionPeriod
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneRelocationStatus = x.availabilityZoneRelocationStatus
            this.clusterAvailabilityStatus = x.clusterAvailabilityStatus
            this.clusterCreateTime = x.clusterCreateTime
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterNamespaceArn = x.clusterNamespaceArn
            this.clusterNodes = x.clusterNodes
            this.clusterParameterGroups = x.clusterParameterGroups
            this.clusterPublicKey = x.clusterPublicKey
            this.clusterRevisionNumber = x.clusterRevisionNumber
            this.clusterSecurityGroups = x.clusterSecurityGroups
            this.clusterSnapshotCopyStatus = x.clusterSnapshotCopyStatus
            this.clusterStatus = x.clusterStatus
            this.clusterSubnetGroupName = x.clusterSubnetGroupName
            this.clusterVersion = x.clusterVersion
            this.dataTransferProgress = x.dataTransferProgress
            this.dbName = x.dbName
            this.defaultIamRoleArn = x.defaultIamRoleArn
            this.deferredMaintenanceWindows = x.deferredMaintenanceWindows
            this.elasticIpStatus = x.elasticIpStatus
            this.elasticResizeNumberOfNodeOptions = x.elasticResizeNumberOfNodeOptions
            this.encrypted = x.encrypted
            this.endpoint = x.endpoint
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.expectedNextSnapshotScheduleTime = x.expectedNextSnapshotScheduleTime
            this.expectedNextSnapshotScheduleTimeStatus = x.expectedNextSnapshotScheduleTimeStatus
            this.hsmStatus = x.hsmStatus
            this.iamRoles = x.iamRoles
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.masterUsername = x.masterUsername
            this.modifyStatus = x.modifyStatus
            this.nextMaintenanceWindowStartTime = x.nextMaintenanceWindowStartTime
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.pendingActions = x.pendingActions
            this.pendingModifiedValues = x.pendingModifiedValues
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.reservedNodeExchangeStatus = x.reservedNodeExchangeStatus
            this.resizeInfo = x.resizeInfo
            this.restoreStatus = x.restoreStatus
            this.snapshotScheduleIdentifier = x.snapshotScheduleIdentifier
            this.snapshotScheduleState = x.snapshotScheduleState
            this.tags = x.tags
            this.totalStorageCapacityInMegaBytes = x.totalStorageCapacityInMegaBytes
            this.vpcId = x.vpcId
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.Cluster = Cluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.AquaConfiguration] inside the given [block]
         */
        fun aquaConfiguration(block: aws.sdk.kotlin.services.redshift.model.AquaConfiguration.Builder.() -> kotlin.Unit) {
            this.aquaConfiguration = aws.sdk.kotlin.services.redshift.model.AquaConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus] inside the given [block]
         */
        fun clusterSnapshotCopyStatus(block: aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus.Builder.() -> kotlin.Unit) {
            this.clusterSnapshotCopyStatus = aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.DataTransferProgress] inside the given [block]
         */
        fun dataTransferProgress(block: aws.sdk.kotlin.services.redshift.model.DataTransferProgress.Builder.() -> kotlin.Unit) {
            this.dataTransferProgress = aws.sdk.kotlin.services.redshift.model.DataTransferProgress.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.ElasticIpStatus] inside the given [block]
         */
        fun elasticIpStatus(block: aws.sdk.kotlin.services.redshift.model.ElasticIpStatus.Builder.() -> kotlin.Unit) {
            this.elasticIpStatus = aws.sdk.kotlin.services.redshift.model.ElasticIpStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.Endpoint] inside the given [block]
         */
        fun endpoint(block: aws.sdk.kotlin.services.redshift.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.redshift.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.HsmStatus] inside the given [block]
         */
        fun hsmStatus(block: aws.sdk.kotlin.services.redshift.model.HsmStatus.Builder.() -> kotlin.Unit) {
            this.hsmStatus = aws.sdk.kotlin.services.redshift.model.HsmStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.PendingModifiedValues] inside the given [block]
         */
        fun pendingModifiedValues(block: aws.sdk.kotlin.services.redshift.model.PendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.redshift.model.PendingModifiedValues.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.ReservedNodeExchangeStatus] inside the given [block]
         */
        fun reservedNodeExchangeStatus(block: aws.sdk.kotlin.services.redshift.model.ReservedNodeExchangeStatus.Builder.() -> kotlin.Unit) {
            this.reservedNodeExchangeStatus = aws.sdk.kotlin.services.redshift.model.ReservedNodeExchangeStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.ResizeInfo] inside the given [block]
         */
        fun resizeInfo(block: aws.sdk.kotlin.services.redshift.model.ResizeInfo.Builder.() -> kotlin.Unit) {
            this.resizeInfo = aws.sdk.kotlin.services.redshift.model.ResizeInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.RestoreStatus] inside the given [block]
         */
        fun restoreStatus(block: aws.sdk.kotlin.services.redshift.model.RestoreStatus.Builder.() -> kotlin.Unit) {
            this.restoreStatus = aws.sdk.kotlin.services.redshift.model.RestoreStatus.invoke(block)
        }
    }
}
