// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * An Identity and Access Management (IAM) role that can be used by the associated Amazon Redshift cluster to access other Amazon Web Services services.
 */
class ClusterIamRole private constructor(builder: Builder) {
    /**
     * A value that describes the status of the IAM role's association with an Amazon Redshift cluster.
     *
     * The following are possible statuses and descriptions.
     * + `in-sync`: The role is available for use by the cluster.
     * + `adding`: The role is in the process of being associated with the cluster.
     * + `removing`: The role is in the process of being disassociated with the cluster.
     */
    val applyStatus: kotlin.String? = builder.applyStatus
    /**
     * The Amazon Resource Name (ARN) of the IAM role, for example, `arn:aws:iam::123456789012:role/RedshiftCopyUnload`.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ClusterIamRole = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterIamRole(")
        append("applyStatus=$applyStatus,")
        append("iamRoleArn=$iamRoleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyStatus?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterIamRole

        if (applyStatus != other.applyStatus) return false
        if (iamRoleArn != other.iamRoleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ClusterIamRole = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value that describes the status of the IAM role's association with an Amazon Redshift cluster.
         *
         * The following are possible statuses and descriptions.
         * + `in-sync`: The role is available for use by the cluster.
         * + `adding`: The role is in the process of being associated with the cluster.
         * + `removing`: The role is in the process of being disassociated with the cluster.
         */
        var applyStatus: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role, for example, `arn:aws:iam::123456789012:role/RedshiftCopyUnload`.
         */
        var iamRoleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ClusterIamRole) : this() {
            this.applyStatus = x.applyStatus
            this.iamRoleArn = x.iamRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ClusterIamRole = ClusterIamRole(this)
    }
}
