// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class CreateClusterParameterGroupRequest private constructor(builder: Builder) {
    /**
     * A description of the parameter group.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Amazon Redshift engine version to which the cluster parameter group applies. The cluster engine version determines the set of parameters.
     *
     * To get a list of valid parameter group family names, you can call DescribeClusterParameterGroups. By default, Amazon Redshift returns a list of all the parameter groups that are owned by your Amazon Web Services account, including the default parameter groups for each Amazon Redshift engine version. The parameter group family names associated with the default parameter groups provide you the valid values. For example, a valid family name is "redshift-1.0".
     */
    val parameterGroupFamily: kotlin.String? = builder.parameterGroupFamily
    /**
     * The name of the cluster parameter group.
     *
     * Constraints:
     * + Must be 1 to 255 alphanumeric characters or hyphens
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     * + Must be unique withing your Amazon Web Services account.
     *
     * This value is stored as a lower-case string.
     */
    val parameterGroupName: kotlin.String? = builder.parameterGroupName
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CreateClusterParameterGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterParameterGroupRequest(")
        append("description=$description,")
        append("parameterGroupFamily=$parameterGroupFamily,")
        append("parameterGroupName=$parameterGroupName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (parameterGroupFamily?.hashCode() ?: 0)
        result = 31 * result + (parameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterParameterGroupRequest

        if (description != other.description) return false
        if (parameterGroupFamily != other.parameterGroupFamily) return false
        if (parameterGroupName != other.parameterGroupName) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CreateClusterParameterGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A description of the parameter group.
         */
        var description: kotlin.String? = null
        /**
         * The Amazon Redshift engine version to which the cluster parameter group applies. The cluster engine version determines the set of parameters.
         *
         * To get a list of valid parameter group family names, you can call DescribeClusterParameterGroups. By default, Amazon Redshift returns a list of all the parameter groups that are owned by your Amazon Web Services account, including the default parameter groups for each Amazon Redshift engine version. The parameter group family names associated with the default parameter groups provide you the valid values. For example, a valid family name is "redshift-1.0".
         */
        var parameterGroupFamily: kotlin.String? = null
        /**
         * The name of the cluster parameter group.
         *
         * Constraints:
         * + Must be 1 to 255 alphanumeric characters or hyphens
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         * + Must be unique withing your Amazon Web Services account.
         *
         * This value is stored as a lower-case string.
         */
        var parameterGroupName: kotlin.String? = null
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CreateClusterParameterGroupRequest) : this() {
            this.description = x.description
            this.parameterGroupFamily = x.parameterGroupFamily
            this.parameterGroupName = x.parameterGroupName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CreateClusterParameterGroupRequest = CreateClusterParameterGroupRequest(this)
    }
}
