// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the status of logging for a cluster.
 */
class DescribeLoggingStatusResponse private constructor(builder: Builder) {
    /**
     * The name of the S3 bucket where the log files are stored.
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * The message indicating that logs failed to be delivered.
     */
    val lastFailureMessage: kotlin.String? = builder.lastFailureMessage
    /**
     * The last time when logs failed to be delivered.
     */
    val lastFailureTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastFailureTime
    /**
     * The last time that logs were delivered.
     */
    val lastSuccessfulDeliveryTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulDeliveryTime
    /**
     * The log destination type. An enum with possible values of `s3` and `cloudwatch`.
     */
    val logDestinationType: aws.sdk.kotlin.services.redshift.model.LogDestinationType? = builder.logDestinationType
    /**
     * The collection of exported log types. Log types include the connection log, user log and user activity log.
     */
    val logExports: List<String>? = builder.logExports
    /**
     * `true` if logging is on, `false` if logging is off.
     */
    val loggingEnabled: kotlin.Boolean = builder.loggingEnabled
    /**
     * The prefix applied to the log file names.
     */
    val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DescribeLoggingStatusResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLoggingStatusResponse(")
        append("bucketName=$bucketName,")
        append("lastFailureMessage=$lastFailureMessage,")
        append("lastFailureTime=$lastFailureTime,")
        append("lastSuccessfulDeliveryTime=$lastSuccessfulDeliveryTime,")
        append("logDestinationType=$logDestinationType,")
        append("logExports=$logExports,")
        append("loggingEnabled=$loggingEnabled,")
        append("s3KeyPrefix=$s3KeyPrefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (lastFailureMessage?.hashCode() ?: 0)
        result = 31 * result + (lastFailureTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulDeliveryTime?.hashCode() ?: 0)
        result = 31 * result + (logDestinationType?.hashCode() ?: 0)
        result = 31 * result + (logExports?.hashCode() ?: 0)
        result = 31 * result + (loggingEnabled.hashCode())
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeLoggingStatusResponse

        if (bucketName != other.bucketName) return false
        if (lastFailureMessage != other.lastFailureMessage) return false
        if (lastFailureTime != other.lastFailureTime) return false
        if (lastSuccessfulDeliveryTime != other.lastSuccessfulDeliveryTime) return false
        if (logDestinationType != other.logDestinationType) return false
        if (logExports != other.logExports) return false
        if (loggingEnabled != other.loggingEnabled) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DescribeLoggingStatusResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the S3 bucket where the log files are stored.
         */
        var bucketName: kotlin.String? = null
        /**
         * The message indicating that logs failed to be delivered.
         */
        var lastFailureMessage: kotlin.String? = null
        /**
         * The last time when logs failed to be delivered.
         */
        var lastFailureTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time that logs were delivered.
         */
        var lastSuccessfulDeliveryTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The log destination type. An enum with possible values of `s3` and `cloudwatch`.
         */
        var logDestinationType: aws.sdk.kotlin.services.redshift.model.LogDestinationType? = null
        /**
         * The collection of exported log types. Log types include the connection log, user log and user activity log.
         */
        var logExports: List<String>? = null
        /**
         * `true` if logging is on, `false` if logging is off.
         */
        var loggingEnabled: kotlin.Boolean = false
        /**
         * The prefix applied to the log file names.
         */
        var s3KeyPrefix: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DescribeLoggingStatusResponse) : this() {
            this.bucketName = x.bucketName
            this.lastFailureMessage = x.lastFailureMessage
            this.lastFailureTime = x.lastFailureTime
            this.lastSuccessfulDeliveryTime = x.lastSuccessfulDeliveryTime
            this.logDestinationType = x.logDestinationType
            this.logExports = x.logExports
            this.loggingEnabled = x.loggingEnabled
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DescribeLoggingStatusResponse = DescribeLoggingStatusResponse(this)
    }
}
