// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class DescribeNodeConfigurationOptionsRequest private constructor(builder: Builder) {
    /**
     * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster.
     */
    val actionType: aws.sdk.kotlin.services.redshift.model.ActionType? = builder.actionType
    /**
     * The identifier of the cluster to evaluate for possible node configurations.
     */
    val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * A set of name, operator, and value items to filter the results.
     */
    val filters: List<NodeConfigurationOptionsFilter>? = builder.filters
    /**
     * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeNodeConfigurationOptions request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
     *
     * Default: `500`
     *
     * Constraints: minimum 100, maximum 500.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     */
    val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The identifier of the snapshot to evaluate for possible node configurations.
     */
    val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DescribeNodeConfigurationOptionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeNodeConfigurationOptionsRequest(")
        append("actionType=$actionType,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("ownerAccount=$ownerAccount,")
        append("snapshotIdentifier=$snapshotIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionType?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeNodeConfigurationOptionsRequest

        if (actionType != other.actionType) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (ownerAccount != other.ownerAccount) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DescribeNodeConfigurationOptionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster.
         */
        var actionType: aws.sdk.kotlin.services.redshift.model.ActionType? = null
        /**
         * The identifier of the cluster to evaluate for possible node configurations.
         */
        var clusterIdentifier: kotlin.String? = null
        /**
         * A set of name, operator, and value items to filter the results.
         */
        var filters: List<NodeConfigurationOptionsFilter>? = null
        /**
         * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeNodeConfigurationOptions request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
         *
         * Default: `500`
         *
         * Constraints: minimum 100, maximum 500.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
         */
        var ownerAccount: kotlin.String? = null
        /**
         * The identifier of the snapshot to evaluate for possible node configurations.
         */
        var snapshotIdentifier: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DescribeNodeConfigurationOptionsRequest) : this() {
            this.actionType = x.actionType
            this.clusterIdentifier = x.clusterIdentifier
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.ownerAccount = x.ownerAccount
            this.snapshotIdentifier = x.snapshotIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DescribeNodeConfigurationOptionsRequest = DescribeNodeConfigurationOptionsRequest(this)
    }
}
