// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class EnableLoggingRequest private constructor(builder: Builder) {
    /**
     * The name of an existing S3 bucket where the log files are to be stored.
     *
     * Constraints:
     * + Must be in the same region as the cluster
     * + The cluster must have read bucket and put object permissions
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * The identifier of the cluster on which logging is to be started.
     *
     * Example: `examplecluster`
     */
    val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The log destination type. An enum with possible values of `s3` and `cloudwatch`.
     */
    val logDestinationType: aws.sdk.kotlin.services.redshift.model.LogDestinationType? = builder.logDestinationType
    /**
     * The collection of exported log types. Log types include the connection log, user log and user activity log.
     */
    val logExports: List<String>? = builder.logExports
    /**
     * The prefix applied to the log file names.
     *
     * Constraints:
     * + Cannot exceed 512 characters
     * + Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control characters. The hexadecimal codes for invalid characters are:
     *    + x00 to x20
     *    + x22
     *    + x27
     *    + x5c
     *    + x7f or larger
     */
    val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.EnableLoggingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnableLoggingRequest(")
        append("bucketName=$bucketName,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("logDestinationType=$logDestinationType,")
        append("logExports=$logExports,")
        append("s3KeyPrefix=$s3KeyPrefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (logDestinationType?.hashCode() ?: 0)
        result = 31 * result + (logExports?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnableLoggingRequest

        if (bucketName != other.bucketName) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (logDestinationType != other.logDestinationType) return false
        if (logExports != other.logExports) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.EnableLoggingRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of an existing S3 bucket where the log files are to be stored.
         *
         * Constraints:
         * + Must be in the same region as the cluster
         * + The cluster must have read bucket and put object permissions
         */
        var bucketName: kotlin.String? = null
        /**
         * The identifier of the cluster on which logging is to be started.
         *
         * Example: `examplecluster`
         */
        var clusterIdentifier: kotlin.String? = null
        /**
         * The log destination type. An enum with possible values of `s3` and `cloudwatch`.
         */
        var logDestinationType: aws.sdk.kotlin.services.redshift.model.LogDestinationType? = null
        /**
         * The collection of exported log types. Log types include the connection log, user log and user activity log.
         */
        var logExports: List<String>? = null
        /**
         * The prefix applied to the log file names.
         *
         * Constraints:
         * + Cannot exceed 512 characters
         * + Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control characters. The hexadecimal codes for invalid characters are:
         *    + x00 to x20
         *    + x22
         *    + x27
         *    + x5c
         *    + x7f or larger
         */
        var s3KeyPrefix: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.EnableLoggingRequest) : this() {
            this.bucketName = x.bucketName
            this.clusterIdentifier = x.clusterIdentifier
            this.logDestinationType = x.logDestinationType
            this.logExports = x.logExports
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.EnableLoggingRequest = EnableLoggingRequest(this)
    }
}
