// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Returns information about an HSM configuration, which is an object that describes to Amazon Redshift clusters the information they require to connect to an HSM where they can store database encryption keys.
 */
class HsmConfiguration private constructor(builder: Builder) {
    /**
     * A text description of the HSM configuration.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the Amazon Redshift HSM configuration.
     */
    val hsmConfigurationIdentifier: kotlin.String? = builder.hsmConfigurationIdentifier
    /**
     * The IP address that the Amazon Redshift cluster must use to access the HSM.
     */
    val hsmIpAddress: kotlin.String? = builder.hsmIpAddress
    /**
     * The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
     */
    val hsmPartitionName: kotlin.String? = builder.hsmPartitionName
    /**
     * The list of tags for the HSM configuration.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.HsmConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HsmConfiguration(")
        append("description=$description,")
        append("hsmConfigurationIdentifier=$hsmConfigurationIdentifier,")
        append("hsmIpAddress=$hsmIpAddress,")
        append("hsmPartitionName=$hsmPartitionName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (hsmConfigurationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (hsmIpAddress?.hashCode() ?: 0)
        result = 31 * result + (hsmPartitionName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HsmConfiguration

        if (description != other.description) return false
        if (hsmConfigurationIdentifier != other.hsmConfigurationIdentifier) return false
        if (hsmIpAddress != other.hsmIpAddress) return false
        if (hsmPartitionName != other.hsmPartitionName) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.HsmConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A text description of the HSM configuration.
         */
        var description: kotlin.String? = null
        /**
         * The name of the Amazon Redshift HSM configuration.
         */
        var hsmConfigurationIdentifier: kotlin.String? = null
        /**
         * The IP address that the Amazon Redshift cluster must use to access the HSM.
         */
        var hsmIpAddress: kotlin.String? = null
        /**
         * The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
         */
        var hsmPartitionName: kotlin.String? = null
        /**
         * The list of tags for the HSM configuration.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.HsmConfiguration) : this() {
            this.description = x.description
            this.hsmConfigurationIdentifier = x.hsmConfigurationIdentifier
            this.hsmIpAddress = x.hsmIpAddress
            this.hsmPartitionName = x.hsmPartitionName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.HsmConfiguration = HsmConfiguration(this)
    }
}
