// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the status of changes to HSM settings.
 */
class HsmStatus private constructor(builder: Builder) {
    /**
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
     */
    val hsmClientCertificateIdentifier: kotlin.String? = builder.hsmClientCertificateIdentifier
    /**
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
     */
    val hsmConfigurationIdentifier: kotlin.String? = builder.hsmConfigurationIdentifier
    /**
     * Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify cluster command.
     *
     * Values: active, applying
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.HsmStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HsmStatus(")
        append("hsmClientCertificateIdentifier=$hsmClientCertificateIdentifier,")
        append("hsmConfigurationIdentifier=$hsmConfigurationIdentifier,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hsmClientCertificateIdentifier?.hashCode() ?: 0
        result = 31 * result + (hsmConfigurationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HsmStatus

        if (hsmClientCertificateIdentifier != other.hsmClientCertificateIdentifier) return false
        if (hsmConfigurationIdentifier != other.hsmConfigurationIdentifier) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.HsmStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
         */
        var hsmClientCertificateIdentifier: kotlin.String? = null
        /**
         * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         */
        var hsmConfigurationIdentifier: kotlin.String? = null
        /**
         * Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify cluster command.
         *
         * Values: active, applying
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.HsmStatus) : this() {
            this.hsmClientCertificateIdentifier = x.hsmClientCertificateIdentifier
            this.hsmConfigurationIdentifier = x.hsmConfigurationIdentifier
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.HsmStatus = HsmStatus(this)
    }
}
