// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a reserved node. You can call the DescribeReservedNodeOfferings API to obtain the available reserved node offerings.
 */
class ReservedNode private constructor(builder: Builder) {
    /**
     * The currency code for the reserved cluster.
     */
    val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The duration of the node reservation in seconds.
     */
    val duration: kotlin.Int = builder.duration
    /**
     * The fixed cost Amazon Redshift charges you for this reserved node.
     */
    val fixedPrice: kotlin.Double = builder.fixedPrice
    /**
     * The number of reserved compute nodes.
     */
    val nodeCount: kotlin.Int = builder.nodeCount
    /**
     * The node type of the reserved node.
     */
    val nodeType: kotlin.String? = builder.nodeType
    /**
     * The anticipated utilization of the reserved node, as defined in the reserved node offering.
     */
    val offeringType: kotlin.String? = builder.offeringType
    /**
     * The recurring charges for the reserved node.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The unique identifier for the reservation.
     */
    val reservedNodeId: kotlin.String? = builder.reservedNodeId
    /**
     * The identifier for the reserved node offering.
     */
    val reservedNodeOfferingId: kotlin.String? = builder.reservedNodeOfferingId
    /**
     *
     */
    val reservedNodeOfferingType: aws.sdk.kotlin.services.redshift.model.ReservedNodeOfferingType? = builder.reservedNodeOfferingType
    /**
     * The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the reserved compute node.
     *
     * Possible Values:
     * + pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.
     * + active-This reserved node is owned by the caller and is available for use.
     * + payment-failed-Payment failed for the purchase attempt.
     * + retired-The reserved node is no longer available.
     * + exchanging-The owner is exchanging the reserved node for another reserved node.
     */
    val state: kotlin.String? = builder.state
    /**
     * The hourly rate Amazon Redshift charges you for this reserved node.
     */
    val usagePrice: kotlin.Double = builder.usagePrice

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ReservedNode = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedNode(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("nodeCount=$nodeCount,")
        append("nodeType=$nodeType,")
        append("offeringType=$offeringType,")
        append("recurringCharges=$recurringCharges,")
        append("reservedNodeId=$reservedNodeId,")
        append("reservedNodeOfferingId=$reservedNodeOfferingId,")
        append("reservedNodeOfferingType=$reservedNodeOfferingType,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration)
        result = 31 * result + (fixedPrice.hashCode())
        result = 31 * result + (nodeCount)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeId?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeOfferingId?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeOfferingType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (usagePrice.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedNode

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (fixedPrice != other.fixedPrice) return false
        if (nodeCount != other.nodeCount) return false
        if (nodeType != other.nodeType) return false
        if (offeringType != other.offeringType) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedNodeId != other.reservedNodeId) return false
        if (reservedNodeOfferingId != other.reservedNodeOfferingId) return false
        if (reservedNodeOfferingType != other.reservedNodeOfferingType) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ReservedNode = Builder(this).apply(block).build()

    class Builder {
        /**
         * The currency code for the reserved cluster.
         */
        var currencyCode: kotlin.String? = null
        /**
         * The duration of the node reservation in seconds.
         */
        var duration: kotlin.Int = 0
        /**
         * The fixed cost Amazon Redshift charges you for this reserved node.
         */
        var fixedPrice: kotlin.Double = 0.0
        /**
         * The number of reserved compute nodes.
         */
        var nodeCount: kotlin.Int = 0
        /**
         * The node type of the reserved node.
         */
        var nodeType: kotlin.String? = null
        /**
         * The anticipated utilization of the reserved node, as defined in the reserved node offering.
         */
        var offeringType: kotlin.String? = null
        /**
         * The recurring charges for the reserved node.
         */
        var recurringCharges: List<RecurringCharge>? = null
        /**
         * The unique identifier for the reservation.
         */
        var reservedNodeId: kotlin.String? = null
        /**
         * The identifier for the reserved node offering.
         */
        var reservedNodeOfferingId: kotlin.String? = null
        /**
         *
         */
        var reservedNodeOfferingType: aws.sdk.kotlin.services.redshift.model.ReservedNodeOfferingType? = null
        /**
         * The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the reserved compute node.
         *
         * Possible Values:
         * + pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.
         * + active-This reserved node is owned by the caller and is available for use.
         * + payment-failed-Payment failed for the purchase attempt.
         * + retired-The reserved node is no longer available.
         * + exchanging-The owner is exchanging the reserved node for another reserved node.
         */
        var state: kotlin.String? = null
        /**
         * The hourly rate Amazon Redshift charges you for this reserved node.
         */
        var usagePrice: kotlin.Double = 0.0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ReservedNode) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.nodeCount = x.nodeCount
            this.nodeType = x.nodeType
            this.offeringType = x.offeringType
            this.recurringCharges = x.recurringCharges
            this.reservedNodeId = x.reservedNodeId
            this.reservedNodeOfferingId = x.reservedNodeOfferingId
            this.reservedNodeOfferingType = x.reservedNodeOfferingType
            this.startTime = x.startTime
            this.state = x.state
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ReservedNode = ReservedNode(this)
    }
}
