// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.paginators

import aws.sdk.kotlin.services.redshift.RedshiftClient
import aws.sdk.kotlin.services.redshift.model.Cluster
import aws.sdk.kotlin.services.redshift.model.ClusterDbRevision
import aws.sdk.kotlin.services.redshift.model.ClusterParameterGroup
import aws.sdk.kotlin.services.redshift.model.ClusterSecurityGroup
import aws.sdk.kotlin.services.redshift.model.ClusterSubnetGroup
import aws.sdk.kotlin.services.redshift.model.ClusterVersion
import aws.sdk.kotlin.services.redshift.model.DataShare
import aws.sdk.kotlin.services.redshift.model.DescribeClusterDbRevisionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterDbRevisionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterParameterGroupsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterParameterGroupsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterParametersRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterParametersResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSecurityGroupsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSecurityGroupsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSubnetGroupsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSubnetGroupsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterTracksRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterTracksResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterVersionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterVersionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClustersRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClustersResponse
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesForConsumerRequest
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesForConsumerResponse
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesForProducerRequest
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesForProducerResponse
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeDefaultClusterParametersRequest
import aws.sdk.kotlin.services.redshift.model.DescribeDefaultClusterParametersResponse
import aws.sdk.kotlin.services.redshift.model.DescribeEndpointAccessRequest
import aws.sdk.kotlin.services.redshift.model.DescribeEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.DescribeEndpointAuthorizationRequest
import aws.sdk.kotlin.services.redshift.model.DescribeEndpointAuthorizationResponse
import aws.sdk.kotlin.services.redshift.model.DescribeEventSubscriptionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeEventSubscriptionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeEventsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeEventsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeHsmClientCertificatesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeHsmClientCertificatesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeHsmConfigurationsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeHsmConfigurationsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeNodeConfigurationOptionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeNodeConfigurationOptionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeOrderableClusterOptionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeOrderableClusterOptionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodeExchangeStatusResponse
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodeOfferingsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodeOfferingsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeScheduledActionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeScheduledActionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeSnapshotCopyGrantsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeSnapshotCopyGrantsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeSnapshotSchedulesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeSnapshotSchedulesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeTableRestoreStatusRequest
import aws.sdk.kotlin.services.redshift.model.DescribeTableRestoreStatusResponse
import aws.sdk.kotlin.services.redshift.model.DescribeTagsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeTagsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeUsageLimitsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeUsageLimitsResponse
import aws.sdk.kotlin.services.redshift.model.EndpointAccess
import aws.sdk.kotlin.services.redshift.model.EndpointAuthorization
import aws.sdk.kotlin.services.redshift.model.Event
import aws.sdk.kotlin.services.redshift.model.EventSubscription
import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest
import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse
import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeOfferingsRequest
import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeOfferingsResponse
import aws.sdk.kotlin.services.redshift.model.HsmClientCertificate
import aws.sdk.kotlin.services.redshift.model.HsmConfiguration
import aws.sdk.kotlin.services.redshift.model.MaintenanceTrack
import aws.sdk.kotlin.services.redshift.model.NodeConfigurationOption
import aws.sdk.kotlin.services.redshift.model.OrderableClusterOption
import aws.sdk.kotlin.services.redshift.model.Parameter
import aws.sdk.kotlin.services.redshift.model.ReservedNode
import aws.sdk.kotlin.services.redshift.model.ReservedNodeConfigurationOption
import aws.sdk.kotlin.services.redshift.model.ReservedNodeExchangeStatus
import aws.sdk.kotlin.services.redshift.model.ReservedNodeOffering
import aws.sdk.kotlin.services.redshift.model.ScheduledAction
import aws.sdk.kotlin.services.redshift.model.Snapshot
import aws.sdk.kotlin.services.redshift.model.SnapshotCopyGrant
import aws.sdk.kotlin.services.redshift.model.SnapshotSchedule
import aws.sdk.kotlin.services.redshift.model.TableRestoreStatus
import aws.sdk.kotlin.services.redshift.model.TaggedResource
import aws.sdk.kotlin.services.redshift.model.UsageLimit
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeClusterDbRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClusterDbRevisionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterDbRevisionsResponse]
 */
fun RedshiftClient.describeClusterDbRevisionsPaginated(initialRequest: DescribeClusterDbRevisionsRequest): Flow<DescribeClusterDbRevisionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeClusterDbRevisionsPaginated.describeClusterDbRevisions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClusterDbRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterDbRevisionsResponse]
 */
fun RedshiftClient.describeClusterDbRevisionsPaginated(block: DescribeClusterDbRevisionsRequest.Builder.() -> Unit): Flow<DescribeClusterDbRevisionsResponse> =
    describeClusterDbRevisionsPaginated(DescribeClusterDbRevisionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClusterDbRevisionsPaginated]
 * to access the nested member [ClusterDbRevision]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterDbRevision]
 */
@JvmName("describeClusterDbRevisionsResponseClusterDbRevision")
fun Flow<DescribeClusterDbRevisionsResponse>.clusterDbRevisions(): Flow<ClusterDbRevision> =
    transform() { response ->
        response.clusterDbRevisions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClusterParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClusterParameterGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterParameterGroupsResponse]
 */
fun RedshiftClient.describeClusterParameterGroupsPaginated(initialRequest: DescribeClusterParameterGroupsRequest): Flow<DescribeClusterParameterGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeClusterParameterGroupsPaginated.describeClusterParameterGroups(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClusterParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterParameterGroupsResponse]
 */
fun RedshiftClient.describeClusterParameterGroupsPaginated(block: DescribeClusterParameterGroupsRequest.Builder.() -> Unit): Flow<DescribeClusterParameterGroupsResponse> =
    describeClusterParameterGroupsPaginated(DescribeClusterParameterGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClusterParameterGroupsPaginated]
 * to access the nested member [ClusterParameterGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterParameterGroup]
 */
@JvmName("describeClusterParameterGroupsResponseClusterParameterGroup")
fun Flow<DescribeClusterParameterGroupsResponse>.parameterGroups(): Flow<ClusterParameterGroup> =
    transform() { response ->
        response.parameterGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClusterParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClusterParametersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterParametersResponse]
 */
fun RedshiftClient.describeClusterParametersPaginated(initialRequest: DescribeClusterParametersRequest): Flow<DescribeClusterParametersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeClusterParametersPaginated.describeClusterParameters(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClusterParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterParametersResponse]
 */
fun RedshiftClient.describeClusterParametersPaginated(block: DescribeClusterParametersRequest.Builder.() -> Unit): Flow<DescribeClusterParametersResponse> =
    describeClusterParametersPaginated(DescribeClusterParametersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClusterParametersPaginated]
 * to access the nested member [Parameter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Parameter]
 */
@JvmName("describeClusterParametersResponseParameter")
fun Flow<DescribeClusterParametersResponse>.parameters(): Flow<Parameter> =
    transform() { response ->
        response.parameters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClustersResponse]
 */
fun RedshiftClient.describeClustersPaginated(initialRequest: DescribeClustersRequest): Flow<DescribeClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeClustersPaginated.describeClusters(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClustersResponse]
 */
fun RedshiftClient.describeClustersPaginated(block: DescribeClustersRequest.Builder.() -> Unit): Flow<DescribeClustersResponse> =
    describeClustersPaginated(DescribeClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClustersPaginated]
 * to access the nested member [Cluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Cluster]
 */
@JvmName("describeClustersResponseCluster")
fun Flow<DescribeClustersResponse>.clusters(): Flow<Cluster> =
    transform() { response ->
        response.clusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClusterSecurityGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClusterSecurityGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterSecurityGroupsResponse]
 */
fun RedshiftClient.describeClusterSecurityGroupsPaginated(initialRequest: DescribeClusterSecurityGroupsRequest): Flow<DescribeClusterSecurityGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeClusterSecurityGroupsPaginated.describeClusterSecurityGroups(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClusterSecurityGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterSecurityGroupsResponse]
 */
fun RedshiftClient.describeClusterSecurityGroupsPaginated(block: DescribeClusterSecurityGroupsRequest.Builder.() -> Unit): Flow<DescribeClusterSecurityGroupsResponse> =
    describeClusterSecurityGroupsPaginated(DescribeClusterSecurityGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClusterSecurityGroupsPaginated]
 * to access the nested member [ClusterSecurityGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterSecurityGroup]
 */
@JvmName("describeClusterSecurityGroupsResponseClusterSecurityGroup")
fun Flow<DescribeClusterSecurityGroupsResponse>.clusterSecurityGroups(): Flow<ClusterSecurityGroup> =
    transform() { response ->
        response.clusterSecurityGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClusterSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClusterSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterSnapshotsResponse]
 */
fun RedshiftClient.describeClusterSnapshotsPaginated(initialRequest: DescribeClusterSnapshotsRequest): Flow<DescribeClusterSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeClusterSnapshotsPaginated.describeClusterSnapshots(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClusterSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterSnapshotsResponse]
 */
fun RedshiftClient.describeClusterSnapshotsPaginated(block: DescribeClusterSnapshotsRequest.Builder.() -> Unit): Flow<DescribeClusterSnapshotsResponse> =
    describeClusterSnapshotsPaginated(DescribeClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClusterSnapshotsPaginated]
 * to access the nested member [Snapshot]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Snapshot]
 */
@JvmName("describeClusterSnapshotsResponseSnapshot")
fun Flow<DescribeClusterSnapshotsResponse>.snapshots(): Flow<Snapshot> =
    transform() { response ->
        response.snapshots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClusterSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClusterSubnetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterSubnetGroupsResponse]
 */
fun RedshiftClient.describeClusterSubnetGroupsPaginated(initialRequest: DescribeClusterSubnetGroupsRequest): Flow<DescribeClusterSubnetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeClusterSubnetGroupsPaginated.describeClusterSubnetGroups(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClusterSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterSubnetGroupsResponse]
 */
fun RedshiftClient.describeClusterSubnetGroupsPaginated(block: DescribeClusterSubnetGroupsRequest.Builder.() -> Unit): Flow<DescribeClusterSubnetGroupsResponse> =
    describeClusterSubnetGroupsPaginated(DescribeClusterSubnetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClusterSubnetGroupsPaginated]
 * to access the nested member [ClusterSubnetGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterSubnetGroup]
 */
@JvmName("describeClusterSubnetGroupsResponseClusterSubnetGroup")
fun Flow<DescribeClusterSubnetGroupsResponse>.clusterSubnetGroups(): Flow<ClusterSubnetGroup> =
    transform() { response ->
        response.clusterSubnetGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClusterTracksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClusterTracksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterTracksResponse]
 */
fun RedshiftClient.describeClusterTracksPaginated(initialRequest: DescribeClusterTracksRequest): Flow<DescribeClusterTracksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeClusterTracksPaginated.describeClusterTracks(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClusterTracksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterTracksResponse]
 */
fun RedshiftClient.describeClusterTracksPaginated(block: DescribeClusterTracksRequest.Builder.() -> Unit): Flow<DescribeClusterTracksResponse> =
    describeClusterTracksPaginated(DescribeClusterTracksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClusterTracksPaginated]
 * to access the nested member [MaintenanceTrack]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MaintenanceTrack]
 */
@JvmName("describeClusterTracksResponseMaintenanceTrack")
fun Flow<DescribeClusterTracksResponse>.maintenanceTracks(): Flow<MaintenanceTrack> =
    transform() { response ->
        response.maintenanceTracks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClusterVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClusterVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterVersionsResponse]
 */
fun RedshiftClient.describeClusterVersionsPaginated(initialRequest: DescribeClusterVersionsRequest): Flow<DescribeClusterVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeClusterVersionsPaginated.describeClusterVersions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClusterVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterVersionsResponse]
 */
fun RedshiftClient.describeClusterVersionsPaginated(block: DescribeClusterVersionsRequest.Builder.() -> Unit): Flow<DescribeClusterVersionsResponse> =
    describeClusterVersionsPaginated(DescribeClusterVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClusterVersionsPaginated]
 * to access the nested member [ClusterVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterVersion]
 */
@JvmName("describeClusterVersionsResponseClusterVersion")
fun Flow<DescribeClusterVersionsResponse>.clusterVersions(): Flow<ClusterVersion> =
    transform() { response ->
        response.clusterVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDataSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDataSharesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataSharesResponse]
 */
fun RedshiftClient.describeDataSharesPaginated(initialRequest: DescribeDataSharesRequest): Flow<DescribeDataSharesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDataSharesPaginated.describeDataShares(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDataSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataSharesResponse]
 */
fun RedshiftClient.describeDataSharesPaginated(block: DescribeDataSharesRequest.Builder.() -> Unit): Flow<DescribeDataSharesResponse> =
    describeDataSharesPaginated(DescribeDataSharesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDataSharesPaginated]
 * to access the nested member [DataShare]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataShare]
 */
@JvmName("describeDataSharesResponseDataShare")
fun Flow<DescribeDataSharesResponse>.dataShares(): Flow<DataShare> =
    transform() { response ->
        response.dataShares?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDataSharesForConsumerResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDataSharesForConsumerRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataSharesForConsumerResponse]
 */
fun RedshiftClient.describeDataSharesForConsumerPaginated(initialRequest: DescribeDataSharesForConsumerRequest): Flow<DescribeDataSharesForConsumerResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDataSharesForConsumerPaginated.describeDataSharesForConsumer(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDataSharesForConsumerResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataSharesForConsumerResponse]
 */
fun RedshiftClient.describeDataSharesForConsumerPaginated(block: DescribeDataSharesForConsumerRequest.Builder.() -> Unit): Flow<DescribeDataSharesForConsumerResponse> =
    describeDataSharesForConsumerPaginated(DescribeDataSharesForConsumerRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDataSharesForConsumerPaginated]
 * to access the nested member [DataShare]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataShare]
 */
@JvmName("describeDataSharesForConsumerResponseDataShare")
fun Flow<DescribeDataSharesForConsumerResponse>.dataShares(): Flow<DataShare> =
    transform() { response ->
        response.dataShares?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDataSharesForProducerResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDataSharesForProducerRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataSharesForProducerResponse]
 */
fun RedshiftClient.describeDataSharesForProducerPaginated(initialRequest: DescribeDataSharesForProducerRequest): Flow<DescribeDataSharesForProducerResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDataSharesForProducerPaginated.describeDataSharesForProducer(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDataSharesForProducerResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataSharesForProducerResponse]
 */
fun RedshiftClient.describeDataSharesForProducerPaginated(block: DescribeDataSharesForProducerRequest.Builder.() -> Unit): Flow<DescribeDataSharesForProducerResponse> =
    describeDataSharesForProducerPaginated(DescribeDataSharesForProducerRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDataSharesForProducerPaginated]
 * to access the nested member [DataShare]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataShare]
 */
@JvmName("describeDataSharesForProducerResponseDataShare")
fun Flow<DescribeDataSharesForProducerResponse>.dataShares(): Flow<DataShare> =
    transform() { response ->
        response.dataShares?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDefaultClusterParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDefaultClusterParametersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDefaultClusterParametersResponse]
 */
fun RedshiftClient.describeDefaultClusterParametersPaginated(initialRequest: DescribeDefaultClusterParametersRequest): Flow<DescribeDefaultClusterParametersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDefaultClusterParametersPaginated.describeDefaultClusterParameters(req)
            isFirstPage = false
            cursor = result.defaultClusterParameters?.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDefaultClusterParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDefaultClusterParametersResponse]
 */
fun RedshiftClient.describeDefaultClusterParametersPaginated(block: DescribeDefaultClusterParametersRequest.Builder.() -> Unit): Flow<DescribeDefaultClusterParametersResponse> =
    describeDefaultClusterParametersPaginated(DescribeDefaultClusterParametersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDefaultClusterParametersPaginated]
 * to access the nested member [Parameter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Parameter]
 */
@JvmName("describeDefaultClusterParametersResponseParameter")
fun Flow<DescribeDefaultClusterParametersResponse>.parameters(): Flow<Parameter> =
    transform() { response ->
        response.defaultClusterParameters?.parameters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEndpointAccessResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEndpointAccessRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEndpointAccessResponse]
 */
fun RedshiftClient.describeEndpointAccessPaginated(initialRequest: DescribeEndpointAccessRequest): Flow<DescribeEndpointAccessResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEndpointAccessPaginated.describeEndpointAccess(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEndpointAccessResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEndpointAccessResponse]
 */
fun RedshiftClient.describeEndpointAccessPaginated(block: DescribeEndpointAccessRequest.Builder.() -> Unit): Flow<DescribeEndpointAccessResponse> =
    describeEndpointAccessPaginated(DescribeEndpointAccessRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEndpointAccessPaginated]
 * to access the nested member [EndpointAccess]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EndpointAccess]
 */
@JvmName("describeEndpointAccessResponseEndpointAccess")
fun Flow<DescribeEndpointAccessResponse>.endpointAccessList(): Flow<EndpointAccess> =
    transform() { response ->
        response.endpointAccessList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEndpointAuthorizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEndpointAuthorizationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEndpointAuthorizationResponse]
 */
fun RedshiftClient.describeEndpointAuthorizationPaginated(initialRequest: DescribeEndpointAuthorizationRequest): Flow<DescribeEndpointAuthorizationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEndpointAuthorizationPaginated.describeEndpointAuthorization(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEndpointAuthorizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEndpointAuthorizationResponse]
 */
fun RedshiftClient.describeEndpointAuthorizationPaginated(block: DescribeEndpointAuthorizationRequest.Builder.() -> Unit): Flow<DescribeEndpointAuthorizationResponse> =
    describeEndpointAuthorizationPaginated(DescribeEndpointAuthorizationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEndpointAuthorizationPaginated]
 * to access the nested member [EndpointAuthorization]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EndpointAuthorization]
 */
@JvmName("describeEndpointAuthorizationResponseEndpointAuthorization")
fun Flow<DescribeEndpointAuthorizationResponse>.endpointAuthorizationList(): Flow<EndpointAuthorization> =
    transform() { response ->
        response.endpointAuthorizationList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
fun RedshiftClient.describeEventsPaginated(initialRequest: DescribeEventsRequest): Flow<DescribeEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEventsPaginated.describeEvents(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
fun RedshiftClient.describeEventsPaginated(block: DescribeEventsRequest.Builder.() -> Unit): Flow<DescribeEventsResponse> =
    describeEventsPaginated(DescribeEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("describeEventsResponseEvent")
fun Flow<DescribeEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventSubscriptionsResponse]
 */
fun RedshiftClient.describeEventSubscriptionsPaginated(initialRequest: DescribeEventSubscriptionsRequest): Flow<DescribeEventSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEventSubscriptionsPaginated.describeEventSubscriptions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventSubscriptionsResponse]
 */
fun RedshiftClient.describeEventSubscriptionsPaginated(block: DescribeEventSubscriptionsRequest.Builder.() -> Unit): Flow<DescribeEventSubscriptionsResponse> =
    describeEventSubscriptionsPaginated(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventSubscriptionsPaginated]
 * to access the nested member [EventSubscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventSubscription]
 */
@JvmName("describeEventSubscriptionsResponseEventSubscription")
fun Flow<DescribeEventSubscriptionsResponse>.eventSubscriptionsList(): Flow<EventSubscription> =
    transform() { response ->
        response.eventSubscriptionsList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeHsmClientCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeHsmClientCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeHsmClientCertificatesResponse]
 */
fun RedshiftClient.describeHsmClientCertificatesPaginated(initialRequest: DescribeHsmClientCertificatesRequest): Flow<DescribeHsmClientCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeHsmClientCertificatesPaginated.describeHsmClientCertificates(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeHsmClientCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeHsmClientCertificatesResponse]
 */
fun RedshiftClient.describeHsmClientCertificatesPaginated(block: DescribeHsmClientCertificatesRequest.Builder.() -> Unit): Flow<DescribeHsmClientCertificatesResponse> =
    describeHsmClientCertificatesPaginated(DescribeHsmClientCertificatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeHsmClientCertificatesPaginated]
 * to access the nested member [HsmClientCertificate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HsmClientCertificate]
 */
@JvmName("describeHsmClientCertificatesResponseHsmClientCertificate")
fun Flow<DescribeHsmClientCertificatesResponse>.hsmClientCertificates(): Flow<HsmClientCertificate> =
    transform() { response ->
        response.hsmClientCertificates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeHsmConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeHsmConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeHsmConfigurationsResponse]
 */
fun RedshiftClient.describeHsmConfigurationsPaginated(initialRequest: DescribeHsmConfigurationsRequest): Flow<DescribeHsmConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeHsmConfigurationsPaginated.describeHsmConfigurations(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeHsmConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeHsmConfigurationsResponse]
 */
fun RedshiftClient.describeHsmConfigurationsPaginated(block: DescribeHsmConfigurationsRequest.Builder.() -> Unit): Flow<DescribeHsmConfigurationsResponse> =
    describeHsmConfigurationsPaginated(DescribeHsmConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeHsmConfigurationsPaginated]
 * to access the nested member [HsmConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HsmConfiguration]
 */
@JvmName("describeHsmConfigurationsResponseHsmConfiguration")
fun Flow<DescribeHsmConfigurationsResponse>.hsmConfigurations(): Flow<HsmConfiguration> =
    transform() { response ->
        response.hsmConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeNodeConfigurationOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeNodeConfigurationOptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNodeConfigurationOptionsResponse]
 */
fun RedshiftClient.describeNodeConfigurationOptionsPaginated(initialRequest: DescribeNodeConfigurationOptionsRequest): Flow<DescribeNodeConfigurationOptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeNodeConfigurationOptionsPaginated.describeNodeConfigurationOptions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeNodeConfigurationOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNodeConfigurationOptionsResponse]
 */
fun RedshiftClient.describeNodeConfigurationOptionsPaginated(block: DescribeNodeConfigurationOptionsRequest.Builder.() -> Unit): Flow<DescribeNodeConfigurationOptionsResponse> =
    describeNodeConfigurationOptionsPaginated(DescribeNodeConfigurationOptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeNodeConfigurationOptionsPaginated]
 * to access the nested member [NodeConfigurationOption]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NodeConfigurationOption]
 */
@JvmName("describeNodeConfigurationOptionsResponseNodeConfigurationOption")
fun Flow<DescribeNodeConfigurationOptionsResponse>.nodeConfigurationOptionList(): Flow<NodeConfigurationOption> =
    transform() { response ->
        response.nodeConfigurationOptionList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeOrderableClusterOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeOrderableClusterOptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOrderableClusterOptionsResponse]
 */
fun RedshiftClient.describeOrderableClusterOptionsPaginated(initialRequest: DescribeOrderableClusterOptionsRequest): Flow<DescribeOrderableClusterOptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeOrderableClusterOptionsPaginated.describeOrderableClusterOptions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeOrderableClusterOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOrderableClusterOptionsResponse]
 */
fun RedshiftClient.describeOrderableClusterOptionsPaginated(block: DescribeOrderableClusterOptionsRequest.Builder.() -> Unit): Flow<DescribeOrderableClusterOptionsResponse> =
    describeOrderableClusterOptionsPaginated(DescribeOrderableClusterOptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeOrderableClusterOptionsPaginated]
 * to access the nested member [OrderableClusterOption]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OrderableClusterOption]
 */
@JvmName("describeOrderableClusterOptionsResponseOrderableClusterOption")
fun Flow<DescribeOrderableClusterOptionsResponse>.orderableClusterOptions(): Flow<OrderableClusterOption> =
    transform() { response ->
        response.orderableClusterOptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeReservedNodeExchangeStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedNodeExchangeStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodeExchangeStatusResponse]
 */
fun RedshiftClient.describeReservedNodeExchangeStatusPaginated(initialRequest: DescribeReservedNodeExchangeStatusRequest): Flow<DescribeReservedNodeExchangeStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeReservedNodeExchangeStatusPaginated.describeReservedNodeExchangeStatus(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedNodeExchangeStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodeExchangeStatusResponse]
 */
fun RedshiftClient.describeReservedNodeExchangeStatusPaginated(block: DescribeReservedNodeExchangeStatusRequest.Builder.() -> Unit): Flow<DescribeReservedNodeExchangeStatusResponse> =
    describeReservedNodeExchangeStatusPaginated(DescribeReservedNodeExchangeStatusRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeReservedNodeExchangeStatusPaginated]
 * to access the nested member [ReservedNodeExchangeStatus]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReservedNodeExchangeStatus]
 */
@JvmName("describeReservedNodeExchangeStatusResponseReservedNodeExchangeStatus")
fun Flow<DescribeReservedNodeExchangeStatusResponse>.reservedNodeExchangeStatusDetails(): Flow<ReservedNodeExchangeStatus> =
    transform() { response ->
        response.reservedNodeExchangeStatusDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeReservedNodeOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedNodeOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodeOfferingsResponse]
 */
fun RedshiftClient.describeReservedNodeOfferingsPaginated(initialRequest: DescribeReservedNodeOfferingsRequest): Flow<DescribeReservedNodeOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeReservedNodeOfferingsPaginated.describeReservedNodeOfferings(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedNodeOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodeOfferingsResponse]
 */
fun RedshiftClient.describeReservedNodeOfferingsPaginated(block: DescribeReservedNodeOfferingsRequest.Builder.() -> Unit): Flow<DescribeReservedNodeOfferingsResponse> =
    describeReservedNodeOfferingsPaginated(DescribeReservedNodeOfferingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeReservedNodeOfferingsPaginated]
 * to access the nested member [ReservedNodeOffering]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReservedNodeOffering]
 */
@JvmName("describeReservedNodeOfferingsResponseReservedNodeOffering")
fun Flow<DescribeReservedNodeOfferingsResponse>.reservedNodeOfferings(): Flow<ReservedNodeOffering> =
    transform() { response ->
        response.reservedNodeOfferings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeReservedNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedNodesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodesResponse]
 */
fun RedshiftClient.describeReservedNodesPaginated(initialRequest: DescribeReservedNodesRequest): Flow<DescribeReservedNodesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeReservedNodesPaginated.describeReservedNodes(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodesResponse]
 */
fun RedshiftClient.describeReservedNodesPaginated(block: DescribeReservedNodesRequest.Builder.() -> Unit): Flow<DescribeReservedNodesResponse> =
    describeReservedNodesPaginated(DescribeReservedNodesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeReservedNodesPaginated]
 * to access the nested member [ReservedNode]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReservedNode]
 */
@JvmName("describeReservedNodesResponseReservedNode")
fun Flow<DescribeReservedNodesResponse>.reservedNodes(): Flow<ReservedNode> =
    transform() { response ->
        response.reservedNodes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScheduledActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduledActionsResponse]
 */
fun RedshiftClient.describeScheduledActionsPaginated(initialRequest: DescribeScheduledActionsRequest): Flow<DescribeScheduledActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeScheduledActionsPaginated.describeScheduledActions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduledActionsResponse]
 */
fun RedshiftClient.describeScheduledActionsPaginated(block: DescribeScheduledActionsRequest.Builder.() -> Unit): Flow<DescribeScheduledActionsResponse> =
    describeScheduledActionsPaginated(DescribeScheduledActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScheduledActionsPaginated]
 * to access the nested member [ScheduledAction]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScheduledAction]
 */
@JvmName("describeScheduledActionsResponseScheduledAction")
fun Flow<DescribeScheduledActionsResponse>.scheduledActions(): Flow<ScheduledAction> =
    transform() { response ->
        response.scheduledActions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeSnapshotCopyGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSnapshotCopyGrantsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotCopyGrantsResponse]
 */
fun RedshiftClient.describeSnapshotCopyGrantsPaginated(initialRequest: DescribeSnapshotCopyGrantsRequest): Flow<DescribeSnapshotCopyGrantsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeSnapshotCopyGrantsPaginated.describeSnapshotCopyGrants(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSnapshotCopyGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotCopyGrantsResponse]
 */
fun RedshiftClient.describeSnapshotCopyGrantsPaginated(block: DescribeSnapshotCopyGrantsRequest.Builder.() -> Unit): Flow<DescribeSnapshotCopyGrantsResponse> =
    describeSnapshotCopyGrantsPaginated(DescribeSnapshotCopyGrantsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSnapshotCopyGrantsPaginated]
 * to access the nested member [SnapshotCopyGrant]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SnapshotCopyGrant]
 */
@JvmName("describeSnapshotCopyGrantsResponseSnapshotCopyGrant")
fun Flow<DescribeSnapshotCopyGrantsResponse>.snapshotCopyGrants(): Flow<SnapshotCopyGrant> =
    transform() { response ->
        response.snapshotCopyGrants?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeSnapshotSchedulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSnapshotSchedulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotSchedulesResponse]
 */
fun RedshiftClient.describeSnapshotSchedulesPaginated(initialRequest: DescribeSnapshotSchedulesRequest): Flow<DescribeSnapshotSchedulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeSnapshotSchedulesPaginated.describeSnapshotSchedules(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSnapshotSchedulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotSchedulesResponse]
 */
fun RedshiftClient.describeSnapshotSchedulesPaginated(block: DescribeSnapshotSchedulesRequest.Builder.() -> Unit): Flow<DescribeSnapshotSchedulesResponse> =
    describeSnapshotSchedulesPaginated(DescribeSnapshotSchedulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSnapshotSchedulesPaginated]
 * to access the nested member [SnapshotSchedule]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SnapshotSchedule]
 */
@JvmName("describeSnapshotSchedulesResponseSnapshotSchedule")
fun Flow<DescribeSnapshotSchedulesResponse>.snapshotSchedules(): Flow<SnapshotSchedule> =
    transform() { response ->
        response.snapshotSchedules?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTableRestoreStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTableRestoreStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTableRestoreStatusResponse]
 */
fun RedshiftClient.describeTableRestoreStatusPaginated(initialRequest: DescribeTableRestoreStatusRequest): Flow<DescribeTableRestoreStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTableRestoreStatusPaginated.describeTableRestoreStatus(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTableRestoreStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTableRestoreStatusResponse]
 */
fun RedshiftClient.describeTableRestoreStatusPaginated(block: DescribeTableRestoreStatusRequest.Builder.() -> Unit): Flow<DescribeTableRestoreStatusResponse> =
    describeTableRestoreStatusPaginated(DescribeTableRestoreStatusRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTableRestoreStatusPaginated]
 * to access the nested member [TableRestoreStatus]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TableRestoreStatus]
 */
@JvmName("describeTableRestoreStatusResponseTableRestoreStatus")
fun Flow<DescribeTableRestoreStatusResponse>.tableRestoreStatusDetails(): Flow<TableRestoreStatus> =
    transform() { response ->
        response.tableRestoreStatusDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
fun RedshiftClient.describeTagsPaginated(initialRequest: DescribeTagsRequest): Flow<DescribeTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTagsPaginated.describeTags(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
fun RedshiftClient.describeTagsPaginated(block: DescribeTagsRequest.Builder.() -> Unit): Flow<DescribeTagsResponse> =
    describeTagsPaginated(DescribeTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTagsPaginated]
 * to access the nested member [TaggedResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TaggedResource]
 */
@JvmName("describeTagsResponseTaggedResource")
fun Flow<DescribeTagsResponse>.taggedResources(): Flow<TaggedResource> =
    transform() { response ->
        response.taggedResources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeUsageLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeUsageLimitsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUsageLimitsResponse]
 */
fun RedshiftClient.describeUsageLimitsPaginated(initialRequest: DescribeUsageLimitsRequest): Flow<DescribeUsageLimitsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeUsageLimitsPaginated.describeUsageLimits(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeUsageLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUsageLimitsResponse]
 */
fun RedshiftClient.describeUsageLimitsPaginated(block: DescribeUsageLimitsRequest.Builder.() -> Unit): Flow<DescribeUsageLimitsResponse> =
    describeUsageLimitsPaginated(DescribeUsageLimitsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeUsageLimitsPaginated]
 * to access the nested member [UsageLimit]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UsageLimit]
 */
@JvmName("describeUsageLimitsResponseUsageLimit")
fun Flow<DescribeUsageLimitsResponse>.usageLimits(): Flow<UsageLimit> =
    transform() { response ->
        response.usageLimits?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetReservedNodeExchangeConfigurationOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetReservedNodeExchangeConfigurationOptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReservedNodeExchangeConfigurationOptionsResponse]
 */
fun RedshiftClient.getReservedNodeExchangeConfigurationOptionsPaginated(initialRequest: GetReservedNodeExchangeConfigurationOptionsRequest): Flow<GetReservedNodeExchangeConfigurationOptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@getReservedNodeExchangeConfigurationOptionsPaginated.getReservedNodeExchangeConfigurationOptions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [GetReservedNodeExchangeConfigurationOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReservedNodeExchangeConfigurationOptionsResponse]
 */
fun RedshiftClient.getReservedNodeExchangeConfigurationOptionsPaginated(block: GetReservedNodeExchangeConfigurationOptionsRequest.Builder.() -> Unit): Flow<GetReservedNodeExchangeConfigurationOptionsResponse> =
    getReservedNodeExchangeConfigurationOptionsPaginated(GetReservedNodeExchangeConfigurationOptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getReservedNodeExchangeConfigurationOptionsPaginated]
 * to access the nested member [ReservedNodeConfigurationOption]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReservedNodeConfigurationOption]
 */
@JvmName("getReservedNodeExchangeConfigurationOptionsResponseReservedNodeConfigurationOption")
fun Flow<GetReservedNodeExchangeConfigurationOptionsResponse>.reservedNodeConfigurationOptionList(): Flow<ReservedNodeConfigurationOption> =
    transform() { response ->
        response.reservedNodeConfigurationOptionList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetReservedNodeExchangeOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetReservedNodeExchangeOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReservedNodeExchangeOfferingsResponse]
 */
fun RedshiftClient.getReservedNodeExchangeOfferingsPaginated(initialRequest: GetReservedNodeExchangeOfferingsRequest): Flow<GetReservedNodeExchangeOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@getReservedNodeExchangeOfferingsPaginated.getReservedNodeExchangeOfferings(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [GetReservedNodeExchangeOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReservedNodeExchangeOfferingsResponse]
 */
fun RedshiftClient.getReservedNodeExchangeOfferingsPaginated(block: GetReservedNodeExchangeOfferingsRequest.Builder.() -> Unit): Flow<GetReservedNodeExchangeOfferingsResponse> =
    getReservedNodeExchangeOfferingsPaginated(GetReservedNodeExchangeOfferingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getReservedNodeExchangeOfferingsPaginated]
 * to access the nested member [ReservedNodeOffering]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReservedNodeOffering]
 */
@JvmName("getReservedNodeExchangeOfferingsResponseReservedNodeOffering")
fun Flow<GetReservedNodeExchangeOfferingsResponse>.reservedNodeOfferings(): Flow<ReservedNodeOffering> =
    transform() { response ->
        response.reservedNodeOfferings?.forEach {
            emit(it)
        }
    }
