// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
public class CreateEventSubscriptionRequest private constructor(builder: Builder) {
    /**
     * A boolean value; set to `true` to activate the subscription, and set to `false` to create the subscription but not activate it.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Specifies the Amazon Redshift event categories to be published by the event notification subscription.
     *
     * Values: configuration, management, monitoring, security, pending
     */
    public val eventCategories: List<String>? = builder.eventCategories
    /**
     * Specifies the Amazon Redshift event severity to be published by the event notification subscription.
     *
     * Values: ERROR, INFO
     */
    public val severity: kotlin.String? = builder.severity
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.
     *
     * Example: my-cluster-1, my-cluster-2
     *
     * Example: my-snapshot-20131010
     */
    public val sourceIds: List<String>? = builder.sourceIds
    /**
     * The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.
     *
     * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.
     */
    public val sourceType: kotlin.String? = builder.sourceType
    /**
     * The name of the event subscription to be created.
     *
     * Constraints:
     * + Cannot be null, empty, or blank.
     * + Must contain from 1 to 255 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val subscriptionName: kotlin.String? = builder.subscriptionName
    /**
     * A list of tag instances.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CreateEventSubscriptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEventSubscriptionRequest(")
        append("enabled=$enabled,")
        append("eventCategories=$eventCategories,")
        append("severity=$severity,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIds=$sourceIds,")
        append("sourceType=$sourceType,")
        append("subscriptionName=$subscriptionName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIds?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEventSubscriptionRequest

        if (enabled != other.enabled) return false
        if (eventCategories != other.eventCategories) return false
        if (severity != other.severity) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIds != other.sourceIds) return false
        if (sourceType != other.sourceType) return false
        if (subscriptionName != other.subscriptionName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CreateEventSubscriptionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A boolean value; set to `true` to activate the subscription, and set to `false` to create the subscription but not activate it.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Specifies the Amazon Redshift event categories to be published by the event notification subscription.
         *
         * Values: configuration, management, monitoring, security, pending
         */
        public var eventCategories: List<String>? = null
        /**
         * Specifies the Amazon Redshift event severity to be published by the event notification subscription.
         *
         * Values: ERROR, INFO
         */
        public var severity: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.
         *
         * Example: my-cluster-1, my-cluster-2
         *
         * Example: my-snapshot-20131010
         */
        public var sourceIds: List<String>? = null
        /**
         * The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.
         *
         * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.
         */
        public var sourceType: kotlin.String? = null
        /**
         * The name of the event subscription to be created.
         *
         * Constraints:
         * + Cannot be null, empty, or blank.
         * + Must contain from 1 to 255 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var subscriptionName: kotlin.String? = null
        /**
         * A list of tag instances.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CreateEventSubscriptionRequest) : this() {
            this.enabled = x.enabled
            this.eventCategories = x.eventCategories
            this.severity = x.severity
            this.snsTopicArn = x.snsTopicArn
            this.sourceIds = x.sourceIds
            this.sourceType = x.sourceType
            this.subscriptionName = x.subscriptionName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CreateEventSubscriptionRequest = CreateEventSubscriptionRequest(this)
    }
}
