// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes a usage limit object for a cluster.
 */
public class UsageLimit private constructor(builder: Builder) {
    /**
     * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
     */
    public val amount: kotlin.Long = builder.amount
    /**
     * The action that Amazon Redshift takes when the limit is reached. Possible values are:
     * + **log** - To log an event in a system table. The default is log.
     * + **emit-metric** - To emit CloudWatch metrics.
     * + **disable** - To disable the feature until the next usage period begins.
     */
    public val breachAction: aws.sdk.kotlin.services.redshift.model.UsageLimitBreachAction? = builder.breachAction
    /**
     * The identifier of the cluster with a usage limit.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The Amazon Redshift feature to which the limit applies.
     */
    public val featureType: aws.sdk.kotlin.services.redshift.model.UsageLimitFeatureType? = builder.featureType
    /**
     * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
     */
    public val limitType: aws.sdk.kotlin.services.redshift.model.UsageLimitLimitType? = builder.limitType
    /**
     * The time period that the amount applies to. A `weekly` period begins on Sunday. The default is `monthly`.
     */
    public val period: aws.sdk.kotlin.services.redshift.model.UsageLimitPeriod? = builder.period
    /**
     * A list of tag instances.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The identifier of the usage limit.
     */
    public val usageLimitId: kotlin.String? = builder.usageLimitId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.UsageLimit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsageLimit(")
        append("amount=$amount,")
        append("breachAction=$breachAction,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("featureType=$featureType,")
        append("limitType=$limitType,")
        append("period=$period,")
        append("tags=$tags,")
        append("usageLimitId=$usageLimitId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amount.hashCode()
        result = 31 * result + (breachAction?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (featureType?.hashCode() ?: 0)
        result = 31 * result + (limitType?.hashCode() ?: 0)
        result = 31 * result + (period?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (usageLimitId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsageLimit

        if (amount != other.amount) return false
        if (breachAction != other.breachAction) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (featureType != other.featureType) return false
        if (limitType != other.limitType) return false
        if (period != other.period) return false
        if (tags != other.tags) return false
        if (usageLimitId != other.usageLimitId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.UsageLimit = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
         */
        public var amount: kotlin.Long = 0L
        /**
         * The action that Amazon Redshift takes when the limit is reached. Possible values are:
         * + **log** - To log an event in a system table. The default is log.
         * + **emit-metric** - To emit CloudWatch metrics.
         * + **disable** - To disable the feature until the next usage period begins.
         */
        public var breachAction: aws.sdk.kotlin.services.redshift.model.UsageLimitBreachAction? = null
        /**
         * The identifier of the cluster with a usage limit.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Redshift feature to which the limit applies.
         */
        public var featureType: aws.sdk.kotlin.services.redshift.model.UsageLimitFeatureType? = null
        /**
         * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
         */
        public var limitType: aws.sdk.kotlin.services.redshift.model.UsageLimitLimitType? = null
        /**
         * The time period that the amount applies to. A `weekly` period begins on Sunday. The default is `monthly`.
         */
        public var period: aws.sdk.kotlin.services.redshift.model.UsageLimitPeriod? = null
        /**
         * A list of tag instances.
         */
        public var tags: List<Tag>? = null
        /**
         * The identifier of the usage limit.
         */
        public var usageLimitId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.UsageLimit) : this() {
            this.amount = x.amount
            this.breachAction = x.breachAction
            this.clusterIdentifier = x.clusterIdentifier
            this.featureType = x.featureType
            this.limitType = x.limitType
            this.period = x.period
            this.tags = x.tags
            this.usageLimitId = x.usageLimitId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.UsageLimit = UsageLimit(this)
    }
}
