// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.DeleteSnapshotScheduleResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteSnapshotScheduleOperationDeserializer: HttpDeserialize<DeleteSnapshotScheduleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteSnapshotScheduleResponse {
        if (!response.status.isSuccess()) {
            throwDeleteSnapshotScheduleError(context, response)
        }
        val builder = DeleteSnapshotScheduleResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteSnapshotScheduleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidClusterSnapshotScheduleState" -> InvalidClusterSnapshotScheduleStateFaultDeserializer().deserialize(context, wrappedResponse)
        "SnapshotScheduleNotFound" -> SnapshotScheduleNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
