// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.Cluster
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.RotateEncryptionKeyResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class RotateEncryptionKeyOperationDeserializer: HttpDeserialize<RotateEncryptionKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RotateEncryptionKeyResponse {
        if (!response.status.isSuccess()) {
            throwRotateEncryptionKeyError(context, response)
        }
        val builder = RotateEncryptionKeyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRotateEncryptionKeyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRotateEncryptionKeyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRotateEncryptionKeyOperationBody(builder: RotateEncryptionKeyResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RotateEncryptionKeyResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("RotateEncryptionKeyResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap RotateEncryptionKey response")
    }
    // end unwrap response wrapper

    val CLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Cluster"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("RotateEncryptionKeyResult"))
        field(CLUSTER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTER_DESCRIPTOR.index -> builder.cluster = deserializeClusterDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
