// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.UpdatePartnerStatusResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class UpdatePartnerStatusOperationDeserializer: HttpDeserialize<UpdatePartnerStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdatePartnerStatusResponse {
        if (!response.status.isSuccess()) {
            throwUpdatePartnerStatusError(context, response)
        }
        val builder = UpdatePartnerStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdatePartnerStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdatePartnerStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "PartnerNotFound" -> PartnerNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedPartnerIntegration" -> UnauthorizedPartnerIntegrationFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdatePartnerStatusOperationBody(builder: UpdatePartnerStatusResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("UpdatePartnerStatusResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("UpdatePartnerStatusResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap UpdatePartnerStatus response")
    }
    // end unwrap response wrapper

    val DATABASENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DatabaseName"))
    val PARTNERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PartnerName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("UpdatePartnerStatusResult"))
        field(DATABASENAME_DESCRIPTOR)
        field(PARTNERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATABASENAME_DESCRIPTOR.index -> builder.databaseName = deserializeString()
                PARTNERNAME_DESCRIPTOR.index -> builder.partnerName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
