// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



class BatchExecuteStatementRequest private constructor(builder: Builder) {
    /**
     * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
     */
    val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
     */
    val database: kotlin.String? = builder.database
    /**
     * The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials.
     */
    val dbUser: kotlin.String? = builder.dbUser
    /**
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * One or more SQL statements to run.
     */
    val sqls: List<String>? = builder.sqls
    /**
     * The name of the SQL statements. You can name the SQL statements when you create them to identify the query.
     */
    val statementName: kotlin.String? = builder.statementName
    /**
     * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run.
     */
    val withEvent: kotlin.Boolean? = builder.withEvent

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftdata.model.BatchExecuteStatementRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchExecuteStatementRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("secretArn=$secretArn,")
        append("sqls=$sqls,")
        append("statementName=$statementName,")
        append("withEvent=$withEvent)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (sqls?.hashCode() ?: 0)
        result = 31 * result + (statementName?.hashCode() ?: 0)
        result = 31 * result + (withEvent?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchExecuteStatementRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (secretArn != other.secretArn) return false
        if (sqls != other.sqls) return false
        if (statementName != other.statementName) return false
        if (withEvent != other.withEvent) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftdata.model.BatchExecuteStatementRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
         */
        var clusterIdentifier: kotlin.String? = null
        /**
         * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        var database: kotlin.String? = null
        /**
         * The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials.
         */
        var dbUser: kotlin.String? = null
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        var secretArn: kotlin.String? = null
        /**
         * One or more SQL statements to run.
         */
        var sqls: List<String>? = null
        /**
         * The name of the SQL statements. You can name the SQL statements when you create them to identify the query.
         */
        var statementName: kotlin.String? = null
        /**
         * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run.
         */
        var withEvent: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftdata.model.BatchExecuteStatementRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.database = x.database
            this.dbUser = x.dbUser
            this.secretArn = x.secretArn
            this.sqls = x.sqls
            this.statementName = x.statementName
            this.withEvent = x.withEvent
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftdata.model.BatchExecuteStatementRequest = BatchExecuteStatementRequest(this)
    }
}
