// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



class DescribeTableRequest private constructor(builder: Builder) {
    /**
     * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
     */
    val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * A database name. The connected database is specified when you connect with your authentication credentials.
     */
    val connectedDatabase: kotlin.String? = builder.connectedDatabase
    /**
     * The name of the database that contains the tables to be described. If `ConnectedDatabase` is not specified, this is also the database to connect to with your authentication credentials.
     */
    val database: kotlin.String? = builder.database
    /**
     * The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials.
     */
    val dbUser: kotlin.String? = builder.dbUser
    /**
     * The maximum number of tables to return in the response. If more tables exist than fit in one response, then `NextToken` is returned to page through the results.
     */
    val maxResults: kotlin.Int = builder.maxResults
    /**
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned.
     */
    val schema: kotlin.String? = builder.schema
    /**
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned
     */
    val table: kotlin.String? = builder.table

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftdata.model.DescribeTableRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTableRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("connectedDatabase=$connectedDatabase,")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("schema=$schema,")
        append("secretArn=$secretArn,")
        append("table=$table)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (connectedDatabase?.hashCode() ?: 0)
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (table?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTableRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (connectedDatabase != other.connectedDatabase) return false
        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (schema != other.schema) return false
        if (secretArn != other.secretArn) return false
        if (table != other.table) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftdata.model.DescribeTableRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
         */
        var clusterIdentifier: kotlin.String? = null
        /**
         * A database name. The connected database is specified when you connect with your authentication credentials.
         */
        var connectedDatabase: kotlin.String? = null
        /**
         * The name of the database that contains the tables to be described. If `ConnectedDatabase` is not specified, this is also the database to connect to with your authentication credentials.
         */
        var database: kotlin.String? = null
        /**
         * The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials.
         */
        var dbUser: kotlin.String? = null
        /**
         * The maximum number of tables to return in the response. If more tables exist than fit in one response, then `NextToken` is returned to page through the results.
         */
        var maxResults: kotlin.Int = 0
        /**
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
         */
        var nextToken: kotlin.String? = null
        /**
         * The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned.
         */
        var schema: kotlin.String? = null
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        var secretArn: kotlin.String? = null
        /**
         * The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned
         */
        var table: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftdata.model.DescribeTableRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.connectedDatabase = x.connectedDatabase
            this.database = x.database
            this.dbUser = x.dbUser
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.schema = x.schema
            this.secretArn = x.secretArn
            this.table = x.table
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftdata.model.DescribeTableRequest = DescribeTableRequest(this)
    }
}
