// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an SQL statement.
 */
class SubStatementData private constructor(builder: Builder) {
    /**
     * The date and time (UTC) the statement was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The amount of time in nanoseconds that the statement ran.
     */
    val duration: kotlin.Long = builder.duration
    /**
     * The error message from the cluster if the SQL statement encountered an error while running.
     */
    val error: kotlin.String? = builder.error
    /**
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for an empty result set.
     */
    val hasResultSet: kotlin.Boolean? = builder.hasResultSet
    /**
     * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, `d9b6c0c9-0747-4bf4-b142-e8883122f766:2` has a suffix of `:2` that indicates the second SQL statement of a batch query.
     */
    val id: kotlin.String? = builder.id
    /**
     * The SQL statement text.
     */
    val queryString: kotlin.String? = builder.queryString
    /**
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
     */
    val redshiftQueryId: kotlin.Long = builder.redshiftQueryId
    /**
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others. A `-1` indicates the value is null.
     */
    val resultRows: kotlin.Long = builder.resultRows
    /**
     * The size in bytes of the returned results. A `-1` indicates the value is null.
     */
    val resultSize: kotlin.Long = builder.resultSize
    /**
     * The status of the SQL statement. An example is the that the SQL statement finished.
     */
    val status: aws.sdk.kotlin.services.redshiftdata.model.StatementStatusString? = builder.status
    /**
     * The date and time (UTC) that the statement metadata was last updated.
     */
    val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftdata.model.SubStatementData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubStatementData(")
        append("createdAt=$createdAt,")
        append("duration=$duration,")
        append("error=$error,")
        append("hasResultSet=$hasResultSet,")
        append("id=$id,")
        append("queryString=$queryString,")
        append("redshiftQueryId=$redshiftQueryId,")
        append("resultRows=$resultRows,")
        append("resultSize=$resultSize,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (duration.hashCode())
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (hasResultSet?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (redshiftQueryId.hashCode())
        result = 31 * result + (resultRows.hashCode())
        result = 31 * result + (resultSize.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubStatementData

        if (createdAt != other.createdAt) return false
        if (duration != other.duration) return false
        if (error != other.error) return false
        if (hasResultSet != other.hasResultSet) return false
        if (id != other.id) return false
        if (queryString != other.queryString) return false
        if (redshiftQueryId != other.redshiftQueryId) return false
        if (resultRows != other.resultRows) return false
        if (resultSize != other.resultSize) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftdata.model.SubStatementData = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time (UTC) the statement was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The amount of time in nanoseconds that the statement ran.
         */
        var duration: kotlin.Long = 0L
        /**
         * The error message from the cluster if the SQL statement encountered an error while running.
         */
        var error: kotlin.String? = null
        /**
         * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for an empty result set.
         */
        var hasResultSet: kotlin.Boolean? = null
        /**
         * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, `d9b6c0c9-0747-4bf4-b142-e8883122f766:2` has a suffix of `:2` that indicates the second SQL statement of a batch query.
         */
        var id: kotlin.String? = null
        /**
         * The SQL statement text.
         */
        var queryString: kotlin.String? = null
        /**
         * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
         */
        var redshiftQueryId: kotlin.Long = 0L
        /**
         * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others. A `-1` indicates the value is null.
         */
        var resultRows: kotlin.Long = 0L
        /**
         * The size in bytes of the returned results. A `-1` indicates the value is null.
         */
        var resultSize: kotlin.Long = 0L
        /**
         * The status of the SQL statement. An example is the that the SQL statement finished.
         */
        var status: aws.sdk.kotlin.services.redshiftdata.model.StatementStatusString? = null
        /**
         * The date and time (UTC) that the statement metadata was last updated.
         */
        var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftdata.model.SubStatementData) : this() {
            this.createdAt = x.createdAt
            this.duration = x.duration
            this.error = x.error
            this.hasResultSet = x.hasResultSet
            this.id = x.id
            this.queryString = x.queryString
            this.redshiftQueryId = x.redshiftQueryId
            this.resultRows = x.resultRows
            this.resultSize = x.resultSize
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftdata.model.SubStatementData = SubStatementData(this)
    }
}
