// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.paginators

import aws.sdk.kotlin.services.redshiftdata.RedshiftDataClient
import aws.sdk.kotlin.services.redshiftdata.model.ColumnMetadata
import aws.sdk.kotlin.services.redshiftdata.model.DescribeTableRequest
import aws.sdk.kotlin.services.redshiftdata.model.DescribeTableResponse
import aws.sdk.kotlin.services.redshiftdata.model.Field
import aws.sdk.kotlin.services.redshiftdata.model.GetStatementResultRequest
import aws.sdk.kotlin.services.redshiftdata.model.GetStatementResultResponse
import aws.sdk.kotlin.services.redshiftdata.model.ListDatabasesRequest
import aws.sdk.kotlin.services.redshiftdata.model.ListDatabasesResponse
import aws.sdk.kotlin.services.redshiftdata.model.ListSchemasRequest
import aws.sdk.kotlin.services.redshiftdata.model.ListSchemasResponse
import aws.sdk.kotlin.services.redshiftdata.model.ListStatementsRequest
import aws.sdk.kotlin.services.redshiftdata.model.ListStatementsResponse
import aws.sdk.kotlin.services.redshiftdata.model.ListTablesRequest
import aws.sdk.kotlin.services.redshiftdata.model.ListTablesResponse
import aws.sdk.kotlin.services.redshiftdata.model.StatementData
import aws.sdk.kotlin.services.redshiftdata.model.TableMember
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeTableResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTableRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTableResponse]
 */
fun RedshiftDataClient.describeTablePaginated(initialRequest: DescribeTableRequest): Flow<DescribeTableResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeTablePaginated.describeTable(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTableResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTableResponse]
 */
fun RedshiftDataClient.describeTablePaginated(block: DescribeTableRequest.Builder.() -> Unit): Flow<DescribeTableResponse> =
    describeTablePaginated(DescribeTableRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTablePaginated]
 * to access the nested member [ColumnMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ColumnMetadata]
 */
@JvmName("describeTableResponseColumnMetadata")
fun Flow<DescribeTableResponse>.columnList(): Flow<ColumnMetadata> =
    transform() { response ->
        response.columnList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetStatementResultResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetStatementResultRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetStatementResultResponse]
 */
fun RedshiftDataClient.getStatementResultPaginated(initialRequest: GetStatementResultRequest): Flow<GetStatementResultResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getStatementResultPaginated.getStatementResult(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetStatementResultResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetStatementResultResponse]
 */
fun RedshiftDataClient.getStatementResultPaginated(block: GetStatementResultRequest.Builder.() -> Unit): Flow<GetStatementResultResponse> =
    getStatementResultPaginated(GetStatementResultRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getStatementResultPaginated]
 * to access the nested member [FieldList]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FieldList]
 */
@JvmName("getStatementResultResponseFieldList")
fun Flow<GetStatementResultResponse>.records(): Flow<List<Field>> =
    transform() { response ->
        response.records?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatabasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatabasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatabasesResponse]
 */
fun RedshiftDataClient.listDatabasesPaginated(initialRequest: ListDatabasesRequest): Flow<ListDatabasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatabasesPaginated.listDatabases(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatabasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatabasesResponse]
 */
fun RedshiftDataClient.listDatabasesPaginated(block: ListDatabasesRequest.Builder.() -> Unit): Flow<ListDatabasesResponse> =
    listDatabasesPaginated(ListDatabasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatabasesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listDatabasesResponseString")
fun Flow<ListDatabasesResponse>.databases(): Flow<String> =
    transform() { response ->
        response.databases?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSchemasRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemasResponse]
 */
fun RedshiftDataClient.listSchemasPaginated(initialRequest: ListSchemasRequest): Flow<ListSchemasResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSchemasPaginated.listSchemas(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemasResponse]
 */
fun RedshiftDataClient.listSchemasPaginated(block: ListSchemasRequest.Builder.() -> Unit): Flow<ListSchemasResponse> =
    listSchemasPaginated(ListSchemasRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSchemasPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listSchemasResponseString")
fun Flow<ListSchemasResponse>.schemas(): Flow<String> =
    transform() { response ->
        response.schemas?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStatementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStatementsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStatementsResponse]
 */
fun RedshiftDataClient.listStatementsPaginated(initialRequest: ListStatementsRequest): Flow<ListStatementsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStatementsPaginated.listStatements(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStatementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStatementsResponse]
 */
fun RedshiftDataClient.listStatementsPaginated(block: ListStatementsRequest.Builder.() -> Unit): Flow<ListStatementsResponse> =
    listStatementsPaginated(ListStatementsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStatementsPaginated]
 * to access the nested member [StatementData]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StatementData]
 */
@JvmName("listStatementsResponseStatementData")
fun Flow<ListStatementsResponse>.statements(): Flow<StatementData> =
    transform() { response ->
        response.statements?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTablesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
fun RedshiftDataClient.listTablesPaginated(initialRequest: ListTablesRequest): Flow<ListTablesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTablesPaginated.listTables(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
fun RedshiftDataClient.listTablesPaginated(block: ListTablesRequest.Builder.() -> Unit): Flow<ListTablesResponse> =
    listTablesPaginated(ListTablesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTablesPaginated]
 * to access the nested member [TableMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TableMember]
 */
@JvmName("listTablesResponseTableMember")
fun Flow<ListTablesResponse>.tables(): Flow<TableMember> =
    transform() { response ->
        response.tables?.forEach {
            emit(it)
        }
    }
