// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.redshiftdata.model.DescribeStatementResponse
import aws.sdk.kotlin.services.redshiftdata.model.RedshiftDataException
import aws.sdk.kotlin.services.redshiftdata.model.SqlParameter
import aws.sdk.kotlin.services.redshiftdata.model.StatusString
import aws.sdk.kotlin.services.redshiftdata.model.SubStatementData
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeStatementOperationDeserializer: HttpDeserialize<DescribeStatementResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeStatementResponse {
        if (!response.status.isSuccess()) {
            throwDescribeStatementError(context, response)
        }
        val builder = DescribeStatementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeStatementOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeStatementError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RedshiftDataException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStatementOperationBody(builder: DescribeStatementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterIdentifier"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DATABASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Database"))
    val DBUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DbUser"))
    val DURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("Duration"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Error"))
    val HASRESULTSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("HasResultSet"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val QUERYPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("QueryParameters"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryString"))
    val REDSHIFTPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("RedshiftPid"))
    val REDSHIFTQUERYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("RedshiftQueryId"))
    val RESULTROWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ResultRows"))
    val RESULTSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ResultSize"))
    val SECRETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val SUBSTATEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SubStatements"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DATABASE_DESCRIPTOR)
        field(DBUSER_DESCRIPTOR)
        field(DURATION_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(HASRESULTSET_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(QUERYPARAMETERS_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(REDSHIFTPID_DESCRIPTOR)
        field(REDSHIFTQUERYID_DESCRIPTOR)
        field(RESULTROWS_DESCRIPTOR)
        field(RESULTSIZE_DESCRIPTOR)
        field(SECRETARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUBSTATEMENTS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.clusterIdentifier = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATABASE_DESCRIPTOR.index -> builder.database = deserializeString()
                DBUSER_DESCRIPTOR.index -> builder.dbUser = deserializeString()
                DURATION_DESCRIPTOR.index -> builder.duration = deserializeLong()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeString()
                HASRESULTSET_DESCRIPTOR.index -> builder.hasResultSet = deserializeBoolean()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                QUERYPARAMETERS_DESCRIPTOR.index -> builder.queryParameters =
                    deserializer.deserializeList(QUERYPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<SqlParameter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSqlParameterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                REDSHIFTPID_DESCRIPTOR.index -> builder.redshiftPid = deserializeLong()
                REDSHIFTQUERYID_DESCRIPTOR.index -> builder.redshiftQueryId = deserializeLong()
                RESULTROWS_DESCRIPTOR.index -> builder.resultRows = deserializeLong()
                RESULTSIZE_DESCRIPTOR.index -> builder.resultSize = deserializeLong()
                SECRETARN_DESCRIPTOR.index -> builder.secretArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { StatusString.fromValue(it) }
                SUBSTATEMENTS_DESCRIPTOR.index -> builder.subStatements =
                    deserializer.deserializeList(SUBSTATEMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SubStatementData>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSubStatementDataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
