// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.redshiftdata.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.redshiftdata.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * You can use the Amazon Redshift Data API to run queries on Amazon Redshift tables. You can run SQL statements, which are committed if the statement succeeds.
 *
 * For more information about the Amazon Redshift Data API and CLI usage examples, see [Using the Amazon Redshift Data API](https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html) in the *Amazon Redshift Cluster Management Guide*.
 */
interface RedshiftDataClient : SdkClient {

    override val serviceName: String
        get() = "Redshift Data"
    /**
     * RedshiftDataClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): RedshiftDataClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRedshiftDataClient(config)
        }

        operator fun invoke(config: Config): RedshiftDataClient = DefaultRedshiftDataClient(config)

        /**
         * Construct a [RedshiftDataClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RedshiftDataClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRedshiftDataClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL). Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun batchExecuteStatement(input: BatchExecuteStatementRequest): BatchExecuteStatementResponse

    /**
     * Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL). Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun batchExecuteStatement(block: BatchExecuteStatementRequest.Builder.() -> Unit) = batchExecuteStatement(BatchExecuteStatementRequest.Builder().apply(block).build())

    /**
     * Cancels a running query. To be canceled, a query must be running.
     */
    suspend fun cancelStatement(input: CancelStatementRequest): CancelStatementResponse

    /**
     * Cancels a running query. To be canceled, a query must be running.
     */
    suspend fun cancelStatement(block: CancelStatementRequest.Builder.() -> Unit) = cancelStatement(CancelStatementRequest.Builder().apply(block).build())

    /**
     * Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The information includes when the query started, when it finished, the query status, the number of rows returned, and the SQL statement.
     */
    suspend fun describeStatement(input: DescribeStatementRequest): DescribeStatementResponse

    /**
     * Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The information includes when the query started, when it finished, the query status, the number of rows returned, and the SQL statement.
     */
    suspend fun describeStatement(block: DescribeStatementRequest.Builder.() -> Unit) = describeStatement(DescribeStatementRequest.Builder().apply(block).build())

    /**
     * Describes the detailed information about a table from metadata in the cluster. The information includes its columns. A token is returned to page through the column list. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun describeTable(input: DescribeTableRequest): DescribeTableResponse

    /**
     * Describes the detailed information about a table from metadata in the cluster. The information includes its columns. A token is returned to page through the column list. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun describeTable(block: DescribeTableRequest.Builder.() -> Unit) = describeTable(DescribeTableRequest.Builder().apply(block).build())

    /**
     * Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This statement must be a single SQL statement. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun executeStatement(input: ExecuteStatementRequest): ExecuteStatementResponse

    /**
     * Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This statement must be a single SQL statement. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun executeStatement(block: ExecuteStatementRequest.Builder.() -> Unit) = executeStatement(ExecuteStatementRequest.Builder().apply(block).build())

    /**
     * Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement results.
     */
    suspend fun getStatementResult(input: GetStatementResultRequest): GetStatementResultResponse

    /**
     * Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement results.
     */
    suspend fun getStatementResult(block: GetStatementResultRequest.Builder.() -> Unit) = getStatementResult(GetStatementResultRequest.Builder().apply(block).build())

    /**
     * List the databases in a cluster. A token is returned to page through the database list. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun listDatabases(input: ListDatabasesRequest): ListDatabasesResponse

    /**
     * List the databases in a cluster. A token is returned to page through the database list. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun listDatabases(block: ListDatabasesRequest.Builder.() -> Unit) = listDatabases(ListDatabasesRequest.Builder().apply(block).build())

    /**
     * Lists the schemas in a database. A token is returned to page through the schema list. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun listSchemas(input: ListSchemasRequest): ListSchemasResponse

    /**
     * Lists the schemas in a database. A token is returned to page through the schema list. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun listSchemas(block: ListSchemasRequest.Builder.() -> Unit) = listSchemas(ListSchemasRequest.Builder().apply(block).build())

    /**
     * List of SQL statements. By default, only finished statements are shown. A token is returned to page through the statement list.
     */
    suspend fun listStatements(input: ListStatementsRequest = ListStatementsRequest {}): ListStatementsResponse

    /**
     * List of SQL statements. By default, only finished statements are shown. A token is returned to page through the statement list.
     */
    suspend fun listStatements(block: ListStatementsRequest.Builder.() -> Unit) = listStatements(ListStatementsRequest.Builder().apply(block).build())

    /**
     * List the tables in a database. If neither `SchemaPattern` nor `TablePattern` are specified, then all tables in the database are returned. A token is returned to page through the table list. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun listTables(input: ListTablesRequest): ListTablesResponse

    /**
     * List the tables in a database. If neither `SchemaPattern` nor `TablePattern` are specified, then all tables in the database are returned. A token is returned to page through the table list. Depending on the authorization method, use one of the following combinations of request parameters:
     * + Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * + Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the `redshift:GetClusterCredentials` operation is required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also, permission to call the `redshift-serverless:GetCredentials` operation is required.
     */
    suspend fun listTables(block: ListTablesRequest.Builder.() -> Unit) = listTables(ListTablesRequest.Builder().apply(block).build())
}
