// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



public class BatchExecuteStatementRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
     */
    public val database: kotlin.String? = builder.database
    /**
     * The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials.
     */
    public val dbUser: kotlin.String? = builder.dbUser
    /**
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * One or more SQL statements to run. The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don't start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.
     */
    public val sqls: List<String>? = builder.sqls
    /**
     * The name of the SQL statements. You can name the SQL statements when you create them to identify the query.
     */
    public val statementName: kotlin.String? = builder.statementName
    /**
     * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run.
     */
    public val withEvent: kotlin.Boolean? = builder.withEvent
    /**
     * The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftdata.model.BatchExecuteStatementRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchExecuteStatementRequest(")
        append("clientToken=$clientToken,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("secretArn=$secretArn,")
        append("sqls=$sqls,")
        append("statementName=$statementName,")
        append("withEvent=$withEvent,")
        append("workgroupName=$workgroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (sqls?.hashCode() ?: 0)
        result = 31 * result + (statementName?.hashCode() ?: 0)
        result = 31 * result + (withEvent?.hashCode() ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchExecuteStatementRequest

        if (clientToken != other.clientToken) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (secretArn != other.secretArn) return false
        if (sqls != other.sqls) return false
        if (statementName != other.statementName) return false
        if (withEvent != other.withEvent) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftdata.model.BatchExecuteStatementRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        public var database: kotlin.String? = null
        /**
         * The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials.
         */
        public var dbUser: kotlin.String? = null
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        public var secretArn: kotlin.String? = null
        /**
         * One or more SQL statements to run. The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don't start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.
         */
        public var sqls: List<String>? = null
        /**
         * The name of the SQL statements. You can name the SQL statements when you create them to identify the query.
         */
        public var statementName: kotlin.String? = null
        /**
         * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run.
         */
        public var withEvent: kotlin.Boolean? = null
        /**
         * The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
         */
        public var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftdata.model.BatchExecuteStatementRequest) : this() {
            this.clientToken = x.clientToken
            this.clusterIdentifier = x.clusterIdentifier
            this.database = x.database
            this.dbUser = x.dbUser
            this.secretArn = x.secretArn
            this.sqls = x.sqls
            this.statementName = x.statementName
            this.withEvent = x.withEvent
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftdata.model.BatchExecuteStatementRequest = BatchExecuteStatementRequest(this)
    }
}
