// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



public class ListDatabasesRequest private constructor(builder: Builder) {
    /**
     * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
     */
    public val database: kotlin.String? = builder.database
    /**
     * The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials.
     */
    public val dbUser: kotlin.String? = builder.dbUser
    /**
     * The maximum number of databases to return in the response. If more databases exist than fit in one response, then `NextToken` is returned to page through the results.
     */
    public val maxResults: kotlin.Int = builder.maxResults
    /**
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftdata.model.ListDatabasesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDatabasesRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("secretArn=$secretArn,")
        append("workgroupName=$workgroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDatabasesRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (secretArn != other.secretArn) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftdata.model.ListDatabasesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        public var database: kotlin.String? = null
        /**
         * The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials.
         */
        public var dbUser: kotlin.String? = null
        /**
         * The maximum number of databases to return in the response. If more databases exist than fit in one response, then `NextToken` is returned to page through the results.
         */
        public var maxResults: kotlin.Int = 0
        /**
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
         */
        public var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftdata.model.ListDatabasesRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.database = x.database
            this.dbUser = x.dbUser
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.secretArn = x.secretArn
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftdata.model.ListDatabasesRequest = ListDatabasesRequest(this)
    }
}
