// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



public class ListStatementsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then `NextToken` is returned to page through the results.
     */
    public val maxResults: kotlin.Int = builder.maxResults
    /**
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true.
     */
    public val roleLevel: kotlin.Boolean? = builder.roleLevel
    /**
     * The name of the SQL statement specified as input to `BatchExecuteStatement` or `ExecuteStatement` to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of `myStatement`. Data API does a case-sensitive match of SQL statement names to the prefix value you provide.
     */
    public val statementName: kotlin.String? = builder.statementName
    /**
     * The status of the SQL statement to list. Status values are defined as follows:
     * + ABORTED - The query run was stopped by the user.
     * + ALL - A status value that includes all query statuses. This value can be used to filter results.
     * + FAILED - The query run failed.
     * + FINISHED - The query has finished running.
     * + PICKED - The query has been chosen to be run.
     * + STARTED - The query run has started.
     * + SUBMITTED - The query was submitted, but not yet processed.
     */
    public val status: aws.sdk.kotlin.services.redshiftdata.model.StatusString? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftdata.model.ListStatementsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListStatementsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("roleLevel=$roleLevel,")
        append("statementName=$statementName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (roleLevel?.hashCode() ?: 0)
        result = 31 * result + (statementName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListStatementsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (roleLevel != other.roleLevel) return false
        if (statementName != other.statementName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftdata.model.ListStatementsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then `NextToken` is returned to page through the results.
         */
        public var maxResults: kotlin.Int = 0
        /**
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true.
         */
        public var roleLevel: kotlin.Boolean? = null
        /**
         * The name of the SQL statement specified as input to `BatchExecuteStatement` or `ExecuteStatement` to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of `myStatement`. Data API does a case-sensitive match of SQL statement names to the prefix value you provide.
         */
        public var statementName: kotlin.String? = null
        /**
         * The status of the SQL statement to list. Status values are defined as follows:
         * + ABORTED - The query run was stopped by the user.
         * + ALL - A status value that includes all query statuses. This value can be used to filter results.
         * + FAILED - The query run failed.
         * + FINISHED - The query has finished running.
         * + PICKED - The query has been chosen to be run.
         * + STARTED - The query run has started.
         * + SUBMITTED - The query was submitted, but not yet processed.
         */
        public var status: aws.sdk.kotlin.services.redshiftdata.model.StatusString? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftdata.model.ListStatementsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.roleLevel = x.roleLevel
            this.statementName = x.statementName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftdata.model.ListStatementsRequest = ListStatementsRequest(this)
    }
}
