// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.redshiftdata.model.BatchExecuteStatementResponse
import aws.sdk.kotlin.services.redshiftdata.model.RedshiftDataException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class BatchExecuteStatementOperationDeserializer: HttpDeserialize<BatchExecuteStatementResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchExecuteStatementResponse {
        if (!response.status.isSuccess()) {
            throwBatchExecuteStatementError(context, response)
        }
        val builder = BatchExecuteStatementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchExecuteStatementOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchExecuteStatementError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RedshiftDataException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ActiveStatementsExceededException" -> ActiveStatementsExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "BatchExecuteStatementException" -> BatchExecuteStatementExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchExecuteStatementOperationBody(builder: BatchExecuteStatementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterIdentifier"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DATABASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Database"))
    val DBUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DbUser"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val SECRETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretArn"))
    val WORKGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkgroupName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DATABASE_DESCRIPTOR)
        field(DBUSER_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(SECRETARN_DESCRIPTOR)
        field(WORKGROUPNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.clusterIdentifier = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATABASE_DESCRIPTOR.index -> builder.database = deserializeString()
                DBUSER_DESCRIPTOR.index -> builder.dbUser = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                SECRETARN_DESCRIPTOR.index -> builder.secretArn = deserializeString()
                WORKGROUPNAME_DESCRIPTOR.index -> builder.workgroupName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
