// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.redshiftdata.model.*
import aws.sdk.kotlin.services.redshiftdata.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Redshift Data"
const val ServiceApiVersion: String = "2019-12-20"
const val SdkVersion: String = "0.9.0-alpha"

internal class DefaultRedshiftDataClient(override val config: RedshiftDataClient.Config) : RedshiftDataClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Runs one or more SQL statements, which can be data manipulation language (DML) or data definition
     * language (DDL).
     * Depending on the authorization
     * method, use one of the following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    override suspend fun batchExecuteStatement(input: BatchExecuteStatementRequest): BatchExecuteStatementResponse {
        val op = SdkHttpOperation.build<BatchExecuteStatementRequest, BatchExecuteStatementResponse> {
            serializer = BatchExecuteStatementOperationSerializer()
            deserializer = BatchExecuteStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchExecuteStatement"
            }
        }
        registerBatchExecuteStatementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a running query. To be canceled, a query must be running.
     */
    override suspend fun cancelStatement(input: CancelStatementRequest): CancelStatementResponse {
        val op = SdkHttpOperation.build<CancelStatementRequest, CancelStatementResponse> {
            serializer = CancelStatementOperationSerializer()
            deserializer = CancelStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelStatement"
            }
        }
        registerCancelStatementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The information
     * includes when the query started, when it finished, the query status, the number of rows returned, and the SQL
     * statement.
     */
    override suspend fun describeStatement(input: DescribeStatementRequest): DescribeStatementResponse {
        val op = SdkHttpOperation.build<DescribeStatementRequest, DescribeStatementResponse> {
            serializer = DescribeStatementOperationSerializer()
            deserializer = DescribeStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStatement"
            }
        }
        registerDescribeStatementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the detailed information about a table from metadata in the cluster. The
     * information includes its columns.
     * A token is returned to page through the column list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the database
     * user name. Permission to call the redshift:GetClusterCredentials operation is
     * required to use this method.
     */
    override suspend fun describeTable(input: DescribeTableRequest): DescribeTableResponse {
        val op = SdkHttpOperation.build<DescribeTableRequest, DescribeTableResponse> {
            serializer = DescribeTableOperationSerializer()
            deserializer = DescribeTableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTable"
            }
        }
        registerDescribeTableMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Runs an SQL statement, which can be data manipulation language (DML) or data definition
     * language (DDL). This statement must be a single SQL statement.
     * Depending on the authorization
     * method, use one of the following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    override suspend fun executeStatement(input: ExecuteStatementRequest): ExecuteStatementResponse {
        val op = SdkHttpOperation.build<ExecuteStatementRequest, ExecuteStatementResponse> {
            serializer = ExecuteStatementOperationSerializer()
            deserializer = ExecuteStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExecuteStatement"
            }
        }
        registerExecuteStatementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Fetches the temporarily cached result of an SQL statement.
     * A token is returned to page through the statement results.
     */
    override suspend fun getStatementResult(input: GetStatementResultRequest): GetStatementResultResponse {
        val op = SdkHttpOperation.build<GetStatementResultRequest, GetStatementResultResponse> {
            serializer = GetStatementResultOperationSerializer()
            deserializer = GetStatementResultOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStatementResult"
            }
        }
        registerGetStatementResultMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List the databases in a cluster.
     * A token is returned to page through the database list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    override suspend fun listDatabases(input: ListDatabasesRequest): ListDatabasesResponse {
        val op = SdkHttpOperation.build<ListDatabasesRequest, ListDatabasesResponse> {
            serializer = ListDatabasesOperationSerializer()
            deserializer = ListDatabasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDatabases"
            }
        }
        registerListDatabasesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the schemas in a database.
     * A token is returned to page through the schema list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    override suspend fun listSchemas(input: ListSchemasRequest): ListSchemasResponse {
        val op = SdkHttpOperation.build<ListSchemasRequest, ListSchemasResponse> {
            serializer = ListSchemasOperationSerializer()
            deserializer = ListSchemasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSchemas"
            }
        }
        registerListSchemasMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List of SQL statements. By default, only finished statements are shown.
     * A token is returned to page through the statement list.
     */
    override suspend fun listStatements(input: ListStatementsRequest): ListStatementsResponse {
        val op = SdkHttpOperation.build<ListStatementsRequest, ListStatementsResponse> {
            serializer = ListStatementsOperationSerializer()
            deserializer = ListStatementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStatements"
            }
        }
        registerListStatementsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List the tables in a database. If neither SchemaPattern nor TablePattern are specified, then
     * all tables in the database are returned.
     * A token is returned to page through the table list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    override suspend fun listTables(input: ListTablesRequest): ListTablesResponse {
        val op = SdkHttpOperation.build<ListTablesRequest, ListTablesResponse> {
            serializer = ListTablesOperationSerializer()
            deserializer = ListTablesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTables"
            }
        }
        registerListTablesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
