// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.redshiftdata.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.redshiftdata.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * You can use the Amazon Redshift Data API to run queries on Amazon Redshift tables. You
 * can run SQL statements, which are committed if the statement succeeds.
 * For more information about the Amazon Redshift Data API, see
 * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API in the
 * Amazon Redshift Cluster Management Guide.
 */
interface RedshiftDataClient : SdkClient {

    override val serviceName: String
        get() = "Redshift Data"
    /**
     * RedshiftDataClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): RedshiftDataClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultRedshiftDataClient(config)
        }

        operator fun invoke(config: Config): RedshiftDataClient = DefaultRedshiftDataClient(config)

        /**
         * Construct a [RedshiftDataClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): RedshiftDataClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return RedshiftDataClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Runs one or more SQL statements, which can be data manipulation language (DML) or data definition
     * language (DDL).
     * Depending on the authorization
     * method, use one of the following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun batchExecuteStatement(input: BatchExecuteStatementRequest): BatchExecuteStatementResponse

    /**
     * Runs one or more SQL statements, which can be data manipulation language (DML) or data definition
     * language (DDL).
     * Depending on the authorization
     * method, use one of the following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun batchExecuteStatement(block: BatchExecuteStatementRequest.DslBuilder.() -> Unit) = batchExecuteStatement(BatchExecuteStatementRequest.builder().apply(block).build())

    /**
     * Cancels a running query. To be canceled, a query must be running.
     */
    suspend fun cancelStatement(input: CancelStatementRequest): CancelStatementResponse

    /**
     * Cancels a running query. To be canceled, a query must be running.
     */
    suspend fun cancelStatement(block: CancelStatementRequest.DslBuilder.() -> Unit) = cancelStatement(CancelStatementRequest.builder().apply(block).build())

    /**
     * Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The information
     * includes when the query started, when it finished, the query status, the number of rows returned, and the SQL
     * statement.
     */
    suspend fun describeStatement(input: DescribeStatementRequest): DescribeStatementResponse

    /**
     * Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The information
     * includes when the query started, when it finished, the query status, the number of rows returned, and the SQL
     * statement.
     */
    suspend fun describeStatement(block: DescribeStatementRequest.DslBuilder.() -> Unit) = describeStatement(DescribeStatementRequest.builder().apply(block).build())

    /**
     * Describes the detailed information about a table from metadata in the cluster. The
     * information includes its columns.
     * A token is returned to page through the column list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the database
     * user name. Permission to call the redshift:GetClusterCredentials operation is
     * required to use this method.
     */
    suspend fun describeTable(input: DescribeTableRequest): DescribeTableResponse

    /**
     * Describes the detailed information about a table from metadata in the cluster. The
     * information includes its columns.
     * A token is returned to page through the column list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the database
     * user name. Permission to call the redshift:GetClusterCredentials operation is
     * required to use this method.
     */
    suspend fun describeTable(block: DescribeTableRequest.DslBuilder.() -> Unit) = describeTable(DescribeTableRequest.builder().apply(block).build())

    /**
     * Runs an SQL statement, which can be data manipulation language (DML) or data definition
     * language (DDL). This statement must be a single SQL statement.
     * Depending on the authorization
     * method, use one of the following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun executeStatement(input: ExecuteStatementRequest): ExecuteStatementResponse

    /**
     * Runs an SQL statement, which can be data manipulation language (DML) or data definition
     * language (DDL). This statement must be a single SQL statement.
     * Depending on the authorization
     * method, use one of the following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun executeStatement(block: ExecuteStatementRequest.DslBuilder.() -> Unit) = executeStatement(ExecuteStatementRequest.builder().apply(block).build())

    /**
     * Fetches the temporarily cached result of an SQL statement.
     * A token is returned to page through the statement results.
     */
    suspend fun getStatementResult(input: GetStatementResultRequest): GetStatementResultResponse

    /**
     * Fetches the temporarily cached result of an SQL statement.
     * A token is returned to page through the statement results.
     */
    suspend fun getStatementResult(block: GetStatementResultRequest.DslBuilder.() -> Unit) = getStatementResult(GetStatementResultRequest.builder().apply(block).build())

    /**
     * List the databases in a cluster.
     * A token is returned to page through the database list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun listDatabases(input: ListDatabasesRequest): ListDatabasesResponse

    /**
     * List the databases in a cluster.
     * A token is returned to page through the database list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun listDatabases(block: ListDatabasesRequest.DslBuilder.() -> Unit) = listDatabases(ListDatabasesRequest.builder().apply(block).build())

    /**
     * Lists the schemas in a database.
     * A token is returned to page through the schema list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun listSchemas(input: ListSchemasRequest): ListSchemasResponse

    /**
     * Lists the schemas in a database.
     * A token is returned to page through the schema list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun listSchemas(block: ListSchemasRequest.DslBuilder.() -> Unit) = listSchemas(ListSchemasRequest.builder().apply(block).build())

    /**
     * List of SQL statements. By default, only finished statements are shown.
     * A token is returned to page through the statement list.
     */
    suspend fun listStatements(input: ListStatementsRequest): ListStatementsResponse

    /**
     * List of SQL statements. By default, only finished statements are shown.
     * A token is returned to page through the statement list.
     */
    suspend fun listStatements(block: ListStatementsRequest.DslBuilder.() -> Unit) = listStatements(ListStatementsRequest.builder().apply(block).build())

    /**
     * List the tables in a database. If neither SchemaPattern nor TablePattern are specified, then
     * all tables in the database are returned.
     * A token is returned to page through the table list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun listTables(input: ListTablesRequest): ListTablesResponse

    /**
     * List the tables in a database. If neither SchemaPattern nor TablePattern are specified, then
     * all tables in the database are returned.
     * A token is returned to page through the table list.
     * Depending on the authorization method, use one of the
     * following combinations of request parameters:
     * Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the
     * cluster identifier that matches the cluster in the secret.
     * Temporary credentials - specify the cluster identifier, the database name, and the
     * database user name. Permission to call the redshift:GetClusterCredentials
     * operation is required to use this method.
     */
    suspend fun listTables(block: ListTablesRequest.DslBuilder.() -> Unit) = listTables(ListTablesRequest.builder().apply(block).build())
}
