// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



class BatchExecuteStatementRequest private constructor(builder: BuilderImpl) {
    /**
     * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
     */
    val database: String? = builder.database
    /**
     * The database user name. This parameter is required when authenticating using temporary credentials.
     */
    val dbUser: String? = builder.dbUser
    /**
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
     */
    val secretArn: String? = builder.secretArn
    /**
     * One or more SQL statements to run.
     */
    val sqls: List<String>? = builder.sqls
    /**
     * The name of the SQL statements. You can name the SQL statements when you create them to identify the query.
     */
    val statementName: String? = builder.statementName
    /**
     * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run.
     */
    val withEvent: Boolean? = builder.withEvent

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BatchExecuteStatementRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BatchExecuteStatementRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("secretArn=$secretArn,")
        append("sqls=$sqls,")
        append("statementName=$statementName,")
        append("withEvent=$withEvent)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (sqls?.hashCode() ?: 0)
        result = 31 * result + (statementName?.hashCode() ?: 0)
        result = 31 * result + (withEvent?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BatchExecuteStatementRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (secretArn != other.secretArn) return false
        if (sqls != other.sqls) return false
        if (statementName != other.statementName) return false
        if (withEvent != other.withEvent) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BatchExecuteStatementRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BatchExecuteStatementRequest
        /**
         * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        fun database(database: String): FluentBuilder
        /**
         * The database user name. This parameter is required when authenticating using temporary credentials.
         */
        fun dbUser(dbUser: String): FluentBuilder
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        fun secretArn(secretArn: String): FluentBuilder
        /**
         * One or more SQL statements to run.
         */
        fun sqls(sqls: List<String>): FluentBuilder
        /**
         * The name of the SQL statements. You can name the SQL statements when you create them to identify the query.
         */
        fun statementName(statementName: String): FluentBuilder
        /**
         * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run.
         */
        fun withEvent(withEvent: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        var clusterIdentifier: String?
        /**
         * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        var database: String?
        /**
         * The database user name. This parameter is required when authenticating using temporary credentials.
         */
        var dbUser: String?
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        var secretArn: String?
        /**
         * One or more SQL statements to run.
         */
        var sqls: List<String>?
        /**
         * The name of the SQL statements. You can name the SQL statements when you create them to identify the query.
         */
        var statementName: String?
        /**
         * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run.
         */
        var withEvent: Boolean?

        fun build(): BatchExecuteStatementRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var database: String? = null
        override var dbUser: String? = null
        override var secretArn: String? = null
        override var sqls: List<String>? = null
        override var statementName: String? = null
        override var withEvent: Boolean? = null

        constructor(x: BatchExecuteStatementRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.database = x.database
            this.dbUser = x.dbUser
            this.secretArn = x.secretArn
            this.sqls = x.sqls
            this.statementName = x.statementName
            this.withEvent = x.withEvent
        }

        override fun build(): BatchExecuteStatementRequest = BatchExecuteStatementRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun database(database: String): FluentBuilder = apply { this.database = database }
        override fun dbUser(dbUser: String): FluentBuilder = apply { this.dbUser = dbUser }
        override fun secretArn(secretArn: String): FluentBuilder = apply { this.secretArn = secretArn }
        override fun sqls(sqls: List<String>): FluentBuilder = apply { this.sqls = sqls }
        override fun statementName(statementName: String): FluentBuilder = apply { this.statementName = statementName }
        override fun withEvent(withEvent: Boolean): FluentBuilder = apply { this.withEvent = withEvent }
    }
}
