// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeStatementResponse private constructor(builder: BuilderImpl) {
    /**
     * The cluster identifier.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The date and time (UTC) when the SQL statement was submitted to run.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The name of the database.
     */
    val database: String? = builder.database
    /**
     * The database user name.
     */
    val dbUser: String? = builder.dbUser
    /**
     * The amount of time in nanoseconds that the statement ran.
     */
    val duration: Long = builder.duration
    /**
     * The error message from the cluster if the SQL statement encountered an error while running.
     */
    val error: String? = builder.error
    /**
     * A value that indicates whether the statement has a result set. The result set can be empty.
     */
    val hasResultSet: Boolean? = builder.hasResultSet
    /**
     * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
     */
    val id: String? = builder.id
    /**
     * The parameters for the SQL statement.
     */
    val queryParameters: List<SqlParameter>? = builder.queryParameters
    /**
     * The SQL statement text.
     */
    val queryString: String? = builder.queryString
    /**
     * The process identifier from Amazon Redshift.
     */
    val redshiftPid: Long = builder.redshiftPid
    /**
     * The identifier of the query generated by Amazon Redshift.
     * These identifiers are also available in the query column of the STL_QUERY system view.
     */
    val redshiftQueryId: Long = builder.redshiftQueryId
    /**
     * Either the number of rows returned from the SQL statement or the number of rows affected.
     * If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others.
     * A -1 indicates the value is null.
     */
    val resultRows: Long = builder.resultRows
    /**
     * The size in bytes of the returned results. A -1 indicates the value is null.
     */
    val resultSize: Long = builder.resultSize
    /**
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */
    val secretArn: String? = builder.secretArn
    /**
     * The status of the SQL statement being described. Status values are defined as follows:
     * ABORTED - The query run was stopped by the user.
     * ALL -  A status value that includes all query statuses. This value can be used to filter results.
     * FAILED - The query run failed.
     * FINISHED - The query has finished running.
     * PICKED - The query has been chosen to be run.
     * STARTED - The query run has started.
     * SUBMITTED - The query was submitted, but not yet processed.
     */
    val status: StatusString? = builder.status
    /**
     * The SQL statements from a multiple statement run.
     */
    val subStatements: List<SubStatementData>? = builder.subStatements
    /**
     * The date and time (UTC) that the metadata for the SQL statement was last updated. An
     * example is the time the status last changed.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeStatementResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStatementResponse(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("createdAt=$createdAt,")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("duration=$duration,")
        append("error=$error,")
        append("hasResultSet=$hasResultSet,")
        append("id=$id,")
        append("queryParameters=$queryParameters,")
        append("queryString=$queryString,")
        append("redshiftPid=$redshiftPid,")
        append("redshiftQueryId=$redshiftQueryId,")
        append("resultRows=$resultRows,")
        append("resultSize=$resultSize,")
        append("secretArn=$secretArn,")
        append("status=$status,")
        append("subStatements=$subStatements,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (duration.hashCode())
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (hasResultSet?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (queryParameters?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (redshiftPid.hashCode())
        result = 31 * result + (redshiftQueryId.hashCode())
        result = 31 * result + (resultRows.hashCode())
        result = 31 * result + (resultSize.hashCode())
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subStatements?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeStatementResponse

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (createdAt != other.createdAt) return false
        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (duration != other.duration) return false
        if (error != other.error) return false
        if (hasResultSet != other.hasResultSet) return false
        if (id != other.id) return false
        if (queryParameters != other.queryParameters) return false
        if (queryString != other.queryString) return false
        if (redshiftPid != other.redshiftPid) return false
        if (redshiftQueryId != other.redshiftQueryId) return false
        if (resultRows != other.resultRows) return false
        if (resultSize != other.resultSize) return false
        if (secretArn != other.secretArn) return false
        if (status != other.status) return false
        if (subStatements != other.subStatements) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeStatementResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeStatementResponse
        /**
         * The cluster identifier.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The date and time (UTC) when the SQL statement was submitted to run.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The name of the database.
         */
        fun database(database: String): FluentBuilder
        /**
         * The database user name.
         */
        fun dbUser(dbUser: String): FluentBuilder
        /**
         * The amount of time in nanoseconds that the statement ran.
         */
        fun duration(duration: Long): FluentBuilder
        /**
         * The error message from the cluster if the SQL statement encountered an error while running.
         */
        fun error(error: String): FluentBuilder
        /**
         * A value that indicates whether the statement has a result set. The result set can be empty.
         */
        fun hasResultSet(hasResultSet: Boolean): FluentBuilder
        /**
         * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
         */
        fun id(id: String): FluentBuilder
        /**
         * The parameters for the SQL statement.
         */
        fun queryParameters(queryParameters: List<SqlParameter>): FluentBuilder
        /**
         * The SQL statement text.
         */
        fun queryString(queryString: String): FluentBuilder
        /**
         * The process identifier from Amazon Redshift.
         */
        fun redshiftPid(redshiftPid: Long): FluentBuilder
        /**
         * The identifier of the query generated by Amazon Redshift.
         * These identifiers are also available in the query column of the STL_QUERY system view.
         */
        fun redshiftQueryId(redshiftQueryId: Long): FluentBuilder
        /**
         * Either the number of rows returned from the SQL statement or the number of rows affected.
         * If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others.
         * A -1 indicates the value is null.
         */
        fun resultRows(resultRows: Long): FluentBuilder
        /**
         * The size in bytes of the returned results. A -1 indicates the value is null.
         */
        fun resultSize(resultSize: Long): FluentBuilder
        /**
         * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         */
        fun secretArn(secretArn: String): FluentBuilder
        /**
         * The status of the SQL statement being described. Status values are defined as follows:
         * ABORTED - The query run was stopped by the user.
         * ALL -  A status value that includes all query statuses. This value can be used to filter results.
         * FAILED - The query run failed.
         * FINISHED - The query has finished running.
         * PICKED - The query has been chosen to be run.
         * STARTED - The query run has started.
         * SUBMITTED - The query was submitted, but not yet processed.
         */
        fun status(status: StatusString): FluentBuilder
        /**
         * The SQL statements from a multiple statement run.
         */
        fun subStatements(subStatements: List<SubStatementData>): FluentBuilder
        /**
         * The date and time (UTC) that the metadata for the SQL statement was last updated. An
         * example is the time the status last changed.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The cluster identifier.
         */
        var clusterIdentifier: String?
        /**
         * The date and time (UTC) when the SQL statement was submitted to run.
         */
        var createdAt: Instant?
        /**
         * The name of the database.
         */
        var database: String?
        /**
         * The database user name.
         */
        var dbUser: String?
        /**
         * The amount of time in nanoseconds that the statement ran.
         */
        var duration: Long
        /**
         * The error message from the cluster if the SQL statement encountered an error while running.
         */
        var error: String?
        /**
         * A value that indicates whether the statement has a result set. The result set can be empty.
         */
        var hasResultSet: Boolean?
        /**
         * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
         */
        var id: String?
        /**
         * The parameters for the SQL statement.
         */
        var queryParameters: List<SqlParameter>?
        /**
         * The SQL statement text.
         */
        var queryString: String?
        /**
         * The process identifier from Amazon Redshift.
         */
        var redshiftPid: Long
        /**
         * The identifier of the query generated by Amazon Redshift.
         * These identifiers are also available in the query column of the STL_QUERY system view.
         */
        var redshiftQueryId: Long
        /**
         * Either the number of rows returned from the SQL statement or the number of rows affected.
         * If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others.
         * A -1 indicates the value is null.
         */
        var resultRows: Long
        /**
         * The size in bytes of the returned results. A -1 indicates the value is null.
         */
        var resultSize: Long
        /**
         * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         */
        var secretArn: String?
        /**
         * The status of the SQL statement being described. Status values are defined as follows:
         * ABORTED - The query run was stopped by the user.
         * ALL -  A status value that includes all query statuses. This value can be used to filter results.
         * FAILED - The query run failed.
         * FINISHED - The query has finished running.
         * PICKED - The query has been chosen to be run.
         * STARTED - The query run has started.
         * SUBMITTED - The query was submitted, but not yet processed.
         */
        var status: StatusString?
        /**
         * The SQL statements from a multiple statement run.
         */
        var subStatements: List<SubStatementData>?
        /**
         * The date and time (UTC) that the metadata for the SQL statement was last updated. An
         * example is the time the status last changed.
         */
        var updatedAt: Instant?

        fun build(): DescribeStatementResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var createdAt: Instant? = null
        override var database: String? = null
        override var dbUser: String? = null
        override var duration: Long = 0L
        override var error: String? = null
        override var hasResultSet: Boolean? = null
        override var id: String? = null
        override var queryParameters: List<SqlParameter>? = null
        override var queryString: String? = null
        override var redshiftPid: Long = 0L
        override var redshiftQueryId: Long = 0L
        override var resultRows: Long = 0L
        override var resultSize: Long = 0L
        override var secretArn: String? = null
        override var status: StatusString? = null
        override var subStatements: List<SubStatementData>? = null
        override var updatedAt: Instant? = null

        constructor(x: DescribeStatementResponse) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.createdAt = x.createdAt
            this.database = x.database
            this.dbUser = x.dbUser
            this.duration = x.duration
            this.error = x.error
            this.hasResultSet = x.hasResultSet
            this.id = x.id
            this.queryParameters = x.queryParameters
            this.queryString = x.queryString
            this.redshiftPid = x.redshiftPid
            this.redshiftQueryId = x.redshiftQueryId
            this.resultRows = x.resultRows
            this.resultSize = x.resultSize
            this.secretArn = x.secretArn
            this.status = x.status
            this.subStatements = x.subStatements
            this.updatedAt = x.updatedAt
        }

        override fun build(): DescribeStatementResponse = DescribeStatementResponse(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun database(database: String): FluentBuilder = apply { this.database = database }
        override fun dbUser(dbUser: String): FluentBuilder = apply { this.dbUser = dbUser }
        override fun duration(duration: Long): FluentBuilder = apply { this.duration = duration }
        override fun error(error: String): FluentBuilder = apply { this.error = error }
        override fun hasResultSet(hasResultSet: Boolean): FluentBuilder = apply { this.hasResultSet = hasResultSet }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun queryParameters(queryParameters: List<SqlParameter>): FluentBuilder = apply { this.queryParameters = queryParameters }
        override fun queryString(queryString: String): FluentBuilder = apply { this.queryString = queryString }
        override fun redshiftPid(redshiftPid: Long): FluentBuilder = apply { this.redshiftPid = redshiftPid }
        override fun redshiftQueryId(redshiftQueryId: Long): FluentBuilder = apply { this.redshiftQueryId = redshiftQueryId }
        override fun resultRows(resultRows: Long): FluentBuilder = apply { this.resultRows = resultRows }
        override fun resultSize(resultSize: Long): FluentBuilder = apply { this.resultSize = resultSize }
        override fun secretArn(secretArn: String): FluentBuilder = apply { this.secretArn = secretArn }
        override fun status(status: StatusString): FluentBuilder = apply { this.status = status }
        override fun subStatements(subStatements: List<SubStatementData>): FluentBuilder = apply { this.subStatements = subStatements }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
