// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



class ExecuteStatementRequest private constructor(builder: BuilderImpl) {
    /**
     * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
     */
    val database: String? = builder.database
    /**
     * The database user name. This parameter is required when authenticating using temporary credentials.
     */
    val dbUser: String? = builder.dbUser
    /**
     * The parameters for the SQL statement.
     */
    val parameters: List<SqlParameter>? = builder.parameters
    /**
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
     */
    val secretArn: String? = builder.secretArn
    /**
     * The SQL statement text to run.
     */
    val sql: String? = builder.sql
    /**
     * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    val statementName: String? = builder.statementName
    /**
     * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
     */
    val withEvent: Boolean? = builder.withEvent

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExecuteStatementRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteStatementRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("parameters=$parameters,")
        append("secretArn=$secretArn,")
        append("sql=$sql,")
        append("statementName=$statementName,")
        append("withEvent=$withEvent)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (sql?.hashCode() ?: 0)
        result = 31 * result + (statementName?.hashCode() ?: 0)
        result = 31 * result + (withEvent?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExecuteStatementRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (parameters != other.parameters) return false
        if (secretArn != other.secretArn) return false
        if (sql != other.sql) return false
        if (statementName != other.statementName) return false
        if (withEvent != other.withEvent) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExecuteStatementRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExecuteStatementRequest
        /**
         * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        fun database(database: String): FluentBuilder
        /**
         * The database user name. This parameter is required when authenticating using temporary credentials.
         */
        fun dbUser(dbUser: String): FluentBuilder
        /**
         * The parameters for the SQL statement.
         */
        fun parameters(parameters: List<SqlParameter>): FluentBuilder
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        fun secretArn(secretArn: String): FluentBuilder
        /**
         * The SQL statement text to run.
         */
        fun sql(sql: String): FluentBuilder
        /**
         * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
         */
        fun statementName(statementName: String): FluentBuilder
        /**
         * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
         */
        fun withEvent(withEvent: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        var clusterIdentifier: String?
        /**
         * The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        var database: String?
        /**
         * The database user name. This parameter is required when authenticating using temporary credentials.
         */
        var dbUser: String?
        /**
         * The parameters for the SQL statement.
         */
        var parameters: List<SqlParameter>?
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        var secretArn: String?
        /**
         * The SQL statement text to run.
         */
        var sql: String?
        /**
         * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
         */
        var statementName: String?
        /**
         * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
         */
        var withEvent: Boolean?

        fun build(): ExecuteStatementRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var database: String? = null
        override var dbUser: String? = null
        override var parameters: List<SqlParameter>? = null
        override var secretArn: String? = null
        override var sql: String? = null
        override var statementName: String? = null
        override var withEvent: Boolean? = null

        constructor(x: ExecuteStatementRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.database = x.database
            this.dbUser = x.dbUser
            this.parameters = x.parameters
            this.secretArn = x.secretArn
            this.sql = x.sql
            this.statementName = x.statementName
            this.withEvent = x.withEvent
        }

        override fun build(): ExecuteStatementRequest = ExecuteStatementRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun database(database: String): FluentBuilder = apply { this.database = database }
        override fun dbUser(dbUser: String): FluentBuilder = apply { this.dbUser = dbUser }
        override fun parameters(parameters: List<SqlParameter>): FluentBuilder = apply { this.parameters = parameters }
        override fun secretArn(secretArn: String): FluentBuilder = apply { this.secretArn = secretArn }
        override fun sql(sql: String): FluentBuilder = apply { this.sql = sql }
        override fun statementName(statementName: String): FluentBuilder = apply { this.statementName = statementName }
        override fun withEvent(withEvent: Boolean): FluentBuilder = apply { this.withEvent = withEvent }
    }
}
